/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.induction.base;

import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.induction.helper.InductionFormHelper;
import kd.tsc.tso.business.domain.offer.bo.OfferHeadInfoBO;
import kd.tsc.tso.business.domain.offer.helper.OfferOnlyViewHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferStatusHelper;
import kd.tsc.tso.business.domain.offer.service.head.OfferHeadFormPluginService;
import kd.tsc.tso.business.domain.offer.service.head.OfferHeadInfoService;
import kd.tsc.tso.common.constants.offer.OfferHeadInfoConstants;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.enums.offer.status.IOfferStatus;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class InductionInfoHeadPlugin
extends AbstractOfferDynamicFramePlugin
implements OfferHeadInfoConstants {
    private final OfferHeadInfoService headInfoService = OfferHeadInfoService.getInstance();
    private final OfferHeadFormPluginService formPluginService = OfferHeadFormPluginService.getInstance();
    private final OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"appfilevector"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OfferHeadInfoBO headInfoBO = new OfferHeadInfoBO();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (HRStringUtils.equals((String)((String)formShowParameter.getCustomParam("fromPage")), (String)"appFilePage")) {
            headInfoBO.setNumber((String)formShowParameter.getCustomParam("number"));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_recrutyp");
            DynamicObject recrutypeDy = serviceHelper.queryOne((Object)1020L);
            if (!HRObjectUtils.isEmpty((Object)recrutypeDy)) {
                headInfoBO.setRecruitType(recrutypeDy.getString("name"));
            }
            headInfoBO.setApplicantName(RequestContext.get().getUserName());
            headInfoBO.setApplyTime(HRInteDateTimeUtil.formatDate((String)"tso_inductionform", (String)"applytime", (Date)new Date()));
            this.formPluginService.initPageInfo(this.getView(), headInfoBO);
            Label statusLbl = (Label)this.getView().getControl("status");
            statusLbl.setText(InductionStatus.getInductionStatus((String)"1").getName());
            Label busunitname = (Label)this.getView().getControl("busunitname");
            busunitname.setText((String)formShowParameter.getCustomParam("busunit.name"));
            this.getView().updateControlMetadata("status", OfferStatusHelper.getStatusMetaDataMap((IOfferStatus)InductionStatus.getInductionStatus((String)"1")));
            return;
        }
        OfferOnlyViewHelper.onlyViewForHeadInfo((IFormView)this.getView());
        DynamicObject inductionObj = InductionFormHelper.Singleton.INSTANCE.getInstance().queryOne((Object)this.headInfoService.getPkId(this.getView()));
        this.getModel().setValue("offer", (Object)inductionObj);
        headInfoBO.setNumber(inductionObj.getString("number"));
        DynamicObject recruitType = inductionObj.getDynamicObject("recrutyp");
        if (!HRObjectUtils.isEmpty((Object)recruitType)) {
            headInfoBO.setRecruitType(recruitType.getString("name"));
        }
        OperationStatus pageStatus = formShowParameter.getStatus();
        headInfoBO.setApplicantName(this.headInfoService.getApplicantName(pageStatus, inductionObj));
        headInfoBO.setApplyTime(this.getApplyTime(pageStatus, inductionObj));
        headInfoBO.setOfferStatus(this.headInfoService.getStatus(inductionObj));
        this.formPluginService.initPageInfo(this.getView(), headInfoBO);
        InductionStatus inductionStatus = InductionStatus.getInductionStatus((String)inductionObj.getString("inductionstatus"));
        Label statusLbl = (Label)this.getView().getControl("status");
        statusLbl.setText(inductionStatus.getName());
        Label busunitname = (Label)this.getView().getControl("busunitname");
        busunitname.setText(inductionObj.getString("busunit.name"));
        this.getView().updateControlMetadata("status", OfferStatusHelper.getStatusMetaDataMap((IOfferStatus)inductionStatus));
    }

    private String getApplyTime(OperationStatus pageStatus, DynamicObject dynamicObject) {
        if (!OfferUtils.checkHasProperty((DynamicObject)dynamicObject, (String)"applytime")) {
            return "-";
        }
        Date applyTime = null;
        if (dynamicObject.getDate("applytime") == null) {
            if (pageStatus == OperationStatus.EDIT) {
                applyTime = DateUtils.nowDateTime();
            }
        } else {
            applyTime = dynamicObject.getDate("applytime");
        }
        if (Objects.isNull(applyTime)) {
            return "-";
        }
        return HRInteDateTimeUtil.formatDate((String)"tso_inductionform", (String)"applytime", (Date)applyTime);
    }

    public void beforeClick(BeforeClickEvent beforeClickEvent) {
        super.beforeClick(beforeClickEvent);
        this.formPluginService.handleCddNameBeforeClickEvt(beforeClickEvent, this.getView());
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        this.formPluginService.handleCddNameLblClickEvt(eventObject, this.getView());
    }
}

