/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.moka.offer.btnplugin;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.Copy;
import kd.bos.list.IListView;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class MkOfferBtnCopyPlugin
extends AbstractOfferButtonPlugin {
    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        Object source = beforeDoOperationEventArgs.getSource();
        if (!this.checkIsCopyButton(source)) {
            return;
        }
        if (!(this.getView() instanceof IListView)) {
            this.getView().showTipNotification("only in list");
            return;
        }
        this.validateData(beforeDoOperationEventArgs);
    }

    private void validateData(BeforeDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5355\u4e2aOffer\u8fdb\u884c\u590d\u5236\u3002", (String)"OfferBtnCopyPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long currentOfferId = Long.parseLong(listView.getCurrentSelectedRowInfo().getPrimaryKeyValue().toString());
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne((Object)currentOfferId);
        if (!OfferUtils.checkAppFileInProcess((DynamicObject)offerInfo.getDynamicObject("appfile"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6863\u6848\u72b6\u6001\u4e3a\u201c\u6d41\u7a0b\u4e2d\u201d\u7684\u5019\u9009\u4eba\u8fdb\u884cOffer\u590d\u5236\u3002", (String)"OfferBtnCopyPlugin_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        OfferStatus offerStatus = OfferStatusUtil.getOfferStatus((DynamicObject)offerInfo);
        if (offerStatus != OfferStatus.ALR_DISCARD && offerStatus != OfferStatus.APPLY_TERM) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9Offer\u72b6\u6001\u4e3a\u201c\u5df2\u5e9f\u5f03/\u7533\u8bf7\u7ec8\u6b62\u201d\u7684Offer\u8fdb\u884c\u590d\u5236\u3002", (String)"OfferBtnCopyPlugin_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject appFile = offerInfo.getDynamicObject("appfile");
        DynamicObject[] validOffers = OfferServiceHelper.getInstance().getValidDynamicObjectByAppIdList(Collections.singletonList(appFile.getLong("id")));
        if (validOffers.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u5176\u4ed6\u6709\u6548\u7684Offer\u3002", (String)"OfferBtnCopyPlugin_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("offerInfoPageClose")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private boolean checkIsCopyButton(Object source) {
        if (!(source instanceof Copy)) {
            return false;
        }
        Copy copy = (Copy)source;
        return copy.getOperateKey().equals("copy");
    }
}

