/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.moka.offer.btnplugin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.moka.offer.induction.MkOfferStartInductionService;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;
import kd.tsc.tspr.business.domain.util.ValidateUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MkOfferBtnStartIdcPlugin
extends AbstractOfferButtonPlugin {
    private static final MkOfferStartInductionService inductionService = MkOfferStartInductionService.getInstance();
    private static final Log LOG = LogFactory.getLog(MkOfferBtnStartIdcPlugin.class);

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (this.checkIsBtnStartIdc(beforeDoOperationEventArgs)) {
            if (!this.checkExceedBatchMax(beforeDoOperationEventArgs)) {
                List<Long> selectedOfferIdList = this.getSelectedOfferIdList();
                Pair validateVerifyCert = ValidateUtils.validateVerifyCert((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (Integer)selectedOfferIdList.size());
                LOG.info("MkOfferStartInductionService.canExecute validateVerifyCert {}", (Object)validateVerifyCert);
                if (!((Boolean)validateVerifyCert.getLeft()).booleanValue()) {
                    this.getView().showTipNotification((String)validateVerifyCert.getRight());
                }
            } else {
                beforeDoOperationEventArgs.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("startinduction".equals(operateKey) && args.getOperationResult().isSuccess()) {
            OfferVerifyResult offerVerifyResult = inductionService.canExecute(this.getSelectedOfferIdList());
            super.handleVerifyResult(offerVerifyResult);
        }
    }

    private boolean checkIsBtnStartIdc(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        Object source = beforeDoOperationEventArgs.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"startinduction");
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        List verifyOfferFailedInfos = offerVerifyResult.getFailInfos();
        Map<String, List<VerifyOfferFailedInfo>> groupByInfo = verifyOfferFailedInfos.stream().collect(Collectors.groupingBy(VerifyOfferFailedInfo::getFailedReason));
        if (groupByInfo.size() > 1) {
            this.showBosOperateResultForm(verifyOfferFailedInfos);
        } else {
            VerifyOfferFailedInfo verifyOfferFailedInfo = (VerifyOfferFailedInfo)verifyOfferFailedInfos.get(0);
            this.getView().showTipNotification(verifyOfferFailedInfo.getFailedMsg());
        }
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.doStartInduction(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.doStartInduction(offerVerifyResult);
    }

    private void doStartInduction(OfferVerifyResult offerVerifyResult) {
        inductionService.endStartInduction(offerVerifyResult);
        if (super.checkIsPartSuccess(offerVerifyResult)) {
            super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
        } else {
            this.getView().showSuccessNotification(InductionOpMultiLangConstants.successIdcStart());
        }
        this.getView().invokeOperation("refresh");
    }
}

