/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tsrbs.common.utils.verifycode.dto.VerifyCodeDto;
import kd.tsc.tsrbs.common.utils.verifycode.service.VerifyCodeService;

public abstract class AbstractOfferDynamicFramePlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(AbstractOfferDynamicFramePlugin.class);

    public final Map<String, Object> getCustomParams() {
        return this.getView().getFormShowParameter().getCustomParams();
    }

    public Object getElementValue(String elmentKey) {
        return this.getView().getModel().getValue(elmentKey);
    }

    public <T> T getCustomParam(String key) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(key);
        return (T)Optional.of(customParam).get();
    }

    public static <T> T getCustomParam(String key, IFormView formView) {
        Object customParam = formView.getFormShowParameter().getCustomParam(key);
        return (T)Optional.of(customParam).get();
    }

    public static DynamicObject getDynamicObject(DynamicObject dynamicObject, String key) {
        return Optional.ofNullable(dynamicObject.getDynamicObject(key)).orElseGet(() -> AbstractOfferDynamicFramePlugin.createDynamicObject(dynamicObject));
    }

    public static DynamicObject getDynamicObject(IFormView formView) {
        return formView.getModel().getDataEntity(true);
    }

    public static DynamicObject createDynamicObject(DynamicObject dynamicObject) {
        return BusinessDataServiceHelper.newDynamicObject((String)dynamicObject.getDataEntityType().getName());
    }

    public static void getVerifyCode(IFormView view) {
        try {
            VerifyCodeDto verifyCode = VerifyCodeService.Singleton.INSTANCE.getInstance().getVerifyCode(null);
            view.getPageCache().put("OFFER_VERIFY_AUTH_CODE:", verifyCode.getAuthCode());
            CustomControl verifyControl = (CustomControl)view.getControl("verify_code_lap");
            verifyControl.setData((Object)verifyCode);
        }
        catch (IOException e) {
            view.showErrorNotification(OfferMultilingualConstants.getVerifyCodeError());
        }
    }

    protected List<Long> getSelectedOfferIdList() {
        ArrayList<Long> offerIds = new ArrayList<Long>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            BillShowParameter offerParameter = (BillShowParameter)formShowParameter;
            Object pkId = offerParameter.getPkId();
            if (Objects.nonNull(pkId)) {
                offerIds.add(Long.valueOf(pkId.toString()));
            }
        } else if (formShowParameter instanceof ListShowParameter) {
            IListView view = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            selectedRows.forEach(row -> offerIds.add((Long)row.getPrimaryKeyValue()));
        } else {
            Optional.ofNullable(this.getModel().getValue("offerid")).ifPresent(offerId -> offerIds.add(Long.parseLong(offerId.toString())));
        }
        return offerIds;
    }
}

