/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferBaseAbandonSecondValidator;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferSecondValidatorFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;
import kd.tsc.tso.business.domain.offer.bo.OfferAbandonBO;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.OfferBaseAbandonService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferAbandonMultiLangConstants;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferAbandonPlugin
extends HRDynamicFormBasePlugin {
    private static final String BTN_OK = "btn_ok";
    private static final String KEY_ABANDON_OFFER_CONFIRM = "abandonOfferConfirm";
    private static final OfferBaseAbandonService abandonService = OfferBaseAbandonService.getInstance();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button btnOk = (Button)this.getControl(BTN_OK);
        btnOk.addClickListener((ClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        FormShowParameter formShowParameter;
        Object secondValidatorClass;
        SecondValidatorInterface secondValidatorInterface;
        String abandonReasonDesc;
        super.beforeDoOperation(eventArgs);
        DynamicObject abandonReason = (DynamicObject)this.getModel().getValue("abandonreason");
        if (abandonReason == null) {
            eventArgs.setCancel(true);
            this.getView().showTipNotification(OfferAbandonMultiLangConstants.noAbandonReasonError());
            return;
        }
        if (OfferUtils.abandonReasonIsOth((DynamicObject)abandonReason) && (HRStringUtils.isEmpty((String)(abandonReasonDesc = String.valueOf(this.getModel().getValue("abandondesc")))) || HRStringUtils.equals((String)" ", (String)abandonReasonDesc))) {
            eventArgs.setCancel(true);
            this.getView().showTipNotification(OfferAbandonMultiLangConstants.noAbandonOthReasonError());
        }
        if ((secondValidatorInterface = OfferSecondValidatorFactory.getSecondValidatorInterface((String)((secondValidatorClass = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("secondValidatorClass")) + ""))) != null) {
            secondValidatorInterface.doValidator(this.getView(), eventArgs, "ok");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"ok")) {
            String tipMessage = this.getTipMessage();
            this.getView().showConfirm(tipMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_ABANDON_OFFER_CONFIRM, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (!HRStringUtils.equals((String)callBackId, (String)KEY_ABANDON_OFFER_CONFIRM)) {
            return;
        }
        MessageBoxResult sendOfferResult = messageBoxClosedEvent.getResult();
        if (sendOfferResult != MessageBoxResult.Yes) {
            return;
        }
        OfferVerifyResult offerVerifyResult = abandonService.canExecute(this.getSelectedOfferIdList(this.getView()));
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        if (resultEnum == OfferVerifyResultEnum.ALL_FAIL) {
            OfferBaseAbandonSecondValidator offerBaseAbandonSecondValidator = new OfferBaseAbandonSecondValidator();
            offerBaseAbandonSecondValidator.handleverifyresultAllfail(offerVerifyResult, this.getView());
            return;
        }
        this.getView().getParentView().getPageCache().put("verifyOfferResult", SerializationUtils.toJsonString((Object)offerVerifyResult));
        OfferAbandonBO abandonBo = this.generateAbandonBo();
        this.getView().returnDataToParent((Object)abandonBo);
        this.getView().close();
    }

    private List<Long> getSelectedOfferIdList(IFormView formView) {
        ArrayList<Long> offerIds = new ArrayList<Long>();
        FormShowParameter formShowParameter = formView.getParentView().getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            BillShowParameter offerParameter = (BillShowParameter)formShowParameter;
            Object pkId = offerParameter.getPkId();
            if (Objects.nonNull(pkId)) {
                offerIds.add(Long.valueOf(pkId.toString()));
            }
        } else if (formShowParameter instanceof ListShowParameter) {
            IListView view = (IListView)formView.getParentView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            selectedRows.forEach(row -> offerIds.add((Long)row.getPrimaryKeyValue()));
        } else {
            Optional.ofNullable(formView.getParentView().getModel().getValue("offerid")).ifPresent(offerId -> offerIds.add(Long.parseLong(offerId.toString())));
        }
        return offerIds;
    }

    private String getTipMessage() {
        List<Long> allOfferIds = this.getAllOfferIds();
        String tipMessage = allOfferIds.size() == 1 ? OfferAbandonMultiLangConstants.confirmAbandonSingleOffer() : String.format(OfferAbandonMultiLangConstants.confirmAbandonMultiOffer(), allOfferIds.size());
        return tipMessage;
    }

    private OfferAbandonBO generateAbandonBo() {
        OfferAbandonBO abandonBo = new OfferAbandonBO();
        DynamicObject abandonReason = (DynamicObject)this.getModel().getValue("abandonreason");
        abandonBo.setAbandonReason(abandonReason);
        ILocaleString abandonReasonDesc = (ILocaleString)this.getModel().getValue("abandondesc");
        if (!OfferUtils.abandonReasonIsOth((DynamicObject)abandonReason)) {
            abandonReasonDesc = abandonReason.getLocaleString("name");
        }
        abandonBo.setAbandonReasonDesc(abandonReasonDesc.getLocaleValue().trim());
        return abandonBo;
    }

    private List<Long> getAllOfferIds() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("all_offers");
        if (HRStringUtils.isEmpty((String)str)) {
            return new ArrayList<Long>();
        }
        return SerializationUtils.fromJsonStringToList((String)str, Long.class);
    }
}

