/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.attachment.AttachmentService;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.btnservice.copy.OfferCopyService;
import kd.tsc.tsrbd.business.utils.BizAttachmentUtil;

public class OfferAttachmentPlugin
extends HRCoreBaseBillEdit
implements UploadListener {
    private static final Log logger = LogFactory.getLog(OfferAttachmentPlugin.class);
    private static final String FILE_RESOURCE = "filesource";
    private static final String ENTITY_NUMBER = "entityNum";
    private static final String PREVIEW_URL = "previewurl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initAttachment();
    }

    private void initAttachment() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object id = formShowParameter.getCustomParam("id");
        if (id == null) {
            return;
        }
        List attachments = OfferAttachmentService.getInstance().getOfferAttachment(id);
        IPageCache cache = this.getView().getParentView().getPageCache();
        if (cache.get("CACHE_ATTACHMENT_PANEL") != null && !this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
            this.getPageCache().put("TampAttCache" + this.getView().getPageId(), cache.get("CACHE_ATTACHMENT_PANEL"));
            Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cache.get("CACHE_ATTACHMENT_PANEL"), Map.class);
            attachments.addAll((Collection)attachmentInfo.get("attachmentpanelap"));
        }
        if (OfferCopyService.getInstance().isViewFromCopy(this.getView())) {
            List list = BizAttachmentUtil.copyAndSaveTempAttachments((List)attachments);
            this.getView().getPageCache().put("attachmentpanelap", SerializationUtils.serializeToBase64((Object)list));
            AttachmentPanel attachmentpanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            attachmentpanel.bindData(list);
            return;
        }
        for (Map attachment : attachments) {
            if (attachment.containsKey(PREVIEW_URL)) continue;
            String attUrl = attachment.get("url").toString();
            attachment.put(PREVIEW_URL, attUrl.replace("download.do", "preview.do"));
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.bindData(attachments);
    }

    public void afterUpload(UploadEvent evt) {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheJsonString = cache.get("TampAttCache" + this.getView().getPageId());
        if (!StringUtils.isEmpty((String)cacheJsonString)) {
            Map<String, List<Map<String, Object>>> attachmentInfo = this.updateAttachmentSource(cacheJsonString);
            cache.remove("TampAttCache" + this.getView().getPageId());
            cache.put("TampAttCache" + this.getView().getPageId(), SerializationUtils.toJsonString(attachmentInfo));
        }
        super.afterUpload(evt);
    }

    private Map<String, List<Map<String, Object>>> updateAttachmentSource(String cacheJsonString) {
        Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
        for (Map.Entry stringObjectEntry : attachmentInfo.entrySet()) {
            for (Map stringObjectMap : (List)stringObjectEntry.getValue()) {
                stringObjectMap.replace(FILE_RESOURCE, AttachmentService.AttachmentSource.OFFER.getCode());
                stringObjectMap.replace(ENTITY_NUMBER, "tso_social_offerbase");
            }
        }
        return attachmentInfo;
    }

    public void remove(UploadEvent evt) {
        Object[] urls;
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        for (Object url : urls = evt.getUrls()) {
            Map attachMap = (Map)url;
            Object uid = attachMap.get("uid");
            AttachmentServiceHelper.remove((String)"tso_social_offerbase", (Object)id, uid);
        }
    }
}

