/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferSecondValidatorFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferLetterDelayReplyBO;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.delayreply.helper.OfferDelayReplyHelper;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDelayedReplyMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class OfferDelayReplyPlugin
extends AbstractOfferDynamicFramePlugin {
    private static final String BTN_OK = "btn_ok";
    protected static Log logger = LogFactory.getLog(OfferDelayReplyPlugin.class);
    private OfferDelayReplyHelper delayReplyHelper = OfferDelayReplyHelper.getInstance();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DateTimeEdit newDateEdit = (DateTimeEdit)this.getControl("newlastreplytime");
        Tips tips = new Tips();
        int lastReplyTimeConfig = OfferParamConfigService.getInstance().getLastReplyTimeConfig();
        tips.setContent(new LocaleString(MessageFormat.format("\u539f\u6700\u665a\u56de\u590dOffer Letter\u65e5\u671f\u548c\u7cfb\u7edf\u5f53\u524d\u65e5\u671f<\u65b0\u6700\u665a\u56de\u590dOffer Letter\u65e5\u671f<=\u7cfb\u7edf\u5f53\u524d\u65e5\u671f+{0}\u5929", lastReplyTimeConfig)));
        tips.setType("text");
        newDateEdit.addTips(tips);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        List<Long> offerIdList = this.getPassedVerifyOfferIdList();
        if (offerIdList.isEmpty()) {
            return;
        }
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOfferInfoById("offerletter", offerIdList.get(0));
        DynamicObject letter = offerInfo.getDynamicObject("offerletter");
        Date lastReplyTime = letter.getDate("lastreplytime");
        this.getModel().setValue("lastreplytime", (Object)lastReplyTime);
        Date nowDateTime = HRDateTimeUtils.getNowDateTime();
        if (nowDateTime.getTime() > lastReplyTime.getTime()) {
            lastReplyTime = nowDateTime;
        }
        lastReplyTime = HRDateTimeUtils.addDay((Date)lastReplyTime, (long)1L);
        DateTimeEdit newDateEdit = (DateTimeEdit)this.getControl("newlastreplytime");
        newDateEdit.setMinDate(DateUtils.editDate((Date)DateUtils.convertDate2UserDate((Date)lastReplyTime), (int)0, (int)0, (int)0));
        Date maxDate = DateUtils.editDate((Date)HRDateTimeUtils.addDays((int)OfferParamConfigService.getInstance().getLastReplyTimeConfig(), (Date)DateUtils.convertDate2UserDate((Date)nowDateTime)), (int)23, (int)59, (int)59);
        newDateEdit.setMaxDate(maxDate);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            List<Long> offerIdList = this.getPassedVerifyOfferIdList();
            if (offerIdList.isEmpty()) {
                return;
            }
            DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne((Object)offerIdList.get(0));
            if (this.delayReplyHelper.verifyLetterReplyStatusEqualsAlrOutTime(offerInfo) && !this.delayReplyHelper.verifyLetterDataStatus(offerInfo)) {
                this.getView().showErrorNotification(OfferDelayedReplyMultiLangConstants.dataStatusError());
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object secondValidatorClass = formShowParameter.getCustomParam("secondValidatorClass");
            SecondValidatorInterface secondValidatorInterface = OfferSecondValidatorFactory.getSecondValidatorInterface((String)(secondValidatorClass + ""));
            if (secondValidatorInterface != null) {
                secondValidatorInterface.doValidator(this.getView(), args, "save");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"save")) {
            this.getView().showConfirm(OfferDelayedReplyMultiLangConstants.confirmDelayedReplyOfferLetter(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("tso_delayedreply", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (HRStringUtils.equals((String)"tso_delayedreply", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OfferLetterDelayReplyBO delayReplyBo = this.getDelaySendBo();
            this.getView().returnDataToParent((Object)delayReplyBo);
            this.getView().close();
        }
    }

    private OfferLetterDelayReplyBO getDelaySendBo() {
        OfferLetterDelayReplyBO offerLetterDelayReplyBO = new OfferLetterDelayReplyBO();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        offerLetterDelayReplyBO.setLastReplyTime(dataEntity.getDate("newlastreplytime"));
        offerLetterDelayReplyBO.setDelaySendDesc(dataEntity.getString("delayreplaydesc").trim());
        return offerLetterDelayReplyBO;
    }

    public List<Long> getPassedVerifyOfferIdList() {
        String offerIdStr = (String)this.getCustomParam("pass_offers");
        if (HRStringUtils.isEmpty((String)offerIdStr)) {
            return new ArrayList<Long>();
        }
        List offerIdList = SerializationUtils.fromJsonStringToList((String)offerIdStr, Long.class);
        return offerIdList;
    }
}

