/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferSecondValidatorFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;
import kd.tsc.tso.business.domain.offer.bo.OfferDelaySendBO;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferDelaySendPageService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDelaySendMultiLanConstants;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class OfferDelaySendPlugin
extends AbstractOfferDynamicFramePlugin {
    private static final String BTN_OK = "btn_ok";
    protected static Log logger = LogFactory.getLog(OfferDelaySendPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        List<Long> offerIdList = this.getPassedVerifyOfferIdList();
        if (offerIdList.isEmpty()) {
            return;
        }
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOfferInfoById("offerletter", offerIdList.get(0));
        DynamicObject letter = offerInfo.getDynamicObject("offerletter");
        Date lastSendTime = letter.getDate("lastsendtime");
        if (null != lastSendTime) {
            this.getView().getModel().setValue("olastsendtime", (Object)lastSendTime);
            Date minDate = OfferDelaySendPageService.getInstance().getMinDateForDelaySend(lastSendTime);
            DateTimeEdit dateEdit = (DateTimeEdit)this.getControl("lastsendtime");
            dateEdit.setMinDate(DateUtils.editDate((Date)DateUtils.convertDate2UserDate((Date)minDate), (int)0, (int)0, (int)0));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormShowParameter formShowParameter;
        Object secondValidatorClass;
        SecondValidatorInterface secondValidatorInterface;
        super.beforeDoOperation(args);
        String delaySendDesc = this.getModel().getDataEntity(true).getString("delaydesc");
        if (HRStringUtils.isEmpty((String)delaySendDesc)) {
            args.setCancel(true);
            this.getView().showTipNotification(OfferDelaySendMultiLanConstants.noDelaySendReasonError());
        }
        if ((secondValidatorInterface = OfferSecondValidatorFactory.getSecondValidatorInterface((String)((secondValidatorClass = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("secondValidatorClass")) + ""))) != null) {
            secondValidatorInterface.doValidator(this.getView(), args, "ok");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"ok")) {
            OfferDelaySendBO delaySendBo = this.getDelaySendBo();
            this.getView().returnDataToParent((Object)delaySendBo);
            this.getView().close();
        }
    }

    private OfferDelaySendBO getDelaySendBo() {
        OfferDelaySendBO offerDelaySendBo = new OfferDelaySendBO();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        offerDelaySendBo.setLastSendTime(dataEntity.getDate("lastsendtime"));
        offerDelaySendBo.setDelaySendDesc(dataEntity.getString("delaydesc").trim());
        return offerDelaySendBo;
    }

    public List<Long> getPassedVerifyOfferIdList() {
        String offerIdStr = (String)this.getCustomParam("pass_offers");
        if (HRStringUtils.isEmpty((String)offerIdStr)) {
            return new ArrayList<Long>();
        }
        List offerIdList = SerializationUtils.fromJsonStringToList((String)offerIdStr, Long.class);
        return offerIdList;
    }
}

