/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferSecondValidatorFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferLetterReplaceReplyBO;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferReplaceReplyPlugin
extends AbstractOfferDynamicFramePlugin
implements BeforeF7SelectListener {
    protected static Log logger = LogFactory.getLog(OfferReplaceReplyPlugin.class);
    private static final String REPLY_RESULT = "replyresult";
    private static final String REJECT_REASON = "rejectreason";
    private static final String OTHER_REASON_DESC = "otherreasondesc";
    private static final String REAL_REPLY_DATE = "realreplydate";
    private static final String BOS_LIST_F7 = "bos_listf7";
    private static final String BTN_OK = "btn_ok";

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        List<Long> offerIdList = this.getOfferIdList();
        if (offerIdList.isEmpty()) {
            return;
        }
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOfferInfoById("offerletter", offerIdList.get(0));
        DynamicObject letter = offerInfo.getDynamicObject("offerletter");
        Date sendDate = letter.getDate("sendtime");
        if (null != sendDate) {
            DateTimeEdit realReplyDate = (DateTimeEdit)this.getControl(REAL_REPLY_DATE);
            realReplyDate.setMinDate(DateUtils.editDate((Date)DateUtils.convertDate2UserDate((Date)sendDate), (int)0, (int)0, (int)0));
            realReplyDate.setMaxDate(DateUtils.editDate((Date)HRDateTimeUtils.curUserDateBos((Long)TSCRequestContext.getUserId()), (int)23, (int)59, (int)59));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)REPLY_RESULT, (String)name)) {
            String replyResult = (String)this.getElementValue(REPLY_RESULT);
            BasedataEdit rejectReason = (BasedataEdit)this.getView().getControl(REJECT_REASON);
            if (HRStringUtils.equals((String)"2", (String)replyResult)) {
                rejectReason.setMustInput(true);
            } else {
                rejectReason.setMustInput(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        List<Long> offerIdList = this.getOfferIdList();
        if (offerIdList.isEmpty()) {
            return;
        }
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            String replyResult = this.getModel().getDataEntity(true).getString(REPLY_RESULT);
            if (HRStringUtils.isEmpty((String)replyResult)) {
                return;
            }
            if (HRStringUtils.equals((String)"2", (String)replyResult)) {
                String message = MessageFormat.format(OfferMultilingualConstants.replaceConfirm(), offerIdList.size());
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("tso_somk_replacereply", (IFormPlugin)this));
            } else {
                OfferLetterReplaceReplyBO replaceReplyBO = this.getReplaceReplyBo();
                this.getView().returnDataToParent((Object)replaceReplyBO);
                this.getView().close();
            }
        }
    }

    private OfferLetterReplaceReplyBO getReplaceReplyBo() {
        OfferLetterReplaceReplyBO replaceReplyBO = new OfferLetterReplaceReplyBO();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        replaceReplyBO.setReplyResult(dataEntity.getString(REPLY_RESULT));
        replaceReplyBO.setRealReplyDate(dataEntity.getDate(REAL_REPLY_DATE));
        replaceReplyBO.setRejectReason(dataEntity.getDynamicObject(REJECT_REASON));
        replaceReplyBO.setOtherReasonDesc(dataEntity.getString(OTHER_REASON_DESC));
        return replaceReplyBO;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)"tso_somk_replacereply", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OfferLetterReplaceReplyBO replaceReplyBO = this.getReplaceReplyBo();
            this.getView().returnDataToParent((Object)replaceReplyBO);
            this.getView().close();
        }
    }

    private List<Long> getOfferIdList() {
        String offerIdStr = (String)this.getCustomParam("pass_offers");
        if (HRStringUtils.isEmpty((String)offerIdStr)) {
            return new ArrayList<Long>();
        }
        List offerIdList = SerializationUtils.fromJsonStringToList((String)offerIdStr, Long.class);
        return offerIdList;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit rejectReason = (BasedataEdit)this.getView().getControl(REJECT_REASON);
        rejectReason.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object rejectReason = this.getModel().getValue(REJECT_REASON);
        String replyResult = String.valueOf(this.getModel().getValue(REPLY_RESULT));
        if (HRStringUtils.equals((String)"2", (String)replyResult) && null == rejectReason) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u62d2\u7edd\u539f\u56e0\u3002", (String)"OfferReplaceReplyPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object secondValidatorClass = formShowParameter.getCustomParam("secondValidatorClass");
        SecondValidatorInterface secondValidatorInterface = OfferSecondValidatorFactory.getSecondValidatorInterface((String)(secondValidatorClass + ""));
        if (secondValidatorInterface != null) {
            secondValidatorInterface.doValidator(this.getView(), args, "save");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)REJECT_REASON, (String)fieldKey)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId(BOS_LIST_F7);
        }
    }
}

