/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.advice;

import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferApprovalFormBizHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferOnlyViewHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tso.common.util.OfferShowParamUtils;

public class ApprovalPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"detail"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long offerId = (Long)this.getView().getFormShowParameter().getCustomParam("offerid");
        DynamicObject[] offerBillArray = OfferApprovalFormBizHelper.getOfferApprovalFormEntry((Long)offerId);
        if (null == offerBillArray || offerBillArray.length == 0) {
            return;
        }
        Map mappingMap = OfferApprovalFormBizHelper.offerIdWithApprove((DynamicObject[])offerBillArray);
        TableValueSetter valueSetter = OfferApprovalFormBizHelper.buildOfferBillEntry((DynamicObject[])offerBillArray, (Map)mappingMap);
        IDataModel entryOperate = this.getModel();
        entryOperate.deleteEntryData("entryentity");
        ((AbstractFormDataModel)entryOperate).batchCreateNewEntryRow("entryentity", valueSetter);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        OfferOnlyViewHelper.onlyViewForApprovalTab((IFormView)this.getView());
    }

    public void click(EventObject evt) {
        Long offerId = (Long)this.getView().getFormShowParameter().getCustomParam("offerid");
        DynamicObject approve = OfferBillServiceHelper.getInstance().queryByOfferId(offerId);
        if (approve == null) {
            this.getView().invokeOperation("refresh");
            this.getView().getParentView().showTipNotification(OfferDeleteMultiLangConstants.dataHasDelete());
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        } else {
            long offerBillId = Long.parseLong(this.getView().getModel().getValue("billid").toString());
            String pageId = this.getView().getPageId();
            FormShowParameter parameter = OfferShowParamUtils.getOfferBillParam((Long)offerBillId, (String)pageId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "actionBillInfo");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"actionBillInfo")) {
            this.getView().invokeOperation("refresh");
            Optional.ofNullable(closedCallBackEvent.getReturnData()).ifPresent(msg -> this.getView().getParentView().showSuccessNotification(msg.toString()));
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

