/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.bill;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferSecondValidatorFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferAbandonMultiLangConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.StringUtils;

public class AbandonReasonPlugin
extends HRDynamicFormBasePlugin {
    private static String KEY_ABANDON_DESC = "abandondesc";
    private static String KEY_BTN_OK = "btn_ok";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object secondValidatorClass = formShowParameter.getCustomParam("secondValidatorClass");
        SecondValidatorInterface secondValidatorInterface = OfferSecondValidatorFactory.getSecondValidatorInterface((String)(secondValidatorClass + ""));
        if (secondValidatorInterface != null) {
            secondValidatorInterface.doValidator(this.getView(), args, "save");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"save")) {
            Object tipMsg = this.getView().getFormShowParameter().getCustomParam("confirmTipMultiLang");
            tipMsg = tipMsg != null ? tipMsg : OfferAbandonMultiLangConstants.abnadonChangeBillConfirmBox();
            this.getView().showConfirm(tipMsg.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("abandonBillConfirm", (IFormPlugin)this));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("abandonBillConfirm".equals(callBackId)) {
            if (!this.verifyHasPerm()) {
                return;
            }
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (result == MessageBoxResult.Yes) {
                this.getView().returnDataToParent(this.getModel().getValue(KEY_ABANDON_DESC));
                this.getView().close();
            }
        }
    }

    private boolean verifyHasPerm() {
        String formId = this.getView().getFormShowParameter().getCustomParam("formId").toString();
        if (!OfferPermService.getInstance().verifyHasPerm("bar_abandon", formId, Long.valueOf(TSCRequestContext.getOrgId()))) {
            String msg = "";
            msg = "tso_changeletterbill".equals(formId) ? ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer\u7ba1\u7406\u7684\u201c\u5e9f\u5f03\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBtnAbandonPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer\u7533\u8bf7\u5355\u7684\u201c\u5e9f\u5f03\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBillBtnAbandonPlugin_11", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }
}

