/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.bill;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterValidHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.OfferBillAbandonService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferAbandonMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferBillBtnAbandonPlugin
extends AbstractOfferButtonPlugin {
    private static OfferBillAbandonService abandonService = OfferBillAbandonService.getInstance();
    private long offerId;

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!(source instanceof Donothing)) {
            return;
        }
        Donothing donothing = (Donothing)source;
        if (!HRStringUtils.equals((String)donothing.getOperateKey(), (String)"abandon")) {
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("abandon".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String formId = this.getView().getFormShowParameter().getFormId();
            boolean error = false;
            switch (formId) {
                case "tso_somk_offerapproveinfo": 
                case "tso_offerbillinfo": {
                    error = this.offerBillAbandonValidator();
                    break;
                }
                case "tso_changeletterbill": {
                    error = this.offerChangeBillAbandonValidator();
                    break;
                }
            }
            if (error) {
                OfferEditMutexHelper.releaseMutex((Long)this.offerId);
            }
        }
    }

    private boolean offerChangeBillAbandonValidator() {
        StringBuilder stringBuilder;
        if (!OfferPermService.getInstance().verifyHasPerm("bar_abandon", "tso_changeletterbill", Long.valueOf(TSCRequestContext.getOrgId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355\u7684\u201c\u5e9f\u5f03\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBillBtnAbandonPlugin_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject offer = dataEntity.getDynamicObject("offer");
        if (this.isEidt(offer, stringBuilder = new StringBuilder(ResManager.loadKDString((String)"{0}\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"OfferBillBtnAbandonPlugin_9", (String)"tsc-tso-formplugin", (Object[])new Object[0])))) {
            return true;
        }
        DynamicObject offerBillInfo = ChangeLetterBillHelper.getInstance().queryOne(this.getModel().getDataEntity(true).getPkValue());
        if (abandonService.isAlrAbandon(offerBillInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355\u5df2\u5e9f\u5f03\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBillBtnAbandonPlugin_6", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (!abandonService.isWaitResubmit(offerBillInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355\u8fdb\u884c\u5e9f\u5f03\u3002", (String)"OfferBillBtnAbandonPlugin_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        String title = ResManager.loadKDString((String)"\u5e9f\u5f03Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355", (String)"OfferBillBtnAbandonPlugin_7", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        String confirmTipMultiLang = OfferAbandonMultiLangConstants.abnadonChangeBillConfirmBox();
        FormShowParameter formShowParameter = abandonService.showAbandonForm("tso_abandonreason", title, confirmTipMultiLang, (IFormPlugin)this);
        formShowParameter.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferLetterBillAbandonSecondValidator");
        formShowParameter.setCustomParam("formId", (Object)"tso_changeletterbill");
        this.getView().showForm(formShowParameter);
        return false;
    }

    private boolean isEidt(DynamicObject offer, StringBuilder stringBuilder) {
        if (offer != null) {
            this.offerId = offer.getLong("id");
            DynamicObject[] editObjs = OfferEditMutexHelper.checkOfferIsEditing((List)Lists.newArrayList((Object[])new Long[]{this.offerId}));
            if (editObjs != null && editObjs.length > 0) {
                String newStr = stringBuilder.toString().replace("{0}", editObjs[0].getString("user.name"));
                this.getView().showTipNotification(newStr);
                return true;
            }
        }
        return false;
    }

    private boolean offerBillAbandonValidator() {
        String message;
        StringBuilder stringBuilder;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject offer = OfferBillServiceHelper.getInstance().getOfferByBillDt(dataEntity);
        if (this.isEidt(offer, stringBuilder = new StringBuilder(ResManager.loadKDString((String)"{0}\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"OfferBillBtnAbandonPlugin_8", (String)"tsc-tso-formplugin", (Object[])new Object[0])))) {
            return true;
        }
        if (!OfferPermService.getInstance().verifyHasPerm("bar_abandon", "tso_somk_offerbill", Long.valueOf(TSCRequestContext.getOrgId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer\u7533\u8bf7\u5355\u7684\u201c\u5e9f\u5f03\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBillBtnAbandonPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject offerBillInfo = OfferBillServiceHelper.getInstance().queryOne(this.getModel().getDataEntity(true).getPkValue());
        if (abandonService.isAlrAbandon(offerBillInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Offer\u7533\u8bf7\u5355\u5df2\u5e9f\u5f03\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBillBtnAbandonPlugin_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (!abandonService.isWaitResubmit(offerBillInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684Offer\u7533\u8bf7\u5355\u64cd\u4f5c\u5e9f\u5f03\u3002", (String)"OfferBillBtnAbandonPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        if ("2".equals(offer.getString("salarytype")) && !HRStringUtils.isEmpty((String)(message = new OfferSalaryService().verifyHasPerm(Long.valueOf(offer.getLong("id")), "tso_somk_offerapproveinfo")))) {
            this.getView().showErrorNotification(message);
            return true;
        }
        String title = ResManager.loadKDString((String)"\u5e9f\u5f03Offer\u7533\u8bf7\u5355", (String)"OfferBillBtnAbandonPlugin_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        String confirmTipMultiLang = OfferAbandonMultiLangConstants.abnadonBillConfirmBox();
        FormShowParameter formShowParameter = abandonService.showAbandonForm("tso_abandonreason", title, confirmTipMultiLang, (IFormPlugin)this);
        formShowParameter.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferBillAbandonSecondValidator");
        formShowParameter.setCustomParam("formId", (Object)"tso_somk_offerapproveinfo");
        this.getView().showForm(formShowParameter);
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"tso_abandonreason")) {
            Optional.ofNullable(event.getReturnData()).ifPresent(abandonDesc -> {
                try (TXHandle tx = TX.required();){
                    try {
                        String formId = this.getView().getFormShowParameter().getFormId();
                        DynamicObject dataEntity = this.getModel().getDataEntity(true);
                        switch (formId) {
                            case "tso_somk_offerapproveinfo": 
                            case "tso_offerbillinfo": {
                                this.updateOfferBill(abandonDesc, dataEntity);
                                break;
                            }
                            case "tso_changeletterbill": {
                                this.updateOfferLetterChangeBill(abandonDesc, dataEntity);
                                break;
                            }
                        }
                        this.getView().invokeOperation("refresh");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e9f\u5f03\u6210\u529f", (String)"OfferBillBtnAbandonPlugin_10", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    }
                    catch (Exception ex) {
                        tx.markRollback();
                        throw new KDBizException("abandon offer bill fail.");
                    }
                }
            });
            OfferEditMutexHelper.releaseMutex((Long)this.offerId);
        }
    }

    private void updateOfferLetterChangeBill(Object abandonDesc, DynamicObject dataEntity) {
        dataEntity.set("billstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
        dataEntity.set("offerabandondesc", abandonDesc);
        ChangeLetterBillHelper.getInstance().updateOne(dataEntity);
        ChangeLetterBillHelper.getInstance().cancelWorkFlow(new DynamicObject[]{dataEntity});
        Long offerId = dataEntity.getLong("offer.id");
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne((Object)offerId);
        offerInfo.set("letterauditstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
        OfferServiceHelper.getInstance().updateOne(offerInfo);
        Long letterValidId = dataEntity.getLong("changelettervalid.id");
        DynamicObject letterValidObj = ChangeLetterValidHelper.getInstance().queryOne((Object)letterValidId);
        letterValidObj.set("lettervalidstatus", (Object)"E");
        ChangeLetterValidHelper.getInstance().updateOne(letterValidObj);
    }

    private void updateOfferBill(Object abandonDesc, DynamicObject dataEntity) {
        dataEntity.set("billstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
        dataEntity.set("offerabandondesc", abandonDesc);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        entryEntity.stream().forEach(entry -> entry.set("offerauditstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode()));
        OfferBillServiceHelper.getInstance().updateOne(dataEntity);
        abandonService.cancelWorkFlow(new DynamicObject[]{dataEntity});
        DynamicObject offerByBillDt = OfferBillServiceHelper.getInstance().getOfferByBillDt(dataEntity);
        offerByBillDt.set("billstatus", (Object)OfferAuditStatus.ALR_ABANDON.getCode());
        offerByBillDt.set("status", (Object)OfferStatus.PRE_APPLY.getCode());
        OfferServiceHelper.getInstance().updateOne(offerByBillDt);
    }
}

