/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.btnplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;
import kd.tsc.tspr.business.domain.util.ValidateUtils;
import kd.tsc.tsrbd.business.application.external.org.BizOrgUnitService;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractOfferButtonPlugin
extends AbstractOfferDynamicFramePlugin {
    private static final String VERIFY_RESULT_CACHE = "verifyOfferResult";
    private static final String CACHE_KEY_OPERATE_NAME = "operateName";
    private int batchMaxInt = 200;
    public static Set<String> OPERATE_KEY = new HashSet<String>();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        this.cacheOperateName(operate.getOperateName().getLocaleValue());
    }

    public void handleVerifyResult(OfferVerifyResult offerVerifyResult, BeforeDoOperationEventArgs args) {
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        switch (resultEnum) {
            case ALL_FAIL: {
                args.setCancel(true);
                this.handleverifyresultAllfail(offerVerifyResult);
                break;
            }
            case PART_PASS: {
                this.handleVerifyResultPartSuccess(offerVerifyResult);
                break;
            }
            case ALL_PASS: {
                this.handleVerifyResultAllSuccess(offerVerifyResult);
                break;
            }
        }
    }

    public void handleVerifyResult(OfferVerifyResult offerVerifyResult) {
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        switch (resultEnum) {
            case ALL_FAIL: {
                this.handleverifyresultAllfail(offerVerifyResult);
                break;
            }
            case PART_PASS: {
                this.handleVerifyResultPartSuccess(offerVerifyResult);
                break;
            }
            case ALL_PASS: {
                this.handleVerifyResultAllSuccess(offerVerifyResult);
                break;
            }
        }
    }

    public void afterHandleVerifyResult(OfferVerifyResult offerVerifyResult, AfterDoOperationEventArgs args) {
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        switch (resultEnum) {
            case ALL_FAIL: {
                this.handleverifyresultAllfail(offerVerifyResult);
                break;
            }
            case PART_PASS: {
                this.handleVerifyResultPartSuccess(offerVerifyResult);
                break;
            }
            case ALL_PASS: {
                this.handleVerifyResultAllSuccess(offerVerifyResult);
                break;
            }
        }
    }

    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        List verifyOfferFailedInfos = offerVerifyResult.getFailInfos();
        if (CollectionUtils.isEmpty((Collection)verifyOfferFailedInfos)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"OfferAbstractButtonPlugin_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, List<VerifyOfferFailedInfo>> groupByInfo = verifyOfferFailedInfos.stream().collect(Collectors.groupingBy(VerifyOfferFailedInfo::getFailedReason));
        if (groupByInfo.size() > 1) {
            this.showBosOperateResultForm(verifyOfferFailedInfos);
        } else {
            VerifyOfferFailedInfo verifyOfferFailedInfo = (VerifyOfferFailedInfo)verifyOfferFailedInfos.get(0);
            this.getView().showTipNotification(verifyOfferFailedInfo.getFailedMsg());
        }
    }

    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        this.putVerifyResultToCache(offerVerifyResult);
    }

    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        this.putVerifyResultToCache(offerVerifyResult);
    }

    protected void showBosOperateResultForm(List<VerifyOfferFailedInfo> verifyOfferFailedInfos) {
        int allOfferNum = this.getSelectedOfferIdList().size();
        int failOfferNum = verifyOfferFailedInfos.size();
        int succOfferNum = allOfferNum - failOfferNum;
        String titleMsg = String.format(ResManager.loadKDString((String)"\u5171%s\u6761\u6570\u636e\uff0c\u6210\u529f%s\u6761\uff0c\u5931\u8d25%s\u6761\u3002", (String)"OfferAbstractButtonPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]), allOfferNum, succOfferNum, failOfferNum);
        ArrayList errorMsgs = new ArrayList(verifyOfferFailedInfos.size());
        verifyOfferFailedInfos.parallelStream().forEach(verifyOfferFailedInfo -> errorMsgs.add(verifyOfferFailedInfo.getBillNo() + ":" + verifyOfferFailedInfo.getFailedMsg()));
        FormShowParameter bosOperationResultParam = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, errorMsgs, (boolean)false);
        this.getView().showForm(bosOperationResultParam);
    }

    protected OfferVerifyResult getVerifyResultFromCache() {
        String str = this.getPageCache().get(VERIFY_RESULT_CACHE);
        if (HRStringUtils.isEmpty((String)str)) {
            return new OfferVerifyResult();
        }
        this.getPageCache().remove(VERIFY_RESULT_CACHE);
        return (OfferVerifyResult)SerializationUtils.fromJsonString((String)str, OfferVerifyResult.class);
    }

    protected void putVerifyResultToCache(OfferVerifyResult offerVerifyResult) {
        this.getPageCache().put(VERIFY_RESULT_CACHE, SerializationUtils.toJsonString((Object)offerVerifyResult));
    }

    protected boolean checkIsPartSuccess(OfferVerifyResult offerVerifyResult) {
        if (offerVerifyResult == null) {
            return false;
        }
        Integer verifyFlag = offerVerifyResult.getResultType();
        if (verifyFlag == null) {
            return false;
        }
        OfferVerifyResultEnum enumByCode = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        return enumByCode == OfferVerifyResultEnum.PART_PASS;
    }

    protected void cacheOperateName(String operateName) {
        this.getPageCache().put(((Object)((Object)this)).getClass().getName() + CACHE_KEY_OPERATE_NAME, operateName);
    }

    protected String getOperateName() {
        return this.getPageCache().get(((Object)((Object)this)).getClass().getName() + CACHE_KEY_OPERATE_NAME);
    }

    protected boolean checkExceedBatchMax(BeforeDoOperationEventArgs args) {
        AppParam appParam = new AppParam();
        appParam.setOrgId(BizOrgUnitService.getView24RootOrgId());
        appParam.setAppId("1NQEI=GMSBRC");
        Object limitRow = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"limitrow");
        if (Objects.nonNull(limitRow)) {
            this.batchMaxInt = (Integer)limitRow;
        }
        if (this.getSelectedOfferIdList().size() > this.batchMaxInt) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9200\u6761\u6570\u636e\u6267\u884c\u3002", (String)"OfferAbstractButtonPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    protected boolean checkStartIdcVerify() {
        Pair validateVerifyCert = ValidateUtils.validateVerifyCert((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (Integer)this.getSelectedOfferIdList().size());
        if (!((Boolean)validateVerifyCert.getLeft()).booleanValue()) {
            this.getView().showTipNotification((String)validateVerifyCert.getRight());
            return false;
        }
        return true;
    }
}

