/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.btnplugin;

import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.chgvalidtime.OfferChgValidTimeService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferChgValidTimeMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class OfferBtnChgValidTimePlugin
extends AbstractOfferButtonPlugin {
    private static final String CLOSE_CALLBACK_CHG_VALID_TIME = "chgValidTimeCloseCallBack";
    private final OfferChgValidTimeService service = OfferChgValidTimeService.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        IListView listView;
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (!this.checkBtnAndInitOperateName(beforeDoOperationEventArgs)) {
            return;
        }
        IFormView view = this.getView();
        if (view instanceof IListView && (selectedRows = (listView = (IListView)view).getSelectedRows()).size() > 1) {
            view.showTipNotification(OfferChgValidTimeMultiLangConstants.onlyOneOfferTip());
            beforeDoOperationEventArgs.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("chgvalidtime".equals(operateKey) && args.getOperationResult().isSuccess()) {
            OfferVerifyResult offerVerifyResult = this.service.canExecute(this.getSelectedOfferIdList());
            super.handleVerifyResult(offerVerifyResult);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (!HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)CLOSE_CALLBACK_CHG_VALID_TIME)) {
            return;
        }
        OfferVerifyResult verifyResultFromCache = this.getVerifyResultFromCache();
        String letterAudit = String.valueOf(closedCallBackEvent.getReturnData());
        if (letterAudit.equals("1") || letterAudit.equals("2")) {
            if (this.checkIsPartSuccess(verifyResultFromCache)) {
                super.showBosOperateResultForm(verifyResultFromCache.getFailInfos());
            } else if (letterAudit.equals("1")) {
                this.getView().showSuccessNotification(OfferSubmitMultiLangConstants.submitSuccess());
            } else {
                this.getView().showSuccessNotification(OfferChgValidTimeMultiLangConstants.changeValidTimeSuccess());
            }
        }
        this.getView().invokeOperation("refresh");
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        super.handleverifyresultAllfail(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.showChangeValidTimeForm(offerVerifyResult.getPassIds());
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.showChangeValidTimeForm(offerVerifyResult.getPassIds());
    }

    private void showChangeValidTimeForm(List<Long> passOfferIds) {
        BaseShowParameter changeValidTimeShowParam = new BaseShowParameter();
        changeValidTimeShowParam.setFormId("tso_changelettervalid");
        changeValidTimeShowParam.getOpenStyle().setShowType(ShowType.Modal);
        changeValidTimeShowParam.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4Offer Letter\u6709\u6548\u671f", (String)"OfferBtnChgValidTimePlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        if (passOfferIds == null || passOfferIds.isEmpty()) {
            throw new KDBizException(((Object)((Object)this)).getClass().getName() + "param error");
        }
        Long offerId = passOfferIds.get(0);
        DynamicObject offerInfo = OfferServiceHelper.getInstance().queryOne((Object)offerId);
        DynamicObject letterObj = offerInfo.getDynamicObject("offerletter");
        changeValidTimeShowParam.setCustomParam("letterId", (Object)letterObj.getLong("id"));
        changeValidTimeShowParam.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferChgValidTimeSecondValidator");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_CHG_VALID_TIME);
        changeValidTimeShowParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)changeValidTimeShowParam);
    }

    private boolean checkBtnAndInitOperateName(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        Object source = beforeDoOperationEventArgs.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"chgvalidtime");
    }
}

