/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.btnplugin;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferDelaySendBO;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.service.btnservice.delaysend.OfferDelaySendService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDelaySendMultiLanConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class OfferBtnDelaySendPlugin
extends AbstractOfferButtonPlugin {
    private String closeCallbackDelaySend = "delaySendCloseCallBack";
    private OfferDelaySendService service = OfferDelaySendService.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (!this.checkIsBtnDelaySend(beforeDoOperationEventArgs)) {
            return;
        }
        if (this.checkExceedBatchMax(beforeDoOperationEventArgs)) {
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("delaysend".equals(operateKey) && args.getOperationResult().isSuccess()) {
            OfferVerifyResult offerVerifyResult = this.service.canExecute(this.getSelectedOfferIdList());
            super.handleVerifyResult(offerVerifyResult);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (!HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)this.closeCallbackDelaySend)) {
            return;
        }
        OfferDelaySendBO returnData = (OfferDelaySendBO)closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        OfferVerifyResult offerVerifyResult = this.getVerifyResultFromCache();
        boolean isSuccess = this.service.delaySend(offerVerifyResult.getPassIds(), returnData, super.getOperateName());
        if (!isSuccess) {
            this.getView().showErrorNotification(OfferDelaySendMultiLanConstants.delaySendFail());
            return;
        }
        if (super.checkIsPartSuccess(offerVerifyResult)) {
            super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
        } else {
            this.getView().showSuccessNotification(OfferDelaySendMultiLanConstants.delaySendSuccess());
        }
        this.getView().invokeOperation("refresh");
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        super.handleverifyresultAllfail(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.showDelaySendOfferForm(offerVerifyResult.getPassIds());
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.showDelaySendOfferForm(offerVerifyResult.getPassIds());
    }

    private void showDelaySendOfferForm(List<Long> passOfferIds) {
        FormShowParameter delaySendOfferShowParam = new FormShowParameter();
        delaySendOfferShowParam.setFormId("tso_offerdelaysend");
        delaySendOfferShowParam.getOpenStyle().setShowType(ShowType.Modal);
        delaySendOfferShowParam.setCustomParam("pass_offers", (Object)SerializationUtils.toJsonString(passOfferIds));
        delaySendOfferShowParam.setCustomParam("all_offers", (Object)SerializationUtils.toJsonString(this.getSelectedOfferIdList()));
        delaySendOfferShowParam.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferDelaySendSecondValidator");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, this.closeCallbackDelaySend);
        delaySendOfferShowParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(delaySendOfferShowParam);
    }

    private boolean checkIsBtnDelaySend(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        Object source = beforeDoOperationEventArgs.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"delaysend");
    }

    static {
        OPERATE_KEY.add("delaysend");
    }
}

