/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.btnplugin;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferLetterDelayReplyBO;
import kd.tsc.tso.business.domain.offer.service.btnservice.delayreply.OfferDelayReplyService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDelayedReplyMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class OfferBtnDelayedReplyPlugin
extends AbstractOfferButtonPlugin {
    private String closeCallbackDelayReply = "delayReplyCloseCallBack";
    private OfferDelayReplyService service = OfferDelayReplyService.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (!this.checkIsDelayedReplyButton(beforeDoOperationEventArgs)) {
            return;
        }
        List<Long> offerIdList = this.getSelectedOfferIdList();
        if (offerIdList.size() > 1) {
            this.getView().showTipNotification(OfferDelayedReplyMultiLangConstants.onlyCanDelayedReplyOneOfferLetterError());
            beforeDoOperationEventArgs.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("delayedreply".equals(operateKey) && args.getOperationResult().isSuccess()) {
            OfferVerifyResult offerVerifyResult = this.service.canExecute(this.getSelectedOfferIdList());
            super.handleVerifyResult(offerVerifyResult);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (!HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)this.closeCallbackDelayReply)) {
            return;
        }
        OfferLetterDelayReplyBO returnData = (OfferLetterDelayReplyBO)closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        OfferVerifyResult offerVerifyResult = this.getVerifyResultFromCache();
        boolean isSuccess = this.service.delayReply(offerVerifyResult.getPassIds(), returnData);
        if (!isSuccess) {
            this.getView().showErrorNotification(OfferDelayedReplyMultiLangConstants.delayedReplyFail());
            return;
        }
        if (super.checkIsPartSuccess(offerVerifyResult)) {
            super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
        } else {
            this.getView().showSuccessNotification(OfferDelayedReplyMultiLangConstants.delayedReplySuccess());
        }
        this.getView().invokeOperation("refresh");
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        super.handleverifyresultAllfail(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.showDelayReplyOfferLetterForm(offerVerifyResult.getPassIds());
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.showDelayReplyOfferLetterForm(offerVerifyResult.getPassIds());
    }

    private void showDelayReplyOfferLetterForm(List<Long> passOfferIds) {
        FormShowParameter delayReplyOfferLetterShowParam = new FormShowParameter();
        delayReplyOfferLetterShowParam.setFormId("tso_delayedreply");
        delayReplyOfferLetterShowParam.getOpenStyle().setShowType(ShowType.Modal);
        delayReplyOfferLetterShowParam.setCustomParam("pass_offers", (Object)SerializationUtils.toJsonString(passOfferIds));
        delayReplyOfferLetterShowParam.setCustomParam("all_offers", (Object)SerializationUtils.toJsonString(this.getSelectedOfferIdList()));
        delayReplyOfferLetterShowParam.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferDelayReplySecondValidator");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, this.closeCallbackDelayReply);
        delayReplyOfferLetterShowParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(delayReplyOfferLetterShowParam);
    }

    private boolean checkIsDelayedReplyButton(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        if (!(beforeDoOperationEventArgs.getSource() instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)beforeDoOperationEventArgs.getSource();
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"delayedreply");
    }
}

