/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.btnplugin;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.oprecord.OfferLetterReplaceReplyBO;
import kd.tsc.tso.business.domain.offer.service.btnservice.replacereply.OfferReplaceReplyService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferReplaceReplyMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class OfferBtnReplaceReplyPlugin
extends AbstractOfferButtonPlugin {
    private static final String REPLACE_REPLY_CLOSE_CALLBACK = "replaceReplyCloseCallBack";
    private static final String KEY_REPLACEREPLY = "replacereply";
    private static final OfferReplaceReplyService SERVICE = OfferReplaceReplyService.getInstance();
    private static final Log LOG = LogFactory.getLog(OfferBtnReplaceReplyPlugin.class);

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)KEY_REPLACEREPLY, (String)operateKey) && this.checkExceedBatchMax(args)) {
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (KEY_REPLACEREPLY.equals(operateKey) && args.getOperationResult().isSuccess()) {
            OfferVerifyResult offerVerifyResult = SERVICE.canExecute(this.getSelectedOfferIdList());
            super.handleVerifyResult(offerVerifyResult);
        }
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        super.handleverifyresultAllfail(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.showReplaceReplyOfferForm(offerVerifyResult.getPassIds());
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.showReplaceReplyOfferForm(offerVerifyResult.getPassIds());
    }

    private void showReplaceReplyOfferForm(List<Long> passOfferIds) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("tso_somk_replacereply");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCustomParam("pass_offers", (Object)SerializationUtils.toJsonString(passOfferIds));
        showParam.setCustomParam("all_offers", (Object)SerializationUtils.toJsonString(this.getSelectedOfferIdList()));
        showParam.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferReplaceReplySecondValidator");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, REPLACE_REPLY_CLOSE_CALLBACK);
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)REPLACE_REPLY_CLOSE_CALLBACK, (String)closedCallBackEvent.getActionId())) {
            OfferLetterReplaceReplyBO returnData = (OfferLetterReplaceReplyBO)closedCallBackEvent.getReturnData();
            if (HRObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            OfferVerifyResult offerVerifyResult = this.getVerifyResultFromCache();
            boolean isSuccess = SERVICE.replaceReply(offerVerifyResult.getPassIds(), returnData);
            if (!isSuccess) {
                this.getView().showErrorNotification(OfferReplaceReplyMultiLangConstants.replaceReplyFail());
                return;
            }
            if (super.checkIsPartSuccess(offerVerifyResult)) {
                super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
            } else {
                this.getView().showSuccessNotification(OfferReplaceReplyMultiLangConstants.replaceReplySuccess());
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

