/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.cardinfo;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.cardinfo.OfferStrategyControl;
import kd.tsc.tso.business.domain.offer.service.cardinfo.bo.OfferInfoCardBo;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferEditMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferShowParamUtils;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;
import kd.tsc.tso.formplugin.web.offer.cardinfo.model.OfferInfoCardModel;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferInfoCardPlugin
extends AbstractOfferDynamicFramePlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(OfferInfoCardPlugin.class);
    private final OfferStrategyControl offerStrategyControl = OfferStrategyControl.Singleton.INSTANCE.getInstance();
    private final OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();
    private static final Map<String, Consumer<OfferInfoCardModel>> CLICK_ACTION = Maps.newHashMapWithExpectedSize((int)8);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        ((CardEntry)this.getControl("offer_entity")).addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"bar_modify", "btn_view", "btn_super", "btn_down", "bar_offerletter"});
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getPageCache().put("OFFER_INFO_CARD_ROW:", String.valueOf(evt.getRow()));
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Object appFileId = this.getCustomParam(Param.APPFILE.code);
        this.initCardList(appFileId);
    }

    private void initCardList(Object appFileId) {
        if (appFileId == null) {
            return;
        }
        int newEntryRow = 0;
        try (DataSet pageSet = this.offerStrategyControl.getOfferCardList(appFileId);){
            boolean hasExecute = false;
            boolean hasProcess = false;
            boolean isHasExpand = false;
            while (pageSet.hasNext()) {
                boolean matchStatus;
                Row pageRow = pageSet.next();
                if (!hasExecute) {
                    hasProcess = this.offerStrategyControl.getProcessAppfile(pageRow.getString("number"));
                    hasExecute = true;
                }
                CardEntry cardEntry = (CardEntry)this.getView().getControl("offer_entity");
                newEntryRow = this.getView().getModel().createNewEntryRow("offer_entity");
                OfferInfoCardBo offerInfoCardBo = OfferInfoCardBo.build().setNewEntryRow(newEntryRow).setCardEntry(cardEntry).setModel(this.getModel()).setAppfileProcess(hasProcess).setPageRow(pageRow);
                this.offerStrategyControl.initProcess(offerInfoCardBo);
                Long offerStatus = offerInfoCardBo.getPageRow().getLong("status");
                long applicant = offerInfoCardBo.getPageRow().getLong("applicant");
                boolean bl = matchStatus = OfferStatus.APPLYING.getCode().longValue() == offerStatus.longValue() || OfferStatus.APPLY_PASS.getCode().longValue() == offerStatus.longValue();
                if (!isHasExpand && matchStatus && applicant == TSCRequestContext.getUserId()) {
                    cardEntry.setChildVisible(true, newEntryRow, new String[]{"btn_super", "offer_card"});
                    cardEntry.setChildVisible(false, newEntryRow, new String[]{"btn_down", "desc_panel"});
                }
                isHasExpand = true;
            }
        }
        catch (Exception ex) {
            this.getView().getModel().deleteEntryRow("offer_entity", newEntryRow);
            log.error("\u3010OfferInfoCardPlugin\u3011\"beforeBindData\" error :", (Throwable)ex);
        }
    }

    public void click(EventObject eventObject) {
        String optKey;
        super.click(eventObject);
        Consumer<OfferInfoCardModel> consumer = null;
        if (eventObject.getSource() instanceof Label) {
            optKey = ((Label)eventObject.getSource()).getKey();
            consumer = CLICK_ACTION.get(optKey);
        }
        if (eventObject.getSource() instanceof Vector) {
            optKey = ((Vector)eventObject.getSource()).getKey();
            consumer = CLICK_ACTION.get(optKey);
        }
        if (consumer == null) {
            return;
        }
        Long offerId = (Long)this.getElementValue("offerid");
        if (offerId == null) {
            return;
        }
        DynamicObject offerObject = this.offerServiceHelper.loadSingle((Object)offerId);
        if (offerObject.getBoolean("isdelete")) {
            this.getView().showTipNotification(OfferMultilingualConstants.offerIsDelete());
            this.getView().invokeOperation("refresh");
        } else {
            OfferInfoCardModel model = OfferInfoCardModel.build().setOfferId(offerId).setOfferObj(offerObject).setView(this.getView()).setPluginName(this.getPluginName());
            consumer.accept(model);
        }
    }

    private static void btnView(OfferInfoCardModel model) {
        FormShowParameter formShowParameter = OfferShowParamUtils.getOfferInfoParamView((String)model.getView().getPageId(), (Object)model.getOfferId(), (String)model.getOfferObj().getString("candidatename"));
        model.getView().showForm(formShowParameter);
    }

    private static void btnOfferLetter(OfferInfoCardModel model) {
        String letterContent = OfferAttachmentService.getInstance().generateLetterContent(new DynamicObject[]{model.getOfferObj()});
        FormShowParameter formShowParameter = OfferShowParamUtils.getPreviewLetterParam((Long)model.getOfferId(), (String)OfferMultilingualConstants.getPreviewText(), (String)letterContent);
        model.getView().showForm(formShowParameter);
    }

    private static void btnEdit(OfferInfoCardModel model) {
        StringBuilder mutexStringBuilder = new StringBuilder();
        boolean requireSuccess = OfferEditMutexHelper.requireMutex((Long)model.getOfferId(), (StringBuilder)mutexStringBuilder);
        if (!requireSuccess) {
            model.getView().showTipNotification(mutexStringBuilder.toString());
        } else {
            DynamicObject approveObj = OfferBillServiceHelper.getInstance().queryByOfferId(model.getOfferId());
            OfferAuditStatus auditStatus = OfferStatusUtil.getOfferAuditStatus((DynamicObject)approveObj);
            if (!auditStatus.getCode().trim().equals(OfferAuditStatus.NULL.getCode().trim()) && !OfferAuditStatus.ALR_ABANDON.getCode().equals(auditStatus.getCode())) {
                String tips = OfferEditMultiLangConstants.hasProcessBillError((String)approveObj.getString("billno"));
                model.getView().showTipNotification(tips);
                model.getView().invokeOperation("refresh");
                model.getView().sendFormAction(model.getView());
                OfferEditMutexHelper.releaseMutex((Long)model.getOfferId());
            } else {
                OfferInfoCardPlugin.editOption(model);
            }
        }
    }

    private static void editOption(OfferInfoCardModel model) {
        long applicant = OfferInfoCardPlugin.getDynamicObject(model.getOfferObj(), "applicant").getLong("id");
        long offerStatus = OfferInfoCardPlugin.getDynamicObject(model.getOfferObj(), "status").getLong("id");
        if (applicant != TSCRequestContext.getUserId() && OfferStatus.PRE_APPLY.getCode() != offerStatus) {
            OfferInfoCardPlugin.showMessage(model.getView(), OfferMultilingualConstants.editOfferNoAuth());
        } else {
            FormShowParameter formShowParameter = OfferShowParamUtils.getOfferInfoParamEdit((String)model.getView().getPageId(), (Object)model.getOfferId(), (String)model.getOfferObj().getString("candidatename"));
            formShowParameter.setCustomParam("add_offer", (Object)"1");
            formShowParameter.setCloseCallBack(new CloseCallBack(model.getPluginName(), "refresh"));
            model.getView().showForm(formShowParameter);
        }
    }

    public static void clickDown(OfferInfoCardModel model) {
        int row = Integer.parseInt(model.getView().getPageCache().get("OFFER_INFO_CARD_ROW:"));
        CardEntry cardEntry = (CardEntry)model.getView().getControl("offer_entity");
        cardEntry.setChildVisible(true, row, new String[]{"btn_super", "offer_card"});
        cardEntry.setChildVisible(false, row, new String[]{"btn_down", "desc_panel"});
    }

    public static void clickSuper(OfferInfoCardModel model) {
        int row = Integer.parseInt(model.getView().getPageCache().get("OFFER_INFO_CARD_ROW:"));
        CardEntry cardEntry = (CardEntry)model.getView().getControl("offer_entity");
        cardEntry.setChildVisible(false, row, new String[]{"btn_super", "offer_card"});
        cardEntry.setChildVisible(true, row, new String[]{"btn_down", "desc_panel"});
    }

    private static void showMessage(IFormView view, String message) {
        view.showSuccessNotification(message);
        view.invokeOperation("refresh");
        view.sendFormAction(view);
    }

    static {
        CLICK_ACTION.put("bar_modify", OfferInfoCardPlugin::btnEdit);
        CLICK_ACTION.put("btn_view", OfferInfoCardPlugin::btnView);
        CLICK_ACTION.put("btn_super", OfferInfoCardPlugin::clickSuper);
        CLICK_ACTION.put("btn_down", OfferInfoCardPlugin::clickDown);
        CLICK_ACTION.put("bar_offerletter", OfferInfoCardPlugin::btnOfferLetter);
    }

    public static enum Param {
        APPFILE("appfile");

        private final String code;

        private Param(String code) {
            this.code = code;
        }
    }
}

