/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.infopage;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisAttachmentTool;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferOnlyViewHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.OfferBtnShowService;
import kd.tsc.tso.business.domain.offer.service.btnservice.copy.OfferCopyService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferShowParamUtils;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.business.application.external.auth.BizHRCSDataPermissionService;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.tuple.Pair;

public class OfferBaseInfoEdit
extends HRCoreBaseBillEdit
implements TabSelectListener,
UploadListener {
    private static final Log log = LogFactory.getLog(OfferBaseInfoEdit.class);
    private static final String TAB_OFFER_NOTICE = "tab_notice";
    private static final String TAB_OFFER_APPROVE = "tab_approve";
    private static final String TAB_OFFER_OP_RECORD = "tab_oprecord";
    private static final String TAB_OFFER_LETTER = "tab_letter";
    private static final String TAB_CHANGE_OFFER_LETTER_RECORD = "changeofferletterrecord";
    private static final String FLEX_NO_NOTICE_INFO = "nonoticeinfo";
    private static final String FLEX_NO_APPROVE = "noapprove";
    private static final String CANCEL_OFFER_CONFIRM_FLAG = "cancelOfferConfirm";
    private static final String CLOSE_OFFER_CONFIRM_FLAG = "closeOfferConfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        HisAttachmentTool.registerAttachments((IFormView)this.getView(), (UploadListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        BillShowParameter showParameter = (BillShowParameter)preOpenFormEventArgs.getFormShowParameter();
        if (HRStringUtils.equals((String)((String)showParameter.getCustomParam("fromPage")), (String)"appFilePage")) {
            showParameter.setCaption("Offer-" + showParameter.getCustomParam("name"));
            return;
        }
        if (showParameter.getPkId() == null && showParameter.getCustomParam("id") != null) {
            showParameter.setPkId((Object)Long.valueOf((String)showParameter.getCustomParam("id")));
        }
        if (OfferOnlyViewHelper.checkIsOnlyView((FormShowParameter)showParameter)) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        if ("wftask".equals(showParameter.getAppId())) {
            boolean hasDataPerm;
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"tsrsc", (String)"tso_somk_offerbaseinfo", (String)"47150e89000000ac");
            if (!hasPerm) {
                preOpenFormEventArgs.setCancel(true);
                preOpenFormEventArgs.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer\u7ba1\u7406\u7684\u201c\u67e5\u8be2\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBaseInfoEdit_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            }
            if (!(hasDataPerm = this.getPermissionQFilter(Long.valueOf((String)showParameter.getCustomParam("offerId"))))) {
                preOpenFormEventArgs.setCancel(true);
                preOpenFormEventArgs.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer\u7ba1\u7406\u7684\u201c\u67e5\u8be2\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBaseInfoEdit_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            }
            showParameter.setAppId("tsrsc");
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId(showParameter.getCustomParam("offerId"));
        }
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"busunit", "candidatename"});
        DynamicObject offerInfoById = OfferServiceHelper.getInstance().queryOfferInfoById(selectProperties, Long.valueOf(Long.parseLong(showParameter.getPkId().toString())));
        showParameter.setCaption("Offer-" + offerInfoById.getString("candidatename"));
    }

    private boolean getPermissionQFilter(Long id) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (superUser) {
            return true;
        }
        QFilter dataRuleFilter = BizHRCSDataPermissionService.getDataRule((Long)currUserId, (String)"tsrsc", (String)"tso_somk_offerbaseinfo", (String)"47150e89000000ac", null);
        QFilter idQFilter = new QFilter("id", "=", (Object)id);
        int count = OfferServiceHelper.getInstance().count("tso_somk_offerbaseinfo", new QFilter[]{dataRuleFilter, idQFilter});
        return 0 != count;
    }

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        OfferCopyService copyService = OfferCopyService.getInstance();
        if (copyService.isViewFromCopy(this.getView())) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().getFormShowParameter().setCustomParam("copy", (Object)"1");
            OfferCopyService.initOfferModel((IDataModel)this.getModel());
        }
        this.initOtherTabInfo();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tab_offer");
        DateTimeEdit dateEdit = (DateTimeEdit)this.getControl("pemploymenttime");
        dateEdit.setMinDate(DateUtils.afterNowDate((int)1));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String isConfirm = this.getPageCache().get("isConfirm");
        if (operate.getOperateKey().equals("cancel") && !HRStringUtils.equals((String)isConfirm, (String)"1")) {
            if (this.getModel().getDataChanged() && !HRStringUtils.equals((String)isConfirm, (String)"1")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u76f4\u63a5\u53d6\u6d88\u5c06\u4e22\u5931\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u786e\u8ba4\u53d6\u6d88\u5417\uff1f", (String)"OfferInfoAbstractPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CANCEL_OFFER_CONFIRM_FLAG, (IFormPlugin)this));
            } else {
                this.handleCancelOperate();
            }
        } else if (HRStringUtils.equals((String)"edit", (String)operate.getOperateKey()) && HRStringUtils.equals((String)"1", (String)isConfirm)) {
            this.getPageCache().put("isConfirm", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        beforeClosedEvent.setCheckDataChange(false);
        String isConfirm = this.getPageCache().get("isConfirm");
        if (this.getModel().getDataChanged() && this.getPageStatus() != OperationStatus.VIEW && !HRStringUtils.equals((String)isConfirm, (String)"1")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u76f4\u63a5\u53d6\u6d88\u5c06\u4e22\u5931\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u786e\u8ba4\u53d6\u6d88\u5417\uff1f", (String)"OfferInfoAbstractPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CLOSE_OFFER_CONFIRM_FLAG, (IFormPlugin)this));
            beforeClosedEvent.setCancel(true);
        } else {
            OfferEditMutexHelper.releaseMutexIfIsCurrentUser((IFormView)this.getView(), (Long)this.getOfferId());
        }
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
            Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
            TscMutexHelper.releaseMutex((String)"tso_somk_waitofferbase", (Long)Long.valueOf(String.valueOf(appfileId)), (String)"applyoffer");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (result == MessageBoxResult.Yes) {
            this.getPageCache().put("isConfirm", "1");
            if (HRStringUtils.equals((String)callBackId, (String)CANCEL_OFFER_CONFIRM_FLAG)) {
                this.handleCancelOperate();
            }
            if (HRStringUtils.equals((String)callBackId, (String)CLOSE_OFFER_CONFIRM_FLAG)) {
                OfferEditMutexHelper.releaseMutexIfIsCurrentUser((Long)this.getOfferId());
                if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
                    Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
                    TscMutexHelper.releaseMutex((String)"tso_somk_waitofferbase", (Long)Long.valueOf(String.valueOf(appfileId)), (String)"applyoffer");
                }
                this.getView().close();
            }
        }
    }

    private void handleCancelOperate() {
        OfferEditMutexHelper.releaseMutexIfIsCurrentUser((IFormView)this.getView(), (Long)this.getOfferId());
        if (OfferCopyService.getInstance().isViewFromCopy(this.getView())) {
            this.getView().close();
            return;
        }
        this.getView().getPageCache().remove("changePeadminOrg");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object addOffer = showParameter.getCustomParam("add_offer");
        if (Objects.nonNull(addOffer) && "1".equals(addOffer)) {
            this.getView().close();
            return;
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.put("fieldSwitchCacheKey", null);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().invokeOperation("refresh");
    }

    private void initOtherTabInfo() {
        this.showOfferHeadInfo();
        this.initButtonVisible();
        boolean isEdit = this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT;
        this.getView().setVisible(Boolean.valueOf(!isEdit), new String[]{TAB_OFFER_NOTICE, TAB_OFFER_LETTER, TAB_OFFER_APPROVE, TAB_OFFER_OP_RECORD, TAB_CHANGE_OFFER_LETTER_RECORD});
        if (isEdit) {
            return;
        }
        this.initOfferLetterTab();
        this.initOfferNoticeTab();
        this.initOfferApprovalTab();
        this.initOpRecordTab();
        this.initChangeOfferLetterRecordTab();
    }

    private void initChangeOfferLetterRecordTab() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tso_changeletterrecord");
        showParameter.getOpenStyle().setTargetKey(TAB_CHANGE_OFFER_LETTER_RECORD);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("offer", (Object)this.getOfferId());
        this.getView().showForm(showParameter);
    }

    private void initOpRecordTab() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbs_oprecord_list");
        showParameter.getOpenStyle().setTargetKey(TAB_OFFER_OP_RECORD);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("entitytype", (Object)"tso_somk_offerbase");
        showParameter.setCustomParam("bizobj", (Object)String.valueOf(this.getOfferId()));
        this.getView().showForm(showParameter);
    }

    private void initButtonVisible() {
        if (OfferCopyService.getInstance().isViewFromCopy(this.getView())) {
            OfferCopyService.getInstance().initButtonForCopy(this.getView());
            return;
        }
        if (OfferOnlyViewHelper.checkIsOnlyView((FormShowParameter)this.getView().getFormShowParameter())) {
            OfferOnlyViewHelper.initButtonVisible((IFormView)this.getView());
            return;
        }
        Pair pair = OfferBtnShowService.getBaseShowButtons((IFormView)this.getView());
        this.getView().setVisible(Boolean.TRUE, ((List)pair.getLeft()).toArray(new String[0]));
        this.getView().setVisible(Boolean.FALSE, ((List)pair.getRight()).toArray(new String[0]));
    }

    private void initOfferLetterTab() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject letter = dataEntity.getDynamicObject("offerletter");
        if (Objects.nonNull(dataEntity.get("template"))) {
            String letterContent = HRObjectUtils.isEmpty((Object)letter) ? OfferAttachmentService.getInstance().generateLetterContent(Boolean.TRUE, new DynamicObject[]{dataEntity}) : this.getLetterContent(letter);
            this.showLetterForm(dataEntity.getLong("id"), letterContent);
        } else if (HRObjectUtils.isEmpty((Object)letter)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"noletter"});
            this.closeOfferLetterView(dataEntity.getString("id"));
        } else {
            String letterContent = this.getLetterContent(letter);
            if (HRStringUtils.isEmpty((String)letterContent)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"noletter"});
                this.closeOfferLetterView(dataEntity.getString("id"));
            } else {
                this.showLetterForm(dataEntity.getLong("id"), letterContent);
            }
        }
    }

    private void closeOfferLetterView(String offerId) {
        String offerLetterTabPageId = this.getView().getPageCache().get("offerletter-" + offerId);
        if (HRStringUtils.isNotEmpty((String)offerLetterTabPageId) && null != this.getView().getView(offerLetterTabPageId)) {
            this.getView().getView(offerLetterTabPageId).close();
            this.getView().sendFormAction(this.getView().getView(offerLetterTabPageId));
        }
    }

    private String getLetterContent(DynamicObject letter) {
        DynamicObject letterStatus = letter.getDynamicObject("letterstatus");
        DynamicObject letterInfo = OfferLetterServiceHelper.getInstance().queryOne((Object)letter.getLong("id"));
        if (!HRObjectUtils.isEmpty((Object)letterStatus) && OfferLetterStatus.PRE_SEND.getCode().longValue() != letterStatus.getLong("id") && OfferLetterStatus.PRE_GENERATE.getCode().longValue() != letterStatus.getLong("id") && OfferLetterStatus.NOSEND_OUTTIME.getCode().longValue() != letterStatus.getLong("id")) {
            return HRStringUtils.isEmpty((String)letterInfo.getString("sendlettercontent_tag")) ? letterInfo.getString("lettercontent_tag") : letterInfo.getString("sendlettercontent_tag");
        }
        return letterInfo.getString("lettercontent_tag");
    }

    private void showLetterForm(long offerId, String letterContent) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"noletter"});
        this.getView().setVisible(Boolean.TRUE, new String[]{TAB_OFFER_LETTER});
        FormShowParameter letterParameter = new FormShowParameter();
        letterParameter.setFormId("tso_offerletter_preview");
        letterParameter.getOpenStyle().setTargetKey(TAB_OFFER_LETTER);
        letterParameter.getOpenStyle().setShowType(ShowType.InContainer);
        letterParameter.setCustomParam("offerid", (Object)offerId);
        letterParameter.setCustomParam("content", (Object)letterContent);
        this.getView().getPageCache().put("offerletter-" + String.valueOf(offerId), letterParameter.getPageId());
        this.getView().showForm(letterParameter);
    }

    private void initOfferNoticeTab() {
        OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatusByOffer((DynamicObject)this.getModel().getDataEntity());
        if (letterStatus != OfferLetterStatus.NULL && letterStatus != OfferLetterStatus.PRE_SEND && letterStatus != OfferLetterStatus.PRE_GENERATE && letterStatus != OfferLetterStatus.NOSEND_OUTTIME) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_NO_NOTICE_INFO});
            FormShowParameter offerNoticeParam = new FormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            if (HRStringUtils.equals((String)"tsrsc", (String)appId)) {
                offerNoticeParam.setFormId("tso_somk_offernotice");
            } else {
                offerNoticeParam.setFormId("tso_sost_offernotice");
            }
            offerNoticeParam.getOpenStyle().setTargetKey(TAB_OFFER_NOTICE);
            offerNoticeParam.getOpenStyle().setShowType(ShowType.InContainer);
            offerNoticeParam.setStatus(OperationStatus.VIEW);
            HashMap<String, Long> paramMap = new HashMap<String, Long>(1);
            paramMap.put("offerid", this.getOfferId());
            offerNoticeParam.setCustomParams(paramMap);
            this.getView().getPageCache().put("noticeTabPageId", offerNoticeParam.getPageId());
            this.getView().showForm(offerNoticeParam);
        } else {
            String noticeTabPageId = this.getView().getPageCache().get("noticeTabPageId");
            if (HRStringUtils.isNotEmpty((String)noticeTabPageId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_NO_NOTICE_INFO});
                if (null != this.getView().getView(noticeTabPageId)) {
                    this.getView().getView(noticeTabPageId).close();
                    this.getView().sendFormAction(this.getView().getView(noticeTabPageId));
                }
            }
        }
    }

    private void initOfferApprovalTab() {
        FormShowParameter approveParam = new FormShowParameter();
        approveParam.setFormId("tso_approval");
        approveParam.getOpenStyle().setTargetKey(TAB_OFFER_APPROVE);
        approveParam.getOpenStyle().setShowType(ShowType.InContainer);
        approveParam.setStatus(OperationStatus.EDIT);
        HashMap<String, Long> paramMap = new HashMap<String, Long>(1);
        paramMap.put("offerid", this.getOfferId());
        approveParam.setCustomParams(paramMap);
        this.getView().showForm(approveParam);
    }

    private void showOfferHeadInfo() {
        OperationStatus pageStatus = this.getPageStatus();
        String appId = this.getView().getFormShowParameter().getAppId();
        FormShowParameter offerHeadInfoParam = HRStringUtils.equals((String)"tsrsc", (String)appId) ? OfferShowParamUtils.getOfferHeadInfoParam((Long)this.getOfferId(), (OperationStatus)pageStatus, (String)"tso_somk_offerheadbase") : OfferShowParamUtils.getOfferHeadInfoParam((Long)this.getOfferId(), (OperationStatus)pageStatus, (String)"tso_offerhead_base");
        if (OfferCopyService.getInstance().isViewFromCopy(this.getView())) {
            offerHeadInfoParam.setCustomParam("number", this.getModel().getValue("number"));
        }
        this.getView().showForm(offerHeadInfoParam);
    }

    private void showAppFileHeadInfo() {
        OperationStatus pageStatus = this.getPageStatus();
        FormShowParameter headInfoParameter = new FormShowParameter();
        headInfoParameter.setFormId("tso_somk_offerheadbase");
        headInfoParameter.getOpenStyle().setTargetKey("headinfopanel");
        headInfoParameter.getOpenStyle().setShowType(ShowType.InContainer);
        headInfoParameter.setStatus(pageStatus);
        headInfoParameter.setCustomParam("fromPage", (Object)"appFilePage");
        headInfoParameter.setCustomParam("busunit.name", this.getView().getFormShowParameter().getCustomParam("busunit.name"));
        this.getView().showForm(headInfoParameter);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    private long getOfferId() {
        long pkId = 0L;
        BillShowParameter offerParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object id = offerParameter.getPkId();
        if (Objects.nonNull(id)) {
            pkId = Long.parseLong(id.toString());
        }
        return pkId;
    }

    private OperationStatus getPageStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus pageStatus = formShowParameter.getStatus();
        if (pageStatus == OperationStatus.EDIT) {
            return pageStatus;
        }
        return OperationStatus.VIEW;
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
            this.showAppFileHeadInfo();
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cancel", TAB_OFFER_LETTER, TAB_OFFER_NOTICE, TAB_OFFER_APPROVE, TAB_CHANGE_OFFER_LETTER_RECORD, TAB_OFFER_OP_RECORD});
            Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
            if (appfileId == null) {
                return;
            }
            DynamicObject appfileDy = AppFileHelper.queryOne((long)Long.parseLong(String.valueOf(appfileId)));
            if (HRObjectUtils.isEmpty((Object)appfileDy)) {
                return;
            }
            this.getModel().setValue("id", (Object)ORM.create().genLongId(this.getView().getEntityId()));
            this.getModel().setValue("appfile", (Object)appfileDy);
            this.getModel().setValue("candidatename", appfileDy.get("name"));
            this.getModel().setValue("busunit", appfileDy.get("createorg"));
            DynamicObject appResDy = appfileDy.getDynamicObject("appres");
            if (!HRObjectUtils.isEmpty((Object)appResDy)) {
                this.getModel().setValue("candidategender", appResDy.get("gender"));
                this.getModel().setValue("candidateage", appResDy.get("age"));
                this.getModel().setValue("candidatenation", appResDy.get("natreg"));
                this.getModel().setValue("candidateworkage", appResDy.get("workingyears"));
            }
            this.getModel().setValue("highesteducation", appfileDy.get("highesteducation"));
            this.getModel().setValue("schoolnametext", appfileDy.get("highesteduschool.name"));
            this.getModel().setValue("specialtycategory", appfileDy.get("highestspecialty"));
            this.getModel().setValue("candidatephone", appfileDy.get("phone"));
            this.getModel().setValue("candidateemail", appfileDy.get("email"));
            this.getModel().setValue("adminorg", appfileDy.get("adminorg"));
            DynamicObject positionDy = appfileDy.getDynamicObject("position");
            if (!HRObjectUtils.isEmpty((Object)positionDy)) {
                this.getModel().setValue("recruposi", positionDy.get("id"));
                DynamicObject recruSceneDy = positionDy.getDynamicObject("recruscene");
                if (!HRObjectUtils.isEmpty((Object)recruSceneDy)) {
                    this.getModel().setValue("recruscene", recruSceneDy.get("id"));
                }
                String posrespon = this.getNewPosrespon(positionDy);
                this.getModel().setValue("jobduties", (Object)posrespon);
            }
            String primaryIndex = OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)this.getModel().getDataEntity(true), (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.INIT);
            this.getModel().setValue("pindexes", (Object)primaryIndex);
            this.getModel().setValue("status", (Object)OfferStatus.PRE_APPLY.getCode());
            String number = CodeRuleServiceHelper.readNumber((String)"tso_somk_offerbase", (DynamicObject)this.getModel().getDataEntity(true), null);
            this.getModel().setValue("number", (Object)number);
            this.getModel().setValue("name", (Object)(appfileDy.get("name") + OfferMultilingualConstants.getOfferNameSuffix()));
            this.getModel().setValue("recrutyp", (Object)TSRBDPreDataEnum.RECRUTYP_SOCIALRECRUITMENT.getId());
            this.getModel().setValue("applicant", (Object)TSCRequestContext.getUserId());
            this.getModel().setValue("applytime", (Object)DateUtils.nowDateTime());
            this.getModel().setValue("tpsys", appfileDy.get("tpsys"));
        }
    }

    private String getNewPosrespon(DynamicObject positionDy) {
        String posrespon = positionDy.getString("posrespon");
        if (HRStringUtils.isEmpty((String)posrespon)) {
            return "";
        }
        String regex = "<[^>]+>";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(posrespon);
        while (matcher.find()) {
            String group = matcher.group();
            posrespon = posrespon.replace(group, "");
        }
        return posrespon;
    }
}

