/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.integrated;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.induction.service.endIdc.InductionEndService;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.dto.InductionEndResVo;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferVerifyResultEnum;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class InductionBtnEndIdcPlugin
extends AbstractOfferButtonPlugin {
    private static final String CLOSE_CALLBACK_ENDIDC = "close_callback_endIdc";
    private static final InductionEndService service = InductionEndService.getInstance();
    private static final Log logger = LogFactory.getLog(InductionBtnEndIdcPlugin.class);

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        logger.info("InductionBtnEndIdcPlugin.beforeDoOperation args {}", (Object)args);
        if ("endinduction".equals(operate.getOperateKey())) {
            HRBaseServiceHelper serviceHelper;
            DynamicObject dynamicObject;
            if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW && this.getView().getFormShowParameter() instanceof BillShowParameter && (dynamicObject = (serviceHelper = new HRBaseServiceHelper("tso_inductioninfo")).queryOne((Object)this.getModel().getDataEntity().getLong("id"))).getBoolean("isdelete")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u804c\u534f\u540c\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"InductionBtnEndIdcPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.checkExceedBatchMax(args)) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if (!this.checkIsBtnEndIdc(afterDoOperationEventArgs)) {
                return;
            }
            OfferVerifyResult offerVerifyResult = service.canExecute(this.getSelectedOfferIdList());
            super.afterHandleVerifyResult(offerVerifyResult, afterDoOperationEventArgs);
        }
    }

    private boolean checkIsBtnEndIdc(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Object source = afterDoOperationEventArgs.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"endinduction");
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        List verifyOfferFailedInfos = offerVerifyResult.getFailInfos();
        Map<String, List<VerifyOfferFailedInfo>> groupByInfo = verifyOfferFailedInfos.stream().collect(Collectors.groupingBy(VerifyOfferFailedInfo::getFailedReason));
        if (groupByInfo.size() > 1) {
            this.showBosOperateResultForm(verifyOfferFailedInfos);
        } else {
            VerifyOfferFailedInfo verifyOfferFailedInfo = (VerifyOfferFailedInfo)verifyOfferFailedInfos.get(0);
            if (OfferErrorEnum.INDUCTION_END_ERR_003.getCode().equals(verifyOfferFailedInfo.getFailedReason())) {
                this.getView().showErrorNotification(verifyOfferFailedInfo.getFailedMsg());
            } else {
                this.getView().showTipNotification(verifyOfferFailedInfo.getFailedMsg());
            }
        }
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        int offerRowCount = offerVerifyResult.getPassIds().size() + offerVerifyResult.getFailInfos().size();
        this.showEndInductionForm(offerRowCount);
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        int offerRowCount = offerVerifyResult.getPassIds().size();
        this.showEndInductionForm(offerRowCount);
    }

    private void showEndInductionForm(int offerRowCount) {
        logger.info("InductionBtnEndIdcPlugin.showEndInductionForm offerRowCount {}", (Object)offerRowCount);
        FormShowParameter endInductionShowParam = new FormShowParameter();
        endInductionShowParam.setFormId("tso_endidcreason");
        endInductionShowParam.setCaption(ResManager.loadKDString((String)"\u7ec8\u6b62\u5165\u804c", (String)"InductionBtnEndIdcPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        endInductionShowParam.getOpenStyle().setShowType(ShowType.Modal);
        endInductionShowParam.setCustomParam("offerRowCount", (Object)offerRowCount);
        endInductionShowParam.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.induction.validator.InductionEndIdcSecondValidator");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_ENDIDC);
        endInductionShowParam.setCloseCallBack(closeCallBack);
        this.getView().getPageCache().put("cache_appid", this.getView().getFormShowParameter().getAppId());
        this.getView().showForm(endInductionShowParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (!HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)CLOSE_CALLBACK_ENDIDC) || closedCallBackEvent.getReturnData() == null) {
            return;
        }
        InductionEndResVo returnData = (InductionEndResVo)closedCallBackEvent.getReturnData();
        OfferVerifyResult offerVerifyResult = service.canExecute(this.getSelectedOfferIdList());
        Integer verifyFlag = offerVerifyResult.getResultType();
        OfferVerifyResultEnum resultEnum = OfferVerifyResultEnum.getEnumByCode((Integer)verifyFlag);
        if (OfferVerifyResultEnum.ALL_FAIL.getCode().intValue() == resultEnum.getCode().intValue()) {
            this.handleverifyresultAllfail(offerVerifyResult);
        } else {
            boolean isSuccess = InductionEndService.getInstance().stopInduction(offerVerifyResult.getPassIds(), returnData);
            if (!isSuccess) {
                this.getView().showErrorNotification(InductionOpMultiLangConstants.errorIdcEnd());
                return;
            }
            if (super.checkIsPartSuccess(offerVerifyResult)) {
                super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
            } else {
                this.getView().showSuccessNotification(InductionOpMultiLangConstants.successIdcEnd());
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

