/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.integrated;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.induction.helper.InductionFormHelper;
import kd.tsc.tso.business.domain.induction.service.startIdc.InductionStartService;
import kd.tsc.tso.business.domain.induction.service.startIdc.helper.InductionStartHelper;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.bo.VerifyOfferFailedInfo;
import kd.tsc.tso.business.domain.offer.helper.BusinessEventHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.InductionOpMultiLangConstants;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tso.common.enums.induction.InductionStatus;
import kd.tsc.tso.common.enums.offer.OfferErrorEnum;
import kd.tsc.tso.common.enums.offer.OfferFieldEnableEnum;
import kd.tsc.tso.common.util.InductionFieldEditSwitch;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.hcf.SyncHcfHelper;
import kd.tsc.tspr.business.domain.offer.HomOnBrdService;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionCommModel;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionOfferDataBo;
import kd.tsc.tspr.business.domain.offer.mq.model.LaunchInductionInfo;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.CodeRuleUtils;

public class InductionBtnStartIdcPlugin
extends AbstractOfferButtonPlugin {
    private static final InductionStartService service = InductionStartService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(InductionBtnStartIdcPlugin.class);

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("startinduction".equals(operate.getOperateKey())) {
            if (this.isBillShowParameterAndEdit() && this.getModel().getDataEntity(true).get("pperiodterm") == null) {
                this.getModel().getDataEntity(true).set("pperiodterm", (Object)0);
            }
            if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW && this.getView().getFormShowParameter() instanceof BillShowParameter) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tso_inductioninfo");
                DynamicObject dynamicObject = serviceHelper.queryOne((Object)this.getModel().getDataEntity().getLong("id"));
                if (dynamicObject.getBoolean("isdelete")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u804c\u534f\u540c\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"InductionBtnStartIdcPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW && this.getView().getFormShowParameter() instanceof BillShowParameter) {
                Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
                if (appfileId == null) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject appfileDy = AppFileHelper.queryOne((long)Long.parseLong(String.valueOf(appfileId)));
                if (HRObjectUtils.isEmpty((Object)appfileDy)) {
                    args.setCancel(true);
                    return;
                }
                if (appfileDy.getBoolean("isdelete")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"InductionBtnStartIdcPlugin_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.validateApplyEmp()) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4ebaOffer\u73af\u8282\u672a\u5b8c\u6210\uff0c\u6216\u5df2\u5b58\u5728\u6709\u6548\u7684\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"InductionBtnStartIdcPlugin_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!this.checkStartIdcVerify()) {
                args.setCancel(true);
                return;
            }
            if (this.checkExceedBatchMax(args)) {
                args.setCancel(true);
            }
        }
    }

    private boolean validateApplyEmp() {
        long appfileId = this.getModel().getDataEntity().getLong("appfile.id");
        if (appfileId == 0L) {
            return false;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appfileDy = serviceHelper.queryOne((Object)appfileId);
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return false;
        }
        long offerStatusId = appfileDy.getLong("offer.status.id");
        long offerLetterStatusId = appfileDy.getLong("offerletter.datastatus.id");
        long offerReplyStatusId = appfileDy.getLong("offerletter.replystatus.id");
        String inductionStatus = appfileDy.getString("inductioninfo.inductionstatus");
        return !(offerStatusId == 0L && HRStringUtils.isEmpty((String)inductionStatus) || offerLetterStatusId == 1030020L && offerReplyStatusId == 1040030L && HRStringUtils.isEmpty((String)inductionStatus));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            OfferVerifyResult offerVerifyResult;
            if (!this.checkIsBtnStartIdc(afterDoOperationEventArgs)) {
                return;
            }
            if (this.isBillShowParameterAndEdit()) {
                offerVerifyResult = service.canExecute(this.getSelectedOfferIdList(), this.getModel().getDataEntity());
                InductionFormHelper.Singleton.INSTANCE.getInstance().saveOne(this.getModel().getDataEntity(true));
            } else {
                offerVerifyResult = service.canExecute(this.getSelectedOfferIdList(), null);
            }
            super.afterHandleVerifyResult(offerVerifyResult, afterDoOperationEventArgs);
        }
    }

    private boolean checkIsBtnStartIdc(AfterDoOperationEventArgs beforeDoOperationEventArgs) {
        Object source = beforeDoOperationEventArgs.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"startinduction");
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        List verifyOfferFailedInfos = offerVerifyResult.getFailInfos();
        Map<String, List<VerifyOfferFailedInfo>> groupByInfo = verifyOfferFailedInfos.stream().collect(Collectors.groupingBy(VerifyOfferFailedInfo::getFailedReason));
        if (groupByInfo.size() > 1) {
            this.showBosOperateResultForm(verifyOfferFailedInfos);
        } else {
            VerifyOfferFailedInfo verifyOfferFailedInfo = (VerifyOfferFailedInfo)verifyOfferFailedInfos.get(0);
            if (OfferErrorEnum.INDUCTION_START_ERR_005.getCode().equals(verifyOfferFailedInfo.getFailedReason())) {
                this.getView().showErrorNotification(verifyOfferFailedInfo.getFailedMsg());
            } else {
                this.getView().showTipNotification(verifyOfferFailedInfo.getFailedMsg());
            }
        }
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.insertCandidateAndStartIdcOp(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.insertCandidateAndStartIdcOp(offerVerifyResult);
    }

    private void insertCandidateAndStartIdcOp(OfferVerifyResult offerVerifyResult) {
        try {
            ArrayList<DynamicObject> appFileDys = new ArrayList<DynamicObject>(offerVerifyResult.getPassIds().size());
            if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
                appFileDys.add(this.getModel().getDataEntity().getDynamicObject("appfile"));
            } else if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
                QFilter qFilter = new QFilter("id", "in", (Object)offerVerifyResult.getPassIds());
                DynamicObject[] inductionInfoDys = InductionFormHelper.Singleton.INSTANCE.getInstance().loadDynamicObjectArray(new QFilter[]{qFilter});
                Arrays.stream(inductionInfoDys).forEach(inductionInfoDy -> appFileDys.add(inductionInfoDy.getDynamicObject("appfile")));
            }
            if (appFileDys.size() < 1) {
                return;
            }
            appFileDys.forEach(appFileDy -> {
                boolean isExistCandidate = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"isExistCandidateByAppFileId", (Object[])new Object[]{appFileDy.getLong("id")});
                if (!isExistCandidate) {
                    long arfId = appFileDy.getLong("arfrsm.id");
                    Map candidateSyncMap = SyncHcfHelper.generateCandidateSyncVO((DynamicObject)appFileDy, (Long)arfId);
                    if (candidateSyncMap == null) {
                        return;
                    }
                    LOGGER.info("InductionBtnStartIdcPlugin.insertCandidateAndStartIdcOp.candidateSyncMap\uff1a{}", (Object)candidateSyncMap);
                    HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"saveOrUpdateCandidate", (Object[])new Object[]{candidateSyncMap});
                    SyncHcfHelper.updateArfAttachmentToHcf((Long)appFileDy.getLong("id"), (Boolean)true, (Long)arfId);
                }
            });
            boolean isSynchronized = InductionStartService.getInstance().synchronizeCandidate(offerVerifyResult.getPassIds());
            if (!isSynchronized) {
                this.getView().showErrorNotification(InductionOpMultiLangConstants.synchronizedFail());
                return;
            }
        }
        catch (Exception exception) {
            LOGGER.error("InductionBtnStartIdcPlugin insertCandidate error", (Object)exception.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u751f\u6210\u5931\u8d25\u3002", (String)"InductionBtnStartIdcPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return;
        }
        this.startIdcOp(offerVerifyResult);
    }

    private void startIdcOp(OfferVerifyResult offerVerifyResult) {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW && this.getView().getFormShowParameter() instanceof BillShowParameter) {
            try (TXHandle tx = TX.required();){
                try {
                    this.getModel().getDataEntity().set("inductionstatus", (Object)InductionStatus.INDUCTION_PROCESS.getCode());
                    this.getModel().getDataEntity().set("launchinderrdesc", (Object)"");
                    this.getModel().getDataEntity().set("launchindtime", (Object)DateUtils.nowDateTime());
                    this.getModel().getDataEntity().set("modifytime", (Object)DateUtils.nowDateTime());
                    CodeRuleUtils.generateOneCodeRule((String)"number", (String)"tso_inductioninfo", (DynamicObject)this.getModel().getDataEntity());
                    this.getModel().getDataEntity().set("applicant", (Object)TSCRequestContext.getUserId());
                    this.getModel().getDataEntity(true).set("applytime", (Object)DateUtils.nowDateTime());
                    if (this.getModel().getDataEntity(true).get("pperiodterm") == null) {
                        this.getModel().getDataEntity(true).set("pperiodterm", (Object)0);
                    }
                    InductionCommModel inductionCommModel = this.getInductionCommModel();
                    InductionFieldEditSwitch fieldEditSetting = InductionFieldEditSwitch.init();
                    if (this.getModel().getDataEntity().get("recruscene") != null) {
                        fieldEditSetting.addFieldEditSetting("recruscene", OfferFieldEnableEnum.NOT_ENABLE);
                    }
                    DynamicObject fieldEditObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_offerfieswit");
                    fieldEditObj.set("pagekey", (Object)"tso_inductioninfo");
                    fieldEditObj.set("displaycontrol", JSON.toJSON((Object)fieldEditSetting.getFieldEditSetting()));
                    boolean hasBusinessEvenObj = BusinessEventHelper.getInstance().isExists((Object)this.getModel().getDataEntity().getLong("appfile.id"));
                    if (!hasBusinessEvenObj) {
                        DynamicObject businessEvenObj = this.setBusinessEventObj();
                        BusinessEventHelper.getInstance().saveOne(businessEvenObj);
                    }
                    InductionFormHelper.Singleton.INSTANCE.getInstance().saveOne(this.getModel().getDataEntity(true));
                    fieldEditObj.set("offer", this.getModel().getDataEntity().get("id"));
                    OfferFieldEditSwitchHelper.HELPER.saveOne(fieldEditObj);
                    HomOnBrdService homOnBrdService = new HomOnBrdService();
                    homOnBrdService.createOnBrd(inductionCommModel.getLaunchInductionInfo());
                    HRBaseServiceHelper appfileServiceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
                    QFilter appFileFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("appfile.id"));
                    DynamicObject appfileDy = appfileServiceHelper.queryOne("id,inductioninfo,filestatus", new QFilter[]{appFileFilter});
                    if (!HRObjectUtils.isEmpty((Object)appfileDy) && appfileDy.getLong("inductioninfo_id") == 0L) {
                        appfileDy.set("inductioninfo_id", (Object)this.getModel().getDataEntity().getLong("id"));
                        appfileDy.set("filestatus", (Object)AppFileStatusEnum.TBEMP.getValue());
                        appfileServiceHelper.updateOne(appfileDy);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("InductionBtnStartIdcPlugin startIdcOp error", (Throwable)exception);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u8d77\u5165\u804c\u5931\u8d25\u3002", (String)"InductionBtnStartIdcPlugin_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    tx.markRollback();
                    if (tx != null) {
                        if (var3_4 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return;
                }
            }
            this.updataAttachments();
            this.getView().showSuccessNotification(InductionOpMultiLangConstants.successIdcStart());
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
            return;
        }
        this.updataAttachments();
        boolean isSynchronized = InductionStartService.getInstance().synchronizeCandidate(offerVerifyResult.getPassIds());
        if (!isSynchronized) {
            this.getView().showErrorNotification(InductionOpMultiLangConstants.synchronizedFail());
            return;
        }
        boolean isSuccess = InductionStartService.getInstance().launchInduction(offerVerifyResult.getPassIds());
        if (!isSuccess) {
            this.getView().showErrorNotification(InductionOpMultiLangConstants.errorIdcStart());
            return;
        }
        if (super.checkIsPartSuccess(offerVerifyResult)) {
            super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
        } else {
            this.getView().showSuccessNotification(InductionOpMultiLangConstants.successIdcStart());
            if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
                this.getView().setStatus(OperationStatus.VIEW);
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private void updataAttachments() {
        if (this.isBillShowParameterAndEdit()) {
            AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            List attachmentData = panel.getAttachmentData();
            HashMap<String, List> attachmentDataMap = new HashMap<String, List>(16);
            attachmentDataMap.put("attachmentpanelap", attachmentData);
            AttachmentServiceHelper.saveTempAttachments((String)"tso_inductioninfo", (Object)this.getModel().getDataEntity(true).getLong("id"), (String)this.getView().getFormShowParameter().getAppId(), attachmentDataMap);
            InductionStartHelper.getInstance().updateOne(this.getModel().getDataEntity());
            String cacheJsonString = this.getPageCache().get("TampAttCache" + this.getView().getPageId());
            if (!StringUtils.isEmpty((String)cacheJsonString)) {
                this.getPageCache().remove("TampAttCache" + this.getView().getPageId());
            }
        }
    }

    private DynamicObject setBusinessEventObj() {
        DynamicObject businessEvenObj = BusinessDataServiceHelper.newDynamicObject((String)"tso_businessevent");
        businessEvenObj.set("id", (Object)this.getModel().getDataEntity().getLong("appfile.id"));
        businessEvenObj.set("number", (Object)this.getModel().getDataEntity().getLong("appfile.id"));
        businessEvenObj.set("name", (Object)"start induction");
        businessEvenObj.set("appid", (Object)"tsrsc");
        businessEvenObj.set("bustype", (Object)"tsrsc");
        businessEvenObj.set("servicename", (Object)"kd.tsc.tso.business.domain.moka.offer.induction.MkOfferInductionService");
        businessEvenObj.set("method", (Object)"inductionCallback");
        businessEvenObj.set("busid", (Object)this.getModel().getDataEntity().getLong("appfile.id"));
        businessEvenObj.set("servicetype", (Object)"1");
        businessEvenObj.set("createtime", (Object)DateUtils.nowDateTime());
        businessEvenObj.set("modifytime", (Object)DateUtils.nowDateTime());
        return businessEvenObj;
    }

    private InductionCommModel getInductionCommModel() {
        LaunchInductionInfo launchInductionInfo = new LaunchInductionInfo();
        launchInductionInfo.setAppfileId(Long.valueOf(this.getModel().getDataEntity().getLong("appfile.id")));
        launchInductionInfo.setInductionOfferDataBo(this.getInductionOfferDataObj());
        InductionCommModel inductionCommModel = new InductionCommModel();
        inductionCommModel.setMessageType(InductionCommModel.MessageType.LAUNCH_INDUCTION.getCode());
        inductionCommModel.setLaunchInductionInfo(launchInductionInfo);
        return inductionCommModel;
    }

    private InductionOfferDataBo getInductionOfferDataObj() {
        DynamicObject dynamicObject;
        InductionOfferDataBo inductionOfferDataBo = new InductionOfferDataBo();
        DynamicObject inducDy = this.getModel().getDataEntity();
        inductionOfferDataBo.setRecrutyp(inducDy.getDynamicObject("recrutyp"));
        inductionOfferDataBo.setPeadminorg(inducDy.getDynamicObject("peadminorg"));
        inductionOfferDataBo.setPlacework(inducDy.getDynamicObject("placework"));
        inductionOfferDataBo.setAgreePlacework(inducDy.getDynamicObject("placework"));
        inductionOfferDataBo.setPostassignmode(inducDy.getString("postassignmode"));
        inductionOfferDataBo.setPeposition(inducDy.getDynamicObject("peposition"));
        inductionOfferDataBo.setPestdposition(inducDy.getDynamicObject("pestdposition"));
        inductionOfferDataBo.setPejob(inducDy.getDynamicObject("pejob"));
        inductionOfferDataBo.setJobgrade(inducDy.getDynamicObject("jobgrade"));
        inductionOfferDataBo.setJoblevel(inducDy.getDynamicObject("joblevel"));
        inductionOfferDataBo.setEmprelationtype(inducDy.getDynamicObject("emprelationtype"));
        inductionOfferDataBo.setPemploymenttime(inducDy.getDate("pemploymenttime"));
        DynamicObject offer = this.getModel().getDataEntity(true).getDynamicObject("offer");
        if (!HRObjectUtils.isEmpty((Object)offer) && !HRObjectUtils.isEmpty((Object)(dynamicObject = OfferServiceHelper.getInstance().queryOne("number,id", new QFilter[]{new QFilter("id", "=", (Object)offer.getLong("id"))})))) {
            inductionOfferDataBo.setNumber(dynamicObject.getString("number"));
            inductionOfferDataBo.setOfferId(Long.valueOf(dynamicObject.getLong("id")));
        }
        inductionOfferDataBo.setLaborRelTypeCls(Long.valueOf(inducDy.getLong("laborreltypecls.id")));
        if (inducDy.getLong("laborreltypecls.id") != TSOPreDataEnum.LABORRELRELTYPECLS_PROBATION.getId().longValue() || inducDy.getDynamicObject("emprelationtype").getLong("id") != TSOPreDataEnum.LABORREL_TYPE_INTERN.getId().longValue()) {
            inductionOfferDataBo.setIsHavePeriodTerm(inducDy.getString("ishaveperiodterm"));
            inductionOfferDataBo.setPperiodterm(inducDy.getInt("pperiodterm"));
            inductionOfferDataBo.setPperiodtermunit(inducDy.getString("pperiodtermunit"));
        }
        List pkArray = inducDy.getDynamicObjectCollection("supervisor").stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        inductionOfferDataBo.setSupervisorIdList(pkArray);
        return inductionOfferDataBo;
    }

    private boolean isBillShowParameterAndEdit() {
        OperationStatus status;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return formShowParameter instanceof BillShowParameter && (OperationStatus.EDIT.equals((Object)(status = formShowParameter.getStatus())) || OperationStatus.ADDNEW.equals((Object)status));
    }
}

