/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.integrated;

import java.text.MessageFormat;
import java.util.EventObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferSecondValidatorFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;
import kd.tsc.tso.common.dto.InductionEndResVo;
import kd.tsc.tso.common.enums.TSOPreDataEnum;

public class InductionEndReasonPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InductionEndReasonPlugin.class);
    private static final String CONFIRM_CALLBACK_ENDIDC = "confirm_callback_endIdc";
    private static final String KEY_END_IDC_REASONTYPE = "endIdcReasonType";
    private static final String KEY_END_IDC_REASON = "endIdcReason";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object secondValidatorClass = formShowParameter.getCustomParam("secondValidatorClass");
        SecondValidatorInterface secondValidatorInterface = OfferSecondValidatorFactory.getSecondValidatorInterface((String)(secondValidatorClass + ""));
        if (secondValidatorInterface != null) {
            secondValidatorInterface.doValidator(this.getView(), args, "btnok");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("btnok".equals(key)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CONFIRM_CALLBACK_ENDIDC);
            int rowCount = (Integer)this.getView().getFormShowParameter().getCustomParam("offerRowCount");
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684{0}\u4e2a\u5165\u804c\u534f\u540c\u5355\u7ec8\u6b62\u5165\u804c\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u7ec8\u6b62\u5165\u804c\u5417\uff1f", (String)"InductionEndReasonPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]), rowCount);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getCallBackId().equals(CONFIRM_CALLBACK_ENDIDC) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            long endIdcReasonId = TSOPreDataEnum.ENDIDCREASONID.getId();
            IDataEntityProperty reasonProperty = this.getModel().getProperty(KEY_END_IDC_REASON);
            if (reasonProperty != null) {
                endIdcReasonId = this.getModel().getDataEntity(true).getLong("endIdcReason.id");
                logger.info("InductionEndReasonPlugin.confirmCallBack endIdcReasonId : {}", (Object)endIdcReasonId);
            }
            long endIdcReasonTypeId = TSOPreDataEnum.ENDIDCREASONTYPEID.getId();
            IDataEntityProperty reasonTypeProperty = this.getModel().getProperty(KEY_END_IDC_REASONTYPE);
            if (reasonTypeProperty != null) {
                endIdcReasonTypeId = this.getModel().getDataEntity(true).getLong("endIdcReasonType.id");
                logger.info("InductionEndReasonPlugin.confirmCallBack endIdcReasonTypeId : {}", (Object)endIdcReasonTypeId);
            }
            this.getView().returnDataToParent((Object)new InductionEndResVo(endIdcReasonTypeId, Long.valueOf(endIdcReasonId), String.valueOf(this.getModel().getValue("end_idc_reason"))));
            this.getView().close();
        }
    }
}

