/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.integrated;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class InductionManageListPlugin
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(InductionManageListPlugin.class);

    public void billListHyperLinkClick(HyperLinkClickArgs hyperLinkClickArgs) {
        super.billListHyperLinkClick(hyperLinkClickArgs);
        hyperLinkClickArgs.setCancel(true);
        Long offerPk = this.getCurrentRowPk();
        switch (hyperLinkClickArgs.getFieldName()) {
            case "candidatename": {
                this.showOfferInfoPage(offerPk);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[0]);
    }

    private Long getCurrentRowPk() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow listSelectedRow = listView.getCurrentSelectedRowInfo();
        return (Long)listSelectedRow.getPrimaryKeyValue();
    }

    private void showOfferInfoPage(Long offerPk) {
        BillShowParameter inductionFormShowParam = new BillShowParameter();
        String formId = "tso_inductioninfo";
        inductionFormShowParam.setFormId(formId);
        inductionFormShowParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        inductionFormShowParam.setStatus(OperationStatus.VIEW);
        inductionFormShowParam.setPkId((Object)offerPk);
        inductionFormShowParam.setPageId(this.getView().getPageId() + offerPk);
        this.getView().showForm((FormShowParameter)inductionFormShowParam);
    }

    public void setFilter(SetFilterEvent event) {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)2);
        QFilter sourceQFilter = new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
        filters.add(sourceQFilter);
        event.setCustomQFilters((List)filters);
        event.setOrderBy("modifytime desc");
        super.setFilter(event);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = customParams.get("type");
        List commonFilterColumnList = args.getCommonFilterColumns();
        String inductionStatus = (String)this.getView().getFormShowParameter().getCustomParam("inductionstatus");
        commonFilterColumnList.forEach(commonFilterColumn -> {
            if ("inductionstatus".equals(commonFilterColumn.getFieldName())) {
                commonFilterColumn.setDefaultValue(inductionStatus);
            }
            if (type != null && "recrutyp.name".equals(commonFilterColumn.getFieldName())) {
                commonFilterColumn.setDefaultValue("1020");
            }
        });
        super.filterContainerInit(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"delete") && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

