/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.letter;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadWaterMarkInfoEventArgs;
import kd.bos.form.watermark.WaterMark;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferStatusHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.letter.OfferLetterService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.enums.offer.status.IOfferStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.util.OfferStatusUtil;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;

public class OfferLetterBillEdit
extends HRCoreBaseBillEdit {
    private static final String BTN_DOWN = "btn_down";
    private static final String BTN_ACCEPT = "btn_accept";
    private static final String BTN_REFUSE = "btn_refuse";
    private static final String LBL_OFFERATTACHNAME = "letterattachname";
    private static final String LBL_OFFERATTACHSIZE = "letterattachsize";
    private static final String OFFERLETTER_ATTACHMENTKEY = "attachmentpanel_offerletter";
    private static final String FLEX_OFFERLETTERATTACH = "letterattachflex";
    private static final String FLEX_BTN = "btnflex";
    private static final String FLEX_HIREINFO = "hireinfoflex";
    private static final String LBL_OFFER_STATUS = "offerstatus";
    private static final String KEY_HTMLAP = "htmlap";
    private static final String KEY_WARNING_TIP = "warningtip";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Label label = (Label)this.getControl(BTN_DOWN);
        label.addClickListener((ClickListener)this);
        Button btnRefuse = (Button)this.getControl(BTN_REFUSE);
        btnRefuse.addClickListener((ClickListener)this);
        Button btnAccept = (Button)this.getControl(BTN_ACCEPT);
        btnAccept.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Long letterId = this.getLetterId();
        if (letterId == 0L) {
            return;
        }
        this.initLetterInfo(letterId);
        this.statusHandle(letterId);
    }

    public void setWaterMarkInfo(LoadWaterMarkInfoEventArgs e) {
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        long letterId = this.getLetterId(parameter);
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne((Object)letterId);
        DynamicObject template = offerLetter.getDynamicObject("template");
        if (null == template) {
            return;
        }
        OfferTemplateHelper offerTemplateHelper = new OfferTemplateHelper();
        if (offerTemplateHelper.isWatermark(Long.valueOf(template.getLong("id")))) {
            WaterMark waterMark = offerTemplateHelper.getWaterMark("tso_offerletterbill");
            e.setWaterMark(waterMark);
        }
    }

    private void statusHandle(Long offerLetterId) {
        OfferLetterStatus status;
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne((Object)offerLetterId);
        Label label = (Label)this.getControl(LBL_OFFER_STATUS);
        OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatus((DynamicObject)offerLetter);
        if (letterStatus == OfferLetterStatus.ALR_DISCARD) {
            status = letterStatus;
            label.setText(OfferLetterDataStatus.INVALID.getName());
        } else {
            OfferLetterReplyStatus replyStatus = OfferStatusUtil.getLetterReplyStatus((DynamicObject)offerLetter);
            status = replyStatus;
            label.setText(replyStatus.getName());
        }
        this.getView().updateControlMetadata(LBL_OFFER_STATUS, OfferStatusHelper.getStatusMetaDataMap((IOfferStatus)status));
    }

    public void click(EventObject eventObject) {
        String key;
        super.click(eventObject);
        if (eventObject.getSource() instanceof Label) {
            Label label = (Label)eventObject.getSource();
            key = label.getKey();
        } else if (eventObject.getSource() instanceof Button) {
            Button button = (Button)eventObject.getSource();
            key = button.getKey();
        } else {
            return;
        }
        Long letterId = this.getLetterId();
        if (letterId == 0L) {
            return;
        }
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne((Object)letterId);
        Date validtime = offerLetter.getDate("validtime");
        long days = OfferLetterServiceHelper.getInstance().checkValidDay(validtime);
        if (days < 0L) {
            this.getView().close();
            return;
        }
        if (HRStringUtils.equals((String)key, (String)BTN_DOWN)) {
            this.handleDownFileClickEvt(letterId);
        } else if (HRStringUtils.equals((String)key, (String)BTN_ACCEPT)) {
            this.handleBtnAcceptClickEvt(letterId);
        } else if (HRStringUtils.equals((String)key, (String)BTN_REFUSE)) {
            this.handleBtnRefuseClickEvt(letterId);
        }
    }

    private void handleDownFileClickEvt(Long letterId) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"tso_offerletter", (Object)letterId, (String)OFFERLETTER_ATTACHMENTKEY);
        if (attachments.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4fe1\u606f\u4e22\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferLetterBillEdit_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = ((Map)attachments.get(0)).get("url").toString();
        this.getView().download(url);
    }

    private void handleBtnRefuseClickEvt(Long letterId) {
        this.checkOfferStatus(letterId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("letterid", (Object)letterId);
        formShowParameter.setFormId("tso_offerreject");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void handleBtnAcceptClickEvt(Long letterId) {
        OfferLetterService offerLetterService = OfferLetterService.Singleton.INSTANCE.getInstance();
        boolean isSuccess = offerLetterService.acceptOffer(letterId);
        if (isSuccess) {
            DynamicObject letterObj = OfferLetterServiceHelper.getInstance().loadSingle((Object)letterId);
            DynamicObject companyObj = letterObj.getDynamicObject("offer.pecompany");
            String companyName = "";
            if (companyObj != null) {
                companyName = companyObj.getString("name");
            }
            String msg = MessageFormat.format(OfferMultilingualConstants.acceptOfferSuccess(), companyName);
            this.getView().showSuccessNotification(msg);
            this.getView().invokeOperation("refresh");
            offerLetterService.noticeSendUser(letterId, "1");
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"OfferLetterBillEdit_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkOfferStatus(Long letterId) {
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne((Object)letterId);
        OfferLetterReplyStatus replyStatus = OfferStatusUtil.getLetterReplyStatus((DynamicObject)offerLetter);
        if (replyStatus != OfferLetterReplyStatus.PRE_REPLY) {
            throw new KDBizException(OfferMultilingualConstants.offerStatusChange());
        }
    }

    private void initLetterInfo(Long letterId) {
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne((Object)letterId);
        OfferLetterReplyStatus replyStatus = OfferStatusUtil.getLetterReplyStatus((DynamicObject)offerLetter);
        OfferLetterStatus letterStatus = OfferStatusUtil.getLetterStatus((DynamicObject)offerLetter);
        if (letterStatus == OfferLetterStatus.ALR_DISCARD || replyStatus != OfferLetterReplyStatus.PRE_REPLY) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_BTN});
        }
        this.setOfferLetterToHtmlAp(letterId);
        Date validtime = offerLetter.getDate("validtime");
        if (offerLetter.getBoolean("isgtannex")) {
            String normalTip = ResManager.loadKDString((String)"Offer\u67e5\u770b\u94fe\u63a5\u8fd8\u6709{0}\u5929\u8fc7\u671f\u3002", (String)"OfferLetterBillEdit_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            String abortTip = ResManager.loadKDString((String)"Offer\u67e5\u770b\u94fe\u63a5\u5c06\u4e8e\u4eca\u5929\u8fc7\u671f\u3002", (String)"OfferLetterBillEdit_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            this.setWarningTip(validtime, normalTip, abortTip);
            this.updateAttachmentLabelInfo(letterId, validtime);
        } else {
            String normalTip = ResManager.loadKDString((String)"Offer\u67e5\u770b\u94fe\u63a5\u8fd8\u6709{0}\u5929\u8fc7\u671f\u3002", (String)"OfferLetterBillEdit_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            String abortTip = ResManager.loadKDString((String)"\u8bbf\u95ee\u94fe\u63a5\u6709\u6548\u671f\u622a\u6b62\u4eca\u5929", (String)"OfferLetterBillEdit_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            this.setWarningTip(validtime, normalTip, abortTip);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_HIREINFO, FLEX_OFFERLETTERATTACH});
        }
    }

    public void setWarningTip(Date validtime, String normalTip, String abortTip) {
        long days = OfferLetterServiceHelper.getInstance().checkValidDay(validtime);
        String tipMsg = "";
        if (days > 0L) {
            tipMsg = MessageFormat.format(normalTip, days);
        } else if (days == 0L) {
            tipMsg = abortTip;
        }
        Label warningTip = (Label)this.getView().getControl(KEY_WARNING_TIP);
        warningTip.setText(tipMsg);
    }

    private void setOfferLetterToHtmlAp(long letterId) {
        DynamicObject offerLetter = OfferLetterServiceHelper.getInstance().queryOne((Object)letterId);
        Html html = (Html)this.getView().getControl(KEY_HTMLAP);
        if (offerLetter != null) {
            String letterContent = OfferAttachmentService.getInstance().getSendLetterContentByOfferLetter(offerLetter);
            html.setConent(letterContent);
        } else {
            html.setConent("");
        }
    }

    private long getLetterId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return this.getLetterId(formShowParameter);
    }

    private long getLetterId(FormShowParameter formShowParameter) {
        Object idObj = formShowParameter.getCustomParam("letterid");
        return Long.parseLong(idObj.toString());
    }

    private void updateAttachmentLabelInfo(Long letterId, Date validtime) {
        List letterAttachs = AttachmentServiceHelper.getAttachments((String)"tso_offerletter", (Object)letterId, (String)OFFERLETTER_ATTACHMENTKEY);
        if (letterAttachs.size() < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_HIREINFO, FLEX_OFFERLETTERATTACH});
            String normalTip = ResManager.loadKDString((String)"Offer\u67e5\u770b\u94fe\u63a5\u8fd8\u6709{0}\u5929\u8fc7\u671f\u3002", (String)"OfferLetterBillEdit_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            String abortTip = ResManager.loadKDString((String)"\u8bbf\u95ee\u94fe\u63a5\u6709\u6548\u671f\u622a\u6b62\u4eca\u5929\u3002", (String)"OfferLetterBillEdit_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            this.setWarningTip(validtime, normalTip, abortTip);
            return;
        }
        String letterAttachName = OfferLetterServiceHelper.getInstance().getLetterAttachNameWithExt(letterId);
        Label label = (Label)this.getView().getControl(LBL_OFFERATTACHNAME);
        label.setText(letterAttachName);
        long size = (Long)((Map)letterAttachs.get(0)).get("size");
        Label labelSize = (Label)this.getView().getControl(LBL_OFFERATTACHSIZE);
        labelSize.setText("(" + OfferUtils.getFileSizeOfMb((double)size) + "M)");
    }
}

