/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.letter;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Html;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.offerLetter.DefaultOfferLetterTemplateBizService;
import kd.tsc.tsrbd.business.domain.offer.service.modal.AbstractOfferLetterTemplateBizService;
import kd.tsc.tsrbd.business.domain.offer.service.modal.impl.IOfferLetterTemplateService;

public class OfferLetterPreviewInfoPlugin
extends HRDynamicFormBasePlugin {
    private static final Log log = LogFactory.getLog(OfferLetterPreviewInfoPlugin.class);
    private static final String KEY_HTMLAP = "content";
    private OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();
    private OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String content = "";
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object contentParam = showParameter.getCustomParam(KEY_HTMLAP);
        Boolean isHideButton = (Boolean)showParameter.getCustomParam("isHideButton");
        if (Objects.nonNull(contentParam)) {
            content = contentParam.toString();
            Object offerId = this.getOfferId();
            if (offerId == null || Long.parseLong(offerId.toString()) == 0L) {
                return;
            }
            DynamicObject offer = this.offerServiceHelper.getOfferById((Long)offerId);
            DefaultOfferLetterTemplateBizService offerLetterTemplateBizService = new DefaultOfferLetterTemplateBizService();
            IOfferLetterTemplateService templateService = new IOfferLetterTemplateService((AbstractOfferLetterTemplateBizService)offerLetterTemplateBizService);
            String salaryType = offer.getString("salarytype");
            if ("2".equals(salaryType)) {
                Map salaryMap = OfferAttachmentService.getInstance().getSalaryMap(offer);
                log.info("OfferLetterPreviewInfoPlugin.salaryMap -> {}", (Object)salaryMap);
                content = templateService.previewOfferLetterTemplate(content, salaryMap, new DynamicObject[]{offer});
            } else {
                content = templateService.previewOfferLetterTemplate(content, Boolean.FALSE, new DynamicObject[]{offer});
            }
        } else {
            Object letterId = this.getLetterId();
            log.info("OfferLetterPreviewInfoPlugin.getLetterId -> {}", letterId);
            if (letterId == null || Long.parseLong(letterId.toString()) == 0L) {
                return;
            }
            DynamicObject letterInfo = this.letterServiceHelper.queryOne(letterId);
            if (letterInfo != null) {
                content = OfferAttachmentService.getInstance().getOfferLetterContentByOfferLetter(letterInfo);
            }
        }
        this.getView().setVisible(Boolean.valueOf(isHideButton != null && isHideButton != false), new String[]{"flex_button"});
        Html html = (Html)this.getView().getControl(KEY_HTMLAP);
        html.setConent(content);
    }

    private Object getOfferId() {
        return this.getView().getFormShowParameter().getCustomParam("offerid");
    }

    private Object getLetterId() {
        return this.getView().getFormShowParameter().getCustomParam("letterid");
    }
}

