/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.letter.change;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferStatusHelper;
import kd.tsc.tso.business.domain.offer.service.OfferBaseService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delete.LetterChangeBillDeleteService;
import kd.tsc.tso.business.domain.offer.service.changeletter.OfferLetterChangeBtnService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferLtrChgBillMultiLangConstatns;
import kd.tsc.tso.common.enums.offer.status.IOfferStatus;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.formplugin.web.offer.letter.change.model.LetterChangeBillModel;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.springframework.util.ObjectUtils;

public class ChangeLetterBillEdit
extends HRDataBaseEdit {
    private static final OfferLetterChangeBtnService btnService = OfferLetterChangeBtnService.Singleton.INSTANCE.getInstance();
    private static final OfferBaseService offerBaseService = OfferBaseService.init();
    private static final ChangeLetterBillHelper changeLetterBillHelper = ChangeLetterBillHelper.getInstance();
    private static final LetterChangeBillDeleteService billDeleteService = LetterChangeBillDeleteService.getInstance();
    private static final String KEY_CONFIRM_CALL_BACK = "billSubmitConfirmCallBack";
    private static final String KEY_CONFIRM_CALL_EDIT_BACK = "editBillSubmitConfirmCallBack";
    private static final String KEY_CHANGETABPAGEAP = "changetabpageap";
    private static final String KEY_OFFERTABPAGEAP = "offertabpageap";
    private static final String KEY_LETTERTABPAGEAP = "lettertabpageap";
    private static final String KEY_FLEXPANELAP2 = "flexpanelap2";
    private static final Map<String, Consumer<LetterChangeBillModel>> CLICK_ACTION = Maps.newHashMapWithExpectedSize((int)8);
    private static LetterChangeBillDeleteService changeBillDeleteService = LetterChangeBillDeleteService.getInstance();

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        String appId = preOpenFormEventArgs.getFormShowParameter().getAppId();
        FormShowParameter formShowParameter = preOpenFormEventArgs.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
            Object pkId = billShowParameter.getPkId();
            DynamicObject letterChgBill = changeLetterBillHelper.loadSingle(pkId);
            if (!"wftask".equals(appId)) {
                this.checkPerm(preOpenFormEventArgs, letterChgBill);
            }
            if (!HRStringUtils.isEmpty((String)letterChgBill.getString("applyname"))) {
                formShowParameter.setCaption(letterChgBill.getString("applyname"));
            }
        }
    }

    private void checkPerm(PreOpenFormEventArgs preOpenFormEventArgs, DynamicObject letterChgBill) {
        Optional.ofNullable(letterChgBill).ifPresent(billObj -> {
            DynamicObject offerObj = letterChgBill.getDynamicObject("offer");
            long busunitId = offerObj.getLong("busunit.id");
            Map btnMap = btnService.checkBtnPerm(busunitId, Collections.singletonList("btn_view"));
            if (!((Boolean)btnMap.get("btn_view")).booleanValue()) {
                preOpenFormEventArgs.setCancel(true);
                preOpenFormEventArgs.setCancelMessage(OfferLtrChgBillMultiLangConstatns.notBillViewPerm());
            }
        });
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        DynamicObject letterBillObj = this.getModel().getDataEntity(true);
        long offerId = letterBillObj.getLong("offer.id");
        Map btnMap = btnService.getBillShowButtons(opStatus, letterBillObj, offerId);
        LinkedList showBtn = new LinkedList();
        LinkedList hideBtn = new LinkedList();
        btnMap.forEach((btn, perm) -> {
            if (perm.booleanValue()) {
                showBtn.add(btn);
            } else {
                hideBtn.add(btn);
            }
        });
        this.getView().setVisible(Boolean.TRUE, showBtn.toArray(new String[0]));
        this.getView().setVisible(Boolean.FALSE, hideBtn.toArray(new String[0]));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("cancel".equals(operate.getOperateKey())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        } else if ("save".equals(operate.getOperateKey())) {
            if (!ChangeLetterBillEdit.checkPosition(operate, this.getView())) {
                args.setCancel(true);
                return;
            }
            DynamicObject dbBill = ChangeLetterBillHelper.getInstance().loadSingle((Object)this.getModel().getDataEntity(true).getLong("id"));
            String ltrChgPageKey = this.getView().getPageCache().get("CACHE_KEY_OFFERLTRCHAGE_PAGEKEY");
            IFormView ltrChgView = this.getView().getView(ltrChgPageKey);
            this.doSave(args, ltrChgView, dbBill);
        } else if ("submit".equals(operate.getOperateKey())) {
            if (!ChangeLetterBillEdit.checkPosition(operate, this.getView())) {
                args.setCancel(true);
                return;
            }
            OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
            boolean editStatus = "submit".equals(operate.getOperateKey()) && OperationStatus.EDIT.equals((Object)opStatus);
            String callBack = editStatus ? KEY_CONFIRM_CALL_EDIT_BACK : KEY_CONFIRM_CALL_BACK;
            int letterAudit = OfferParamConfigService.getInstance().getOfferLetterApprovalConfig();
            if (letterAudit != 1) {
                this.getView().showConfirm(OfferLtrChgBillMultiLangConstatns.letterNoAudit(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBack, (IFormPlugin)this));
                args.setCancel(true);
            } else {
                DynamicObject dbBill = ChangeLetterBillHelper.getInstance().loadSingle((Object)this.getModel().getDataEntity(true).getLong("id"));
                String ltrChgPageKey = this.getView().getPageCache().get("CACHE_KEY_OFFERLTRCHAGE_PAGEKEY");
                IFormView ltrChgView = this.getView().getView(ltrChgPageKey);
                this.doSubmit(args, ltrChgView, dbBill, editStatus);
            }
        } else if (HRStringUtils.equals((String)"modify", (String)operate.getOperateKey())) {
            if (!ChangeLetterBillEdit.checkPosition(operate, this.getView())) {
                args.setCancel(true);
                return;
            }
        } else {
            LetterChangeBillModel billModel = LetterChangeBillModel.build().setFormView(this.getView()).setFormPlugin((IFormPlugin)this).setOperationEventArgs(args);
            Optional.ofNullable(CLICK_ACTION.get(operate.getOperateKey())).ifPresent(customer -> customer.accept(billModel));
        }
    }

    private static void doDeleteBill(LetterChangeBillModel letterChangeBillModel) {
        AbstractOperate operate = (AbstractOperate)letterChangeBillModel.getOperationEventArgs().getSource();
        if (!ChangeLetterBillEdit.checkPosition(operate, letterChangeBillModel.getFormView())) {
            letterChangeBillModel.getOperationEventArgs().setCancel(true);
        } else {
            letterChangeBillModel.getFormView().showConfirm(OfferDeleteMultiLangConstants.deleteLetterChangeBillConfirmBox(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteBillConfirm", letterChangeBillModel.getFormPlugin()));
        }
    }

    public void doSave(BeforeDoOperationEventArgs args, IFormView ltrChgView, DynamicObject dbBill) {
        if (this.checkField(ltrChgView, true)) {
            args.setCancel(true);
            return;
        }
        OperationResult ltrOptResult = changeLetterBillHelper.saveChangeLetterBill(ltrChgView, dbBill);
        this.setErrorMessage(ltrOptResult, args);
    }

    public void doSubmit(BeforeDoOperationEventArgs args, IFormView ltrChgView, DynamicObject dbBill, boolean editStatus) {
        if (this.checkField(ltrChgView, editStatus)) {
            args.setCancel(true);
            return;
        }
        OperationResult ltrOptResult = changeLetterBillHelper.submitChangeLetterBill(ltrChgView, dbBill, editStatus, false);
        this.setErrorMessage(ltrOptResult, args);
    }

    public void setErrorMessage(OperationResult ltrOptResult, BeforeDoOperationEventArgs args) {
        if (!ltrOptResult.isSuccess()) {
            List validateErrors = ltrOptResult.getValidateResult().getValidateErrors();
            List operateErrorInfos = ((ValidateResult)validateErrors.get(0)).getAllErrorInfo();
            List messages = operateErrorInfos.stream().map(OperateInfo::getMessage).collect(Collectors.toList());
            this.getView().showTipNotification(String.join((CharSequence)"", messages));
            args.setCancel(true);
        }
    }

    public boolean checkField(IFormView ltrChgView, boolean editStatus) {
        if (!editStatus) {
            return false;
        }
        IDataModel model = ltrChgView.getModel();
        Object validTime = model.getValue("newvalidtime");
        String changereason = ((OrmLocaleValue)model.getValue("changereason")).getLocaleValue();
        DataEntityPropertyCollection collection = model.getDataEntity(true).getDynamicObjectType().getProperties();
        String msg = "";
        return this.checkFieldValue(validTime, msg, collection, changereason);
    }

    public boolean checkFieldValue(Object validTime, String msg, DataEntityPropertyCollection collection, String changereason) {
        if (validTime == null) {
            msg = ((IDataEntityProperty)collection.get((Object)"newvalidtime")).getDisplayName().getLocaleValue();
        }
        if ("".equals(changereason)) {
            if (!"".equals(msg)) {
                msg = msg + "\u3001";
            }
            msg = msg + ((IDataEntityProperty)collection.get((Object)"changereason")).getDisplayName().getLocaleValue();
        }
        if (!"".equals(msg)) {
            this.getView().showTipNotification(msg + OfferLtrChgBillMultiLangConstatns.notNull());
            return true;
        }
        return false;
    }

    private static boolean checkPosition(AbstractOperate operate, IFormView formView) {
        long letterbillId = formView.getModel().getDataEntity(true).getLong("id");
        if (letterbillId == 0L) {
            return false;
        }
        DynamicObject letterBillObj = changeLetterBillHelper.loadSingle((Object)letterbillId);
        DynamicObject offerObj = letterBillObj.getDynamicObject("offer");
        boolean appfileProcess = offerBaseService.getAppfileProcess(offerObj.getLong("id"));
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": {
                boolean isNext = ChangeLetterBillEdit.tipNoProcessMsg(formView, operate, appfileProcess);
                if (!isNext) {
                    return isNext;
                }
                OfferAuditStatus auditStr = OfferAuditStatus.getStatusByCode((String)letterBillObj.getString("billstatus"));
                boolean isMatchStatus = auditStr != OfferAuditStatus.TEMPORARY && auditStr != OfferAuditStatus.WAIT_RESUBMIT;
                isNext = ChangeLetterBillEdit.tipNoMatchStatus(formView, operate, isMatchStatus);
                return isNext;
            }
            case "modify": {
                if (letterBillObj.getBoolean("deletestatus")) {
                    formView.showTipNotification(OfferDeleteMultiLangConstants.noLetterChangeBill());
                    return false;
                }
                return true;
            }
            case "bar_delete": {
                String checkResult = changeBillDeleteService.checkCondition(letterBillObj);
                if (HRStringUtils.isNotEmpty((String)checkResult)) {
                    formView.showTipNotification(checkResult);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject letterBillObj = this.getModel().getDataEntity(true);
        long offerId = letterBillObj.getLong("offer.id");
        OfferEditMutexHelper.releaseMutexIfIsCurrentUser((Long)offerId);
    }

    public static boolean tipNoProcessMsg(IFormView formView, AbstractOperate operate, boolean appfileProcess) {
        if (!appfileProcess) {
            String tipMsg = OfferLtrChgBillMultiLangConstatns.appFileNotInProcessError();
            String opName = operate.getOperateName().getLocaleValue();
            formView.showTipNotification(MessageFormat.format(tipMsg, opName));
            return false;
        }
        return true;
    }

    public static boolean tipNoMatchStatus(IFormView formView, AbstractOperate operate, boolean isMatchStatus) {
        if (isMatchStatus) {
            String tipMsg = OfferLtrChgBillMultiLangConstatns.statusErrorForBill();
            String opName = operate.getOperateName().getLocaleValue();
            formView.showTipNotification(MessageFormat.format(tipMsg, opName));
            return false;
        }
        return true;
    }

    private BaseShowParameter openEditForm() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tso_changelettervalidedit");
        showParameter.getOpenStyle().setTargetKey(KEY_CHANGETABPAGEAP);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId((Object)this.getModel().getDataEntity(true).getLong("changelettervalid.id"));
        this.getView().showForm((FormShowParameter)showParameter);
        this.getView().getPageCache().put("CACHE_KEY_OFFERLTRCHAGE_PAGEKEY", showParameter.getPageId());
        return showParameter;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("businessKey");
        if (!ObjectUtils.isEmpty((Object)customParam)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEXPANELAP2});
        }
        this.initHeadDetail();
        this.initTab();
    }

    private void initHeadDetail() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject offer = dataEntity.getDynamicObject("offer");
        DynamicObject recruitType = offer.getDynamicObject("recrutyp");
        String recruitTypeString = recruitType.getString("name");
        Label label = (Label)this.getControl("recrutyp");
        label.setText(recruitTypeString);
        Label auditStatusLabel = (Label)this.getView().getControl("status");
        String auditStatus = dataEntity.getString("billstatus");
        OfferAuditStatus auditStatusEnum = OfferAuditStatus.getStatusByCode((String)auditStatus);
        this.getView().updateControlMetadata("status", OfferStatusHelper.getStatusMetaDataMap((IOfferStatus)auditStatusEnum));
        auditStatusLabel.setText(auditStatusEnum.getName());
        Label busUnitLabel = (Label)this.getControl("busunit");
        busUnitLabel.setText(offer.getString("busunit.name"));
    }

    private void initTab() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject offerLetter = dataEntity.getDynamicObject("offerletter");
        DynamicObject offer = dataEntity.getDynamicObject("offer");
        DynamicObject change = dataEntity.getDynamicObject("changelettervalid");
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (!operationStatus.equals((Object)OperationStatus.EDIT)) {
            this.initChangeView(this.getView(), change.getLong("id"), "tso_changelettervalidtab", KEY_CHANGETABPAGEAP);
        } else {
            this.openEditForm();
        }
        this.initView(this.getView(), offer.getLong("id"), "tso_somk_offerbase", KEY_OFFERTABPAGEAP);
        this.showLetterForm(offerLetter.getLong("id"), offer.getLong("id"));
    }

    private void initView(IFormView view, Long pkId, String formId, String targetKey) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId((Object)pkId);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        view.showForm((FormShowParameter)showParameter);
    }

    private void initChangeView(IFormView view, Long pkId, String formId, String targetKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("id", (Object)pkId);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
    }

    private void showLetterForm(long letterId, long offerId) {
        FormShowParameter letterParameter = new FormShowParameter();
        letterParameter.setFormId("tso_offerletter_preview");
        letterParameter.getOpenStyle().setTargetKey(KEY_LETTERTABPAGEAP);
        letterParameter.getOpenStyle().setShowType(ShowType.InContainer);
        letterParameter.setCustomParam("letterid", (Object)letterId);
        letterParameter.setCustomParam("offerid", (Object)offerId);
        String sendLetterContent = this.getModel().getDataEntity().getString("sendlettercontent_tag");
        if (HRStringUtils.isEmpty((String)sendLetterContent)) {
            DynamicObject letterDy = OfferLetterServiceHelper.getInstance().queryOne((Object)letterId);
            letterParameter.setCustomParam("content", (Object)letterDy.getString("sendlettercontent_tag"));
        } else {
            letterParameter.setCustomParam("content", (Object)sendLetterContent);
        }
        this.getView().showForm(letterParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("cancel")) {
            MutexHelper.release((IFormView)this.getView());
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String ops = String.join((CharSequence)",", "revoke", "save", "submit");
        if (ops.contains(afterDoOperationEventArgs.getOperateKey()) && operationResult.isSuccess()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
            DynamicObject letterBillObj = this.getModel().getDataEntity(true);
            long offerId = letterBillObj.getLong("offer.id");
            OfferEditMutexHelper.releaseMutexIfIsCurrentUser((Long)offerId);
        } else if ("modify".equals(afterDoOperationEventArgs.getOperateKey()) && operationResult.isSuccess()) {
            this.openEditForm();
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(KEY_CONFIRM_CALL_BACK)) {
            MessageBoxResult result2 = messageBoxClosedEvent.getResult();
            if (result2 == MessageBoxResult.Yes) {
                DynamicObject dbBill = ChangeLetterBillHelper.getInstance().loadSingle((Object)this.getModel().getDataEntity(true).getLong("id"));
                OperationResult ltrOptResult = changeLetterBillHelper.submitChangeLetterBill(null, dbBill, false, true);
                this.setNotification(ltrOptResult);
            }
        } else if (callBackId.equals(KEY_CONFIRM_CALL_EDIT_BACK)) {
            MessageBoxResult result3 = messageBoxClosedEvent.getResult();
            if (result3 == MessageBoxResult.Yes) {
                DynamicObject dbBill = ChangeLetterBillHelper.getInstance().loadSingle((Object)this.getModel().getDataEntity(true).getLong("id"));
                String ltrChgPageKey = this.getView().getPageCache().get("CACHE_KEY_OFFERLTRCHAGE_PAGEKEY");
                IFormView ltrChgView = this.getView().getView(ltrChgPageKey);
                if (this.checkField(ltrChgView, true)) {
                    return;
                }
                OperationResult ltrOptResult = changeLetterBillHelper.submitChangeLetterBill(ltrChgView, dbBill, true, true);
                this.setNotification(ltrOptResult);
            }
        } else if ("deleteBillConfirm".equals(callBackId) && (result = messageBoxClosedEvent.getResult()) == MessageBoxResult.Yes) {
            String entityId = "";
            entityId = this.getView().getFormShowParameter() instanceof ListShowParameter ? ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId() : this.getView().getFormShowParameter().getFormId();
            if (!PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)"tsrsc", (String)entityId, (String)"4715e1f1000000ac")) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_formmeta");
                DynamicObject dynamicObject = helper.queryOne(new QFilter("number", "=", (Object)entityId).toArray());
                String format = MessageFormat.format(OfferDeleteMultiLangConstants.noPermError(), dynamicObject.getString("name"));
                this.getView().showErrorNotification(format);
                return;
            }
            billDeleteService.deleteBill(this.getModel().getDataEntity(true));
            this.getView().returnDataToParent((Object)OfferDeleteMultiLangConstants.deleteSuccess());
            this.getView().close();
        }
    }

    public void setNotification(OperationResult ltrOptResult) {
        if (!ltrOptResult.isSuccess()) {
            List validateErrors = ltrOptResult.getValidateResult().getValidateErrors();
            List operateErrorInfos = ((ValidateResult)validateErrors.get(0)).getAllErrorInfo();
            List messages = operateErrorInfos.stream().map(OperateInfo::getMessage).collect(Collectors.toList());
            this.getView().showTipNotification(String.join((CharSequence)"", messages));
        } else {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    static {
        CLICK_ACTION.put("bar_delete", ChangeLetterBillEdit::doDeleteBill);
    }
}

