/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.letter.change;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicListBasePlugin;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterValidHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class ChangeLetterRecordDynPlugin
extends HRDynamicListBasePlugin {
    private static final String LAB_DETAIL = "detail";
    private static final Log LOGGER = LogFactory.getLog(ChangeLetterRecordDynPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LAB_DETAIL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (HRStringUtils.equals((String)control.getKey(), (String)LAB_DETAIL)) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object primaryKeyValue = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject dynamicObject = ChangeLetterValidHelper.getInstance().queryOne(primaryKeyValue);
            if (dynamicObject.getBoolean("isdelete")) {
                this.getView().invokeOperation("refresh");
                this.getView().getParentView().showTipNotification(OfferDeleteMultiLangConstants.noLetterChangeBill());
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
            int letterAudit = dynamicObject.getInt("letteraudit");
            BaseShowParameter formShowParameter = null;
            if (letterAudit == 1) {
                String name = dynamicObject.getDynamicObject("offerletter").getDynamicObject("appfile").getString("name");
                formShowParameter = this.showChangeLetterBillParameter(primaryKeyValue, name);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "actionBillInfo");
                formShowParameter.setCloseCallBack(closeCallBack);
            } else if (letterAudit == 2) {
                formShowParameter = this.showChangeLetterValidParameter(dynamicObject.getPkValue());
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private BillShowParameter showChangeLetterBillParameter(Object primaryKeyValue, String name) {
        QFilter filter = new QFilter("changelettervalid", "=", primaryKeyValue);
        DynamicObject changeLetterBill = ChangeLetterBillHelper.getInstance().queryOne(filter.toArray());
        BillShowParameter billShowParameter = FormShowHelper.createBillShowParameter((String)"tso_changeletterbill", null, (ShowType)ShowType.MainNewTabPage, null);
        billShowParameter.setPkId(changeLetterBill.get("id"));
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setCaption(ResManager.loadKDString((String)MessageFormat.format("Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355{0}\u3002", name), (String)"ChangeLetterRecordDynPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        return billShowParameter;
    }

    private BaseShowParameter showChangeLetterValidParameter(Object primaryKeyValue) {
        BaseShowParameter baseShowParameter = FormShowHelper.createBaseFormShowParameter((String)"tso_changelettervalid", null, (ShowType)ShowType.Modal, null);
        baseShowParameter.setPkId(primaryKeyValue);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        return baseShowParameter;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("ChangeLetterRecordDynPlugin customParams:{}", (Object)customParams);
        if (!customParams.isEmpty()) {
            Object offerId = customParams.get("offer");
            BillList billList = (BillList)this.getControl("billlistap");
            QFilter filter = new QFilter("offerletter.offer", "=", offerId).and("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setFilter(filter);
            filterParameter.setOrderBy("createtime desc");
            billList.setFilterParameter(filterParameter);
            billList.addPackageDataListener(packageDataEvent -> {
                Date date;
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
                String fieldKey = columnDesc.getFieldKey();
                if (HRStringUtils.equals((String)fieldKey, (String)"newlastreplytime") && (date = packageDataEvent.getRowData().getDate("newlastreplytime")) == null) {
                    packageDataEvent.setFormatValue((Object)"-");
                }
            });
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"actionBillInfo")) {
            this.getView().invokeOperation("refresh");
            Optional.ofNullable(closedCallBackEvent.getReturnData()).ifPresent(msg -> this.getView().getParentView().showSuccessNotification(msg.toString()));
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

