/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.letter.change;

import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.operate.EntityOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.moka.offer.validator.OfferSecondValidatorFactory;
import kd.tsc.tso.business.domain.moka.offer.validator.SecondValidatorInterface;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class ChangeOfferLetterEdit
extends HRCoreBaseBillEdit {
    private static final Log log = LogFactory.getLog(ChangeOfferLetterEdit.class);
    public static final String[] UN_CHANGED_PROPS = new String[]{"sendtime", "validtime", "lastreplytime", "offerletter", "creator", "letteraudit"};

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"submit"});
    }

    public void beforeBindData(EventObject eventObject) {
        Object sendTime;
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkId = ((BillShowParameter)formShowParameter).getPkId();
        if (!Objects.isNull(pkId)) {
            return;
        }
        Object letterId = formShowParameter.getCustomParams().get("letterId");
        this.getModel().setValue("offerletter", letterId);
        DynamicObject letterObj = OfferLetterServiceHelper.getInstance().queryOne(letterId);
        long letterStatus = letterObj.getLong("letterstatus.id");
        if (OfferLetterStatus.PRE_GENERATE.getCode() == letterStatus) {
            this.getModel().setValue("newvalidtime", (Object)letterObj.getDate("validtime"));
            QFilter qFilter = new QFilter("offer", "=", (Object)letterObj.getLong("offer.id")).and("datastatus", "=", (Object)OfferLetterDataStatus.INVALID.getCode()).and("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
            String queryProperties = "sendtime,validtime";
            letterObj = OfferLetterServiceHelper.getInstance().queryOne(queryProperties, qFilter.toArray(), "modifytime desc");
            this.getModel().setValue("isregeneratletter", (Object)1);
            this.getModel().setValue("noregenerateletterid", letterId);
        }
        if (!Objects.isNull(sendTime = letterObj.get("sendtime"))) {
            this.getModel().setValue("sendtime", letterObj.get("sendtime"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sendtime"});
        }
        this.getModel().setValue("validtime", letterObj.get("validtime"));
        DateTimeEdit dateValid = (DateTimeEdit)this.getView().getControl("newvalidtime");
        Date date = this.getModel().getDataEntity(true).getDate("validtime");
        Date validTime = DateUtils.getMaxWithCurSysDate((Date)date);
        dateValid.setMinDate(DateUtils.editDate((Date)DateUtils.convertDate2UserDate((Date)HRDateTimeUtils.getNextDay((Date)validTime)), (int)0, (int)0, (int)0));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object secondValidatorClass = formShowParameter.getCustomParam("secondValidatorClass");
        SecondValidatorInterface secondValidatorInterface = OfferSecondValidatorFactory.getSecondValidatorInterface((String)(secondValidatorClass + ""));
        if (secondValidatorInterface != null) {
            EntityOperate entityOperate = (EntityOperate)args.getSource();
            secondValidatorInterface.doValidator(this.getView(), args, entityOperate.getOperateKey());
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date validateTime = this.getModel().getDataEntity(true).getDate("newvalidtime");
        dataEntity.set("newvalidtime", (Object)DateUtils.addTimeForDate((Date)validateTime));
        int letterAudit = OfferParamConfigService.getInstance().getOfferLetterApprovalConfig();
        log.info("offer audit config : {}", (Object)letterAudit);
        dataEntity.set("letteraudit", (Object)letterAudit);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean success = operationResult.isSuccess();
        if (success) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            this.getView().getPageCache().put("letteraudit", dataEntity.getString("letteraudit"));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent closedEvent) {
        super.beforeClosed(closedEvent);
        closedEvent.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String unChangedProp : UN_CHANGED_PROPS) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unChangedProp);
            if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        this.getModel().updateCache();
        String returnData = this.getView().getPageCache().get("letteraudit");
        if (!Objects.isNull(returnData)) {
            this.getView().returnDataToParent(dataEntity.get("letteraudit"));
        } else {
            this.getView().returnDataToParent((Object)"");
        }
    }
}

