/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.login;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.login.OfferCodeLoginService;
import kd.tsc.tso.common.dto.login.OfferCodeLoginDto;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;

public class OfferCodeLoginPlugin
extends AbstractOfferDynamicFramePlugin {
    private final OfferCodeLoginService codeLoginService = OfferCodeLoginService.Singleton.INSTANCE.getInstance();
    private final OfferLetterServiceHelper offerLetterServiceHelper = OfferLetterServiceHelper.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_login"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button loginButton = (Button)evt.getSource();
        if (!loginButton.getKey().equals("btn_login")) {
            return;
        }
        OfferCodeLoginDto codeLoginDto = this.getCodeLoginDto();
        try {
            DynamicObject offerLetter = this.offerLetterServiceHelper.loadSingle((Object)codeLoginDto.getOfferLetterId());
            boolean hasValidDay = this.checkValidDay(offerLetter);
            if (!hasValidDay) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                this.codeLoginService.checkLimitCondition(codeLoginDto.getCachedKeySuffix());
                this.codeLoginService.checkCode(codeLoginDto);
                this.openOfferLetterForm();
            }
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private boolean checkValidDay(DynamicObject offerLetter) {
        Date validtime = offerLetter.getDate("validtime");
        long validDay = OfferLetterServiceHelper.getInstance().checkValidDay(validtime);
        return validDay >= 0L;
    }

    private OfferCodeLoginDto getCodeLoginDto() {
        String phone = (String)this.getCustomParam(RequestParam.PHONE.key);
        long offerId = (Long)this.getCustomParam(RequestParam.OFFER_ID.key);
        long offerLetterId = (Long)this.getCustomParam(RequestParam.OFFER_LETTER_ID.key);
        OfferCodeLoginDto codeLoginDto = OfferCodeLoginDto.build().setPhone((String)this.getCustomParam(RequestParam.PHONE.key)).setOfferId(Long.valueOf(offerId)).setOfferLetterId(Long.valueOf(offerLetterId)).setCachedKeySuffix(offerLetterId + "_" + phone).setVerifyCode(this.getModel().getDataEntity(true).getString("login_code"));
        return codeLoginDto;
    }

    private void openOfferLetterForm() {
        Long offerLetterId = (Long)this.getCustomParam(RequestParam.OFFER_LETTER_ID.key);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tso_offerletterbill");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("letterid", (Object)offerLetterId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "offerLetterBillClose"));
        formShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("offerLetterBillClose".equals(closedCallBackEvent.getActionId())) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public static enum RequestParam {
        KEY("key"),
        OFFER_ID("offerid"),
        OFFER_LETTER_ID("letterid"),
        TYPE("type"),
        PHONE("candidatephone");

        private final String key;

        private RequestParam(String key) {
            this.key = key;
        }
    }
}

