/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.login;

import java.util.Map;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tso.business.domain.offer.service.login.OfferLoginMainService;
import kd.tsc.tso.common.constants.offer.login.OfferLoginTypeConstants;
import kd.tsc.tso.common.enums.offer.login.OfferLoginMainParamEnum;
import kd.tsc.tso.common.exception.OfferInvalidException;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;

public class OfferLoginMainPlugin
extends AbstractOfferDynamicFramePlugin {
    private static final Log log = LogFactory.getLog(OfferLoginMainService.class);
    private static final String KEY_MODEL_FLEXPANELAP = "model_flexpanelap";
    private Map<String, Object> paramMap;
    private final OfferLoginMainService loginMainService = OfferLoginMainService.Singleton.INSTANCE.getInstance();

    public void createNewData(BizDataEventArgs e) {
        try {
            this.paramMap = this.getCustomParams();
            this.loginMainService.checkDataValid(this.paramMap);
            this.switchPage();
        }
        catch (OfferInvalidException ex) {
            this.showPage("tso_offerinvalidinfo");
            log.error((Throwable)ex);
        }
    }

    public void switchPage() {
        int type = Integer.parseInt(this.getCustomParams().get(OfferLoginMainParamEnum.TYPE.key).toString());
        switch (OfferLoginTypeConstants.LoginTypeEnum.getLoginType((Integer)type)) {
            case SMS_LOGIN: {
                this.showPage("tso_offersmslogin");
                break;
            }
            case PASS_LOGIN: {
                this.showPage("tso_offercodelogin");
                break;
            }
            default: {
                this.showPage("tso_offerinvalidinfo");
            }
        }
    }

    private void showPage(String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParams(this.paramMap);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_MODEL_FLEXPANELAP);
        this.getView().showForm(showParameter);
    }
}

