/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.login;

import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.service.login.OfferSmsLoginService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.dto.login.OfferSmsLoginDto;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;

public class OfferSmsLoginPlugin
extends AbstractOfferDynamicFramePlugin {
    private static final OfferSmsLoginService smsLoginService = OfferSmsLoginService.Singleton.INSTANCE.getInstance();
    private static final OfferLetterServiceHelper offerLetterServiceHelper = OfferLetterServiceHelper.getInstance();
    private static final SecureRandom RANDOM = new SecureRandom();

    private void login() {
        DynamicObject dynamicObject = this.getView().getModel().getDataEntity(true);
        OfferSmsLoginDto smsLoginDto = OfferSmsLoginPlugin.getSmsLoginDto(this.getView());
        try {
            DynamicObject offerLetter = offerLetterServiceHelper.loadSingle((Object)smsLoginDto.getOfferLetterId());
            boolean hasValidDay = OfferSmsLoginPlugin.checkValidDay(offerLetter);
            if (!hasValidDay) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                smsLoginService.checkLoginCondition(dynamicObject, smsLoginDto);
                this.openOfferLetterForm(smsLoginDto.getOfferLetterId());
            }
        }
        catch (IllegalStateException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        catch (KDBizException e) {
            OfferSmsLoginPlugin.getVerifyCode(this.getView());
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private static boolean checkValidDay(DynamicObject offerLetter) {
        Date validtime = offerLetter.getDate("validtime");
        long validDay = OfferLetterServiceHelper.getInstance().checkValidDay(validtime);
        return validDay >= 0L;
    }

    private void sendSms() {
        DynamicObject dynamicObject = this.getView().getModel().getDataEntity(true);
        CustomControl smsControl = (CustomControl)this.getView().getControl("send_sms_lap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)8);
        dataMap.put("isSuccess", Boolean.TRUE);
        dataMap.put("randomNum", System.currentTimeMillis() + (long)RANDOM.nextInt());
        OfferSmsLoginDto smsLoginDto = OfferSmsLoginPlugin.getSmsLoginDto(this.getView());
        try {
            smsLoginService.checkSendSmsCondition(dynamicObject, smsLoginDto);
            smsControl.setData((Object)dataMap);
            this.getView().showSuccessNotification(OfferMultilingualConstants.sendSmsSuccess());
        }
        catch (IllegalStateException e) {
            dataMap.put("isSuccess", Boolean.FALSE);
            smsControl.setData((Object)dataMap);
            this.getView().showTipNotification(e.getMessage());
        }
        catch (KDBizException e) {
            dataMap.put("isSuccess", Boolean.FALSE);
            smsControl.setData((Object)dataMap);
            OfferSmsLoginPlugin.getVerifyCode(this.getView());
            this.getView().showTipNotification(e.getMessage());
        }
        catch (Exception e) {
            dataMap.put("isSuccess", Boolean.FALSE);
            smsControl.setData((Object)dataMap);
            this.getView().showTipNotification("system error");
        }
    }

    public static OfferSmsLoginDto getSmsLoginDto(IFormView formView) {
        String offerPhone = (String)OfferSmsLoginPlugin.getCustomParam(Param.PHONE.key, formView);
        Long offerId = (Long)OfferSmsLoginPlugin.getCustomParam(Param.OFFER_ID.key, formView);
        Long offerLetterId = (Long)OfferSmsLoginPlugin.getCustomParam(Param.OFFER_LETTER_ID.key, formView);
        OfferSmsLoginDto smsLoginDto = OfferSmsLoginDto.build().setSmsCode(formView.getModel().getDataEntity(true).getString("phone_code")).setPhone((String)OfferSmsLoginPlugin.getCustomParam(Param.PHONE.key, formView)).setCachedKeySuffix(offerLetterId + "_" + offerPhone).setOfferId(offerId).setOfferLetterId(offerLetterId).setPhone(offerPhone).setAuthCodeCache(formView.getPageCache().get("OFFER_VERIFY_AUTH_CODE:"));
        return smsLoginDto;
    }

    private void openOfferLetterForm(long offerLetterId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tso_offerletterbill");
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("letterid", (Object)offerLetterId);
        formShowParameter.setShowFullScreen(true);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "offerLetterBillClose"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("offerLetterBillClose".equals(closedCallBackEvent.getActionId())) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void customEvent(CustomEventArgs ex) {
        if ("sendSms".equals(ex.getEventName())) {
            this.sendSms();
        } else if ("loginOffer".equals(ex.getEventName())) {
            this.login();
        }
    }

    public static enum Param {
        KEY("key"),
        OFFER_ID("offerid"),
        OFFER_LETTER_ID("letterid"),
        TYPE("type"),
        PHONE("candidatephone");

        private final String key;

        private Param(String key) {
            this.key = key;
        }
    }
}

