/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.login;

import java.text.MessageFormat;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.tsc.tso.business.domain.offer.service.login.OfferRejectService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;

public class RejectConfirmPlugin
extends AbstractOfferDynamicFramePlugin {
    private final OfferRejectService rejectService = OfferRejectService.Singleton.INSTANCE.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Button)evt.getSource()).getKey();
        if (!"btn_confirm".equals(optKey)) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        DynamicObject letterObj = this.rejectService.doRejectOffer(parentView);
        this.closeParentPage();
        this.refreshRootPage(letterObj);
    }

    private void refreshRootPage(DynamicObject letterObj) {
        DynamicObject companyObj = letterObj.getDynamicObject("offer.pecompany");
        String companyName = "";
        if (companyObj != null) {
            companyName = companyObj.getString("name");
        }
        String msg = MessageFormat.format(OfferMultilingualConstants.rejectOfferSuccess(), companyName);
        IFormView letterView = this.getView().getParentView().getParentView();
        letterView.showSuccessNotification(msg);
        letterView.invokeOperation("refresh");
        this.getView().sendFormAction(letterView);
    }

    private void closeParentPage() {
        this.getView().getParentView().invokeOperation("close");
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void afterCreateNewData(EventObject e) {
        Label label = (Label)this.getControl("tip_message");
        label.setText(OfferMultilingualConstants.rejectConfirm());
    }
}

