/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.login;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import kd.tsc.tso.common.util.FormShowHelper;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;

public class RejectOfferPlugin
extends AbstractOfferDynamicFramePlugin
implements BeforeF7SelectListener {
    private final OfferLetterServiceHelper letterServiceHelper = OfferLetterServiceHelper.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
        BasedataEdit rejectReasonEdit = (BasedataEdit)this.getControl("rejectreason");
        rejectReasonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        this.checkParam();
    }

    private void checkParam() {
        try {
            this.getCustomParam("letterid");
        }
        catch (NullPointerException ex) {
            IFormView parentView = this.getView().getParentView();
            parentView.showTipNotification(OfferMultilingualConstants.offerLetterIdNotNull());
            this.getView().sendFormAction(parentView);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object optSource = evt.getSource();
        if (optSource instanceof Button && "btn_ok".equals(((Button)optSource).getKey())) {
            this.showConfirmPage();
        }
    }

    private void showConfirmPage() {
        FormShowParameter formShowParameter = FormShowHelper.createFormShowParameter((String)"tso_offerrejctconfirm", null, (ShowType)ShowType.Floating, null);
        this.getView().showForm(formShowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"rejectreason")) {
            DynamicObject letterObj = this.letterServiceHelper.loadSingle(this.getCustomParam("letterid"));
            String recrutyp = "offer.recrutyp";
            DynamicObject recruitType = letterObj.getDynamicObject(recrutyp);
            QFilter qFilter = new QFilter("recrutyp.fbasedataid", "=", (Object)recruitType.getLong("id"));
            qFilter.or(new QFilter("recrutyp.fbasedataid", "=", null));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }
}

