/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sdk.tsc.tso.extpoint.OfferListService;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferQFilterHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferStatusHelper;
import kd.tsc.tso.business.domain.offer.service.OfferListLimitService;
import kd.tsc.tso.business.domain.offer.service.OfferReasonShowService;
import kd.tsc.tso.common.enums.TPSysEnum;
import kd.tsc.tso.common.util.OfferShowParamUtils;
import kd.tsc.tso.common.util.OfferUtils;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.enums.DeleteEnum;
import org.apache.commons.lang3.tuple.Pair;

public class MokaOfferInfoBillList
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(MokaOfferInfoBillList.class);
    private static final String CACHE_KEY_CURRENT_PAGE_DATA = "curPageData";
    private Map<String, Object> myPageCache;

    public void setView(IFormView formView) {
        super.setView(formView);
        this.myPageCache = Maps.newHashMapWithExpectedSize((int)4);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "offerletter.letterstatus.number": {
                args.addCustomQFilter(OfferQFilterHelper.getOfferLetterStatusFilter());
                args.setOrderBy("index");
                break;
            }
            case "offerletter.replystatus.number": {
                args.addCustomQFilter(OfferQFilterHelper.getOfferReplyStatusFilter());
                break;
            }
            case "offerletter.datastatus.number": {
                args.addCustomQFilter(OfferQFilterHelper.getOfferLetterDataStatusFilter());
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        this.handleDataRangeFilterMine(setFilterEvent);
        QFilter sourceQFilter = new QFilter("tpsys", "!=", (Object)TPSysEnum.KD.getCode());
        sourceQFilter.and(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new OfferListLimitService(), OfferListService.class, (String)"kd.sdk.tsc.tso.extpoint.OfferListService#getPermFilter", null);
        proxy.callReplaceIfPresent(service -> {
            QFilter permFilter;
            if (service != null && (permFilter = service.getPermFilter(setFilterEvent)) != null) {
                logger.info("setFilter permFilter: {}", (Object)permFilter);
                sourceQFilter.and(permFilter);
            }
            return null;
        });
        setFilterEvent.getQFilters().add(sourceQFilter);
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("modifytime desc");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String fieldName;
        super.filterContainerBeforeF7Select(beforeFilterF7SelectEvent);
        switch (fieldName = beforeFilterF7SelectEvent.getFieldName()) {
            case "pecompany.number": {
                QFilter peCompanyFilter = OfferQFilterHelper.getPeCompanyFilter();
                beforeFilterF7SelectEvent.setQfilters(Collections.singletonList(peCompanyFilter));
                break;
            }
            case "offerletter.replystatus.number": {
                QFilter replyStatusFilter = OfferQFilterHelper.getOfferReplyStatusFilter();
                beforeFilterF7SelectEvent.setQfilters(Collections.singletonList(replyStatusFilter));
                break;
            }
            case "offerletter.letterstatus.number": {
                QFilter letterStatusFilter = OfferQFilterHelper.getOfferLetterStatusFilter();
                beforeFilterF7SelectEvent.setQfilters(Collections.singletonList(letterStatusFilter));
                break;
            }
            case "offerletter.datastatus.number": {
                beforeFilterF7SelectEvent.addCustomQFilter(OfferQFilterHelper.getOfferLetterDataStatusFilter());
                break;
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        if (eventObject.getSource() instanceof BillList) {
            BillList billList = (BillList)eventObject.getSource();
            DynamicObject[] dynamicObjects = (DynamicObject[])this.myPageCache.get(CACHE_KEY_CURRENT_PAGE_DATA);
            IListView view = (IListView)this.getView();
            List cellStyleListOfStatus = OfferStatusHelper.getCellStyleListOfStatus((IListView)view, (DynamicObject[])dynamicObjects);
            billList.setCellStyle(cellStyleListOfStatus);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        ((IListColumn)listColumns.get(0)).setFixed(true);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)"lastedreason", (String)fieldKey)) {
            this.setLastedReasonDesc(packageDataEvent);
        } else if (HRStringUtils.equals((String)"workage", (String)fieldKey)) {
            this.setWorkAge(packageDataEvent);
        }
    }

    private void setWorkAge(PackageDataEvent packageDataEvent) {
        DynamicObject current = this.getCurrentDtFromOthPropertyCache(packageDataEvent.getRowData());
        if (Objects.isNull(current)) {
            return;
        }
        int workAge = current.getInt("candidateworkage");
        if (!HRObjectUtils.isEmpty((Object)workAge)) {
            String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workAge);
            packageDataEvent.setFormatValue((Object)workYearShow);
        }
    }

    public void beforePackageData(BeforePackageDataEvent beforePackageDataEvent) {
        super.beforePackageData(beforePackageDataEvent);
        DynamicObjectCollection pageDatas = beforePackageDataEvent.getPageData();
        ArrayList offerIdList = new ArrayList(pageDatas.size());
        pageDatas.parallelStream().forEach(data -> offerIdList.add(data.getLong("id")));
        String selectProperties = OfferUtils.getSelectProperties((String[])new String[]{"status", "offerletter", "offerabandondesc", "launchinderrdesc", "breakupreasontext", "inductionstatus", "candidateworkage"});
        DynamicObject[] offersWithDeliver = OfferServiceHelper.getInstance().queryOfferByIdList(offerIdList, selectProperties);
        this.myPageCache.put(CACHE_KEY_CURRENT_PAGE_DATA, offersWithDeliver);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"offerInfoPageClose")) {
            Optional.ofNullable(closedCallBackEvent.getReturnData()).ifPresent(msg -> this.getView().showSuccessNotification(msg.toString()));
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        super.beforeShowBill(evt);
        evt.getParameter().setStatus(OperationStatus.VIEW);
        evt.getParameter().setBillStatus(BillOperationStatus.VIEW);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperLinkClickArgs) {
        super.billListHyperLinkClick(hyperLinkClickArgs);
        Long offerPk = this.getCurrentRowPk();
        switch (hyperLinkClickArgs.getFieldName()) {
            case "offerauditno": {
                hyperLinkClickArgs.setCancel(true);
                this.showOfferBillPage(offerPk);
                break;
            }
            case "letterauditno": {
                hyperLinkClickArgs.setCancel(true);
                this.showChangeLetterBillPage(offerPk);
                break;
            }
        }
    }

    private Long getCurrentRowPk() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow listSelectedRow = listView.getCurrentSelectedRowInfo();
        return (Long)listSelectedRow.getPrimaryKeyValue();
    }

    private void showOfferBillPage(Long offerId) {
        DynamicObject offerById = OfferServiceHelper.getInstance().getOfferById(offerId);
        String auditNo = offerById.getString("offerauditno");
        DynamicObject offerBillDt = OfferBillServiceHelper.getInstance().queryOneByAuditNo(auditNo, "id");
        if (HRObjectUtils.isEmpty((Object)offerBillDt)) {
            return;
        }
        FormShowParameter offerBillParam = OfferShowParamUtils.getOfferBillParam((Long)offerBillDt.getLong("id"), (String)this.getView().getPageId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "offerInfoPageClose");
        offerBillParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(offerBillParam);
    }

    private void showChangeLetterBillPage(Long offerId) {
        DynamicObject offerById = OfferServiceHelper.getInstance().getOfferById(offerId);
        String auditNo = offerById.getString("letterauditno");
        DynamicObject dynamicObject = ChangeLetterBillHelper.getInstance().queryOneByAuditNo(auditNo);
        String name = dynamicObject.getDynamicObject("offerletter").getDynamicObject("appfile").getString("name");
        FormShowParameter offerBillParam = OfferShowParamUtils.getChangeLetterBillParam((Long)dynamicObject.getLong("id"), (String)this.getView().getPageId());
        offerBillParam.setCaption(ResManager.loadKDString((String)MessageFormat.format("Offer Letter\u6709\u6548\u671f\u53d8\u66f4\u7533\u8bf7\u5355{0}\u3002", name), (String)"ChangeLetterRecordDynPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "offerInfoPageClose");
        offerBillParam.setCloseCallBack(closeCallBack);
        offerBillParam.setStatus(OperationStatus.VIEW);
        this.getView().showForm(offerBillParam);
    }

    private void setLastedReasonDesc(PackageDataEvent packageDataEvent) {
        String inductionStatus;
        DynamicObject letter;
        DynamicObject current = this.getCurrentDtFromOthPropertyCache(packageDataEvent.getRowData());
        if (Objects.isNull(current)) {
            return;
        }
        Pair pair = OfferReasonShowService.getShowReason((DynamicObject)current, (boolean)true);
        List showReasons = (List)pair.getLeft();
        if (showReasons.isEmpty()) {
            return;
        }
        logger.info("showReasons: {}", (Object)showReasons);
        String reason = (String)showReasons.get(0);
        String value = "";
        if (OfferUtils.checkHasProperty((DynamicObject)current, (String)reason)) {
            value = current.getString(reason);
        }
        if (!HRObjectUtils.isEmpty((Object)(letter = current.getDynamicObject("offerletter"))) && OfferUtils.checkHasProperty((DynamicObject)letter, (String)reason)) {
            Object reasonObj = letter.get(reason);
            logger.info("reasonObj: {}", reasonObj);
            value = reasonObj instanceof DynamicObject ? letter.getString(reason + ".name") : letter.getString(reason);
        }
        if (HRStringUtils.isNotEmpty((String)(inductionStatus = current.getString("inductionstatus"))) && HRStringUtils.equals((String)"3", (String)inductionStatus)) {
            value = current.getString("breakupreasontext");
        }
        packageDataEvent.setFormatValue((Object)value);
    }

    private DynamicObject getCurrentDtFromOthPropertyCache(DynamicObject dynamicObject) {
        Object offerCache = this.myPageCache.get(CACHE_KEY_CURRENT_PAGE_DATA);
        if (Objects.isNull(offerCache)) {
            return null;
        }
        if (!(offerCache instanceof DynamicObject[])) {
            return null;
        }
        Long currentRowId = dynamicObject.getLong("id");
        DynamicObject[] dynamicObjects = (DynamicObject[])offerCache;
        Optional<DynamicObject> optional = Arrays.stream(dynamicObjects).filter(offer -> currentRowId.equals(offer.getLong("id"))).findFirst();
        return optional.orElse(null);
    }

    private void handleDataRangeFilterMine(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        for (int i = 0; i < setFilterEvent.getQFilters().size(); ++i) {
            String val;
            String property = ((QFilter)qFilters.get(i)).getProperty();
            if (!HRStringUtils.equals((String)property, (String)"datarange") || !HRStringUtils.equals((String)"0", (String)(val = (String)((QFilter)qFilters.get(i)).getValue()))) continue;
            qFilters.set(i, OfferQFilterHelper.mineCreateOfferFilter());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && HRStringUtils.equals((String)parentView.getFormShowParameter().getFormId(), (String)"tso_somk_offerlist")) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }
}

