/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.advice;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tso.business.domain.offer.helper.OfferAdviceBizHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.service.advice.impl.DefaultOfferSendServiceImpl;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSendMultiLangConstants;
import kd.tsc.tso.common.util.OfferShowParamUtils;
import kd.tsc.tso.formplugin.web.offer.moka.advice.service.OfferAdviceInfoPluginService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgFormService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferFieldsHelper;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;

public class OfferAdviceInfoPlugin
extends HRDynamicFormBasePlugin {
    private static final Log log = LogFactory.getLog(OfferAdviceInfoPlugin.class);
    private static Set<String> set = new HashSet<String>(8);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = e.getFormShowParameter();
        Long offerId = (Long)showParameter.getCustomParam("offerid");
        StringBuilder stringBuilder = new StringBuilder();
        boolean requireMutex = OfferEditMutexHelper.requireMutex((Long)offerId, (StringBuilder)stringBuilder);
        if (!requireMutex) {
            e.setCancel(true);
            e.setCancelMessage(stringBuilder.toString());
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long offerId = (Long)showParameter.getCustomParam("offerid");
        if (OperationStatus.VIEW.equals((Object)showParameter.getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_send"});
            OfferEditMutexHelper.releaseMutex((Long)offerId);
        }
        FormShowParameter offerHeadInfoParam = OfferShowParamUtils.getOfferHeadInfoParam((Long)offerId, (OperationStatus)OperationStatus.VIEW, (String)"tso_offerhead_notice");
        offerHeadInfoParam.setSendToClient(true);
        this.getView().showForm(offerHeadInfoParam);
        this.getPageCache().put("cache_offer_head_page", offerHeadInfoParam.getPageId());
        HashMap<String, Long> paramMap = new HashMap<String, Long>(1);
        paramMap.put("offerid", offerId);
        FormShowParameter parameter = OfferAdviceBizHelper.getInContainerForm((String)"tso_somk_offernotice", (String)"noticeentitypanel", paramMap);
        parameter.setStatus(this.getView().getFormShowParameter().getStatus());
        parameter.setSendToClient(true);
        this.getView().showForm(parameter);
        this.getPageCache().put("cache_offer_notice_pageId", parameter.getPageId());
        String sendType = this.getPageCache().get("sendtype");
        if (HRStringUtils.isEmpty((String)sendType)) {
            this.getPageCache().put("sendtype", OfferParamConfigService.getInstance().getOfferLetterSendType());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        args.getSource();
        String operateKey = operate.getOperateKey();
        if ("send".equals(operateKey)) {
            OperateOption formOperate = ((FormOperate)args.getSource()).getOption();
            try {
                if (!this.judgePageFieldTip().booleanValue()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.verifyMessageTemplateContent()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.verifyRcPersonOpenMessageTemplateContent()) {
                    args.setCancel(true);
                    return;
                }
                if (!HRStringUtils.equals((String)this.getPageCache().get("confirmSkip"), (String)"1") && !this.verifyOfferLetter()) {
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.isEmpty((String)formOperate.getVariableValue("agreeTab", "")) && !this.verifyCode()) {
                    args.setCancel(true);
                    return;
                }
                if (this.verifyLastReplyTime()) {
                    args.setCancel(true);
                    return;
                }
            }
            catch (Exception ex) {
                log.error("verifySendOffer error :", (Throwable)ex);
                args.setCancel(true);
                return;
            }
            this.invokeHandle(operate, formOperate, args);
        }
    }

    private boolean verifyLastReplyTime() {
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        Date lastReplyDate = (Date)noticePageView.getModel().getValue("lastreplytime");
        if (HRDateTimeUtils.getNowDateTime().getTime() > lastReplyDate.getTime()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u5df2\u8d85\u8fc7Offer\u6700\u665a\u56de\u590d\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u6700\u665a\u56de\u590d\u65e5\u671f\u540e\u518d\u53d1\u9001\u3002", (String)"OfferAdviceInfoPlugin_15", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void invokeHandle(AbstractOperate operate, OperateOption formOperate, BeforeDoOperationEventArgs args) {
        this.getPageCache().remove("confirmSkip");
        OperateOption operateOption = this.getOperateOption();
        operateOption.setVariableValue("operateName", operate.getOperateName().getLocaleValue());
        operateOption.setVariableValue("sendtype", this.getPageCache().get("sendtype"));
        this.setMsgNoticeOperateOption(operateOption);
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        String verifycode = this.getPageCache().get("verifycode");
        operateOption.setVariableValue("verifycode", verifycode);
        OperationResult operationResult = noticePageView.invokeOperation("donothing", operateOption);
        if (!operationResult.isSuccess()) {
            String message = OfferAdviceBizHelper.getOperateResultMessage((OperationResult)operationResult);
            this.getView().showErrorNotification(message);
            formOperate.removeVariable("agreeTab");
            args.setCancel(true);
        } else {
            this.tipNullEmail();
        }
    }

    private boolean verifyCode() {
        String content = this.getView().getPageCache().get("content");
        String keyStr = ResManager.loadKDString((String)"{\u56fa\u5b9a\u5bc6\u7801}", (String)"OfferAdviceInfoPlugin_10", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        String mainMsg = ResManager.loadKDString((String)"\u6d88\u606f\u901a\u77e5\u4e2d\u672a\u5305\u542b\u201c\u56fa\u5b9a\u5bc6\u7801\u201d\uff0c\u786e\u8ba4\u53d1\u9001\u5417\uff1f", (String)"OfferAdviceInfoPlugin_11", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        String assistMsg = ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u8fd4\u56de\u9875\u9762\u63d2\u5165\u53d8\u91cf\u201c\u56fa\u5b9a\u5bc6\u7801\u201d\uff0c\u6216\u901a\u8fc7\u5176\u4ed6\u65b9\u5f0f\u5c06\u201c\u56fa\u5b9a\u5bc6\u7801\u201d\u544a\u77e5\u5019\u9009\u4eba\u3002", (String)"OfferAdviceInfoPlugin_12", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener listener = new ConfirmCallBackListener("OFFER_CONFIRM_FLAG", (IFormPlugin)this);
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        String sendType = OfferParamConfigService.getInstance().getOfferLetterSendType();
        String loginType = OfferParamConfigService.getInstance().getLoginType();
        if (("2".equals(sendType) || "1".equals(sendType) && "1".equals(loginType) || "1".equals(sendType) && "2".equals(loginType) && Boolean.parseBoolean(noticePageView.getModel().getValue("isepannex").toString())) && !HRStringUtils.isEmpty((String)content) && !content.contains(keyStr)) {
            this.getView().showConfirm(mainMsg, assistMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, listener);
            return false;
        }
        return true;
    }

    private boolean verifyOfferLetter() {
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        DynamicObject noticeDy = noticePageView.getModel().getDataEntity(true);
        Long offerId = (Long)this.getView().getFormShowParameter().getCustomParam("offerid");
        Map<String, String> emptyValueFiledMap = OfferAdviceInfoPluginService.getInstance().verifyOfferLetter(noticeDy, offerId);
        if (emptyValueFiledMap.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String value : emptyValueFiledMap.values()) {
                stringBuilder.append(value);
                stringBuilder.append("\u3001");
            }
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("\u3001"));
            String message = ResManager.loadKDString((String)"Offer Letter%s\u53d8\u91cf\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u786e\u8ba4\u53d1\u9001\u5417\uff1f", (String)"OfferAdviceInfoPlugin_6", (String)"tsc-tso-formplugin", (Object[])new Object[]{stringBuilder.toString()});
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("verifyOfferLetter", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private void setMsgNoticeOperateOption(OperateOption operateOption) {
        List bccUsers;
        DynamicObjectCollection bccUserCollection;
        List mkUsers;
        DynamicObjectCollection mkUserCollection;
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        DynamicObject noticeDy = noticePageView.getModel().getDataEntity(true);
        if (noticeDy.getBoolean("candidatenoticeopen")) {
            IFormView msgPageView = this.getFormView("cache_msg_tpl_page_id");
            DynamicObject msgDy = msgPageView.getModel().getDataEntity(true);
            mkUserCollection = msgDy.getDynamicObjectCollection("mkuser");
            if (!mkUserCollection.isEmpty()) {
                mkUsers = mkUserCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                operateOption.setVariableValue("candidatenoticecr", SerializationUtils.toJsonString(mkUsers));
            }
            if (!(bccUserCollection = msgDy.getDynamicObjectCollection("bccuser")).isEmpty()) {
                bccUsers = bccUserCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                operateOption.setVariableValue("candidatenoticesr", SerializationUtils.toJsonString(bccUsers));
            }
        }
        if (noticeDy.getBoolean("rcpersonopen")) {
            IFormView contactPersonView = this.getFormView("CACHE_REPORT_CONTACT_PERSON_MSG_PAGE_ID");
            DynamicObject contactPersonMsgDy = contactPersonView.getModel().getDataEntity(true);
            mkUserCollection = contactPersonMsgDy.getDynamicObjectCollection("mkuser");
            if (!mkUserCollection.isEmpty()) {
                mkUsers = mkUserCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                operateOption.setVariableValue("rcpersonopencr", SerializationUtils.toJsonString(mkUsers));
            }
            if (!(bccUserCollection = contactPersonMsgDy.getDynamicObjectCollection("bccuser")).isEmpty()) {
                bccUsers = bccUserCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                operateOption.setVariableValue("rcpersonopensr", SerializationUtils.toJsonString(bccUsers));
            }
        }
    }

    private void tipNullEmail() {
        List<String> candidateMsgEmail = this.checkCandidateMsgEmail();
        List<String> rcPersonMsgEmail = this.checkRcPersonMsgEmail();
        candidateMsgEmail.addAll(rcPersonMsgEmail);
        if (!candidateMsgEmail.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u6284\u9001\u4eba/\u5bc6\u9001\u4eba\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\u3002", (String)"OfferAdviceInfoPlugin_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            FormShowParameter bosOperationResultParam = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)title, candidateMsgEmail, (boolean)false);
            this.getView().showForm(bosOperationResultParam);
        }
    }

    private List<String> checkRcPersonMsgEmail() {
        ArrayList<String> notEmailName = new ArrayList<String>(8);
        IFormView msgPageView = this.getFormView("CACHE_REPORT_CONTACT_PERSON_MSG_PAGE_ID");
        DynamicObject msgDy = msgPageView.getModel().getDataEntity(true);
        DynamicObjectCollection mkUserCollection = msgDy.getDynamicObjectCollection("mkuser");
        String messageSuffix = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u90ae\u7bb1\u4fe1\u606f\u3002", (String)"OfferAdviceInfoPlugin_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        List nameCrList = mkUserCollection.stream().filter(dynamicObject -> StringUtils.isEmpty((String)dynamicObject.getDynamicObject("fbasedataid").getString("email"))).map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("name") + "\uff1a" + messageSuffix).collect(Collectors.toList());
        Optional.ofNullable(nameCrList).ifPresent(notEmailName::addAll);
        DynamicObjectCollection bccUserCollection = msgDy.getDynamicObjectCollection("bccuser");
        List emailSrList = bccUserCollection.stream().filter(dynamicObject -> StringUtils.isEmpty((String)dynamicObject.getDynamicObject("fbasedataid").getString("email"))).map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("name") + "\uff1a" + messageSuffix).collect(Collectors.toList());
        Optional.ofNullable(emailSrList).ifPresent(notEmailName::addAll);
        log.info("OfferAdviceInfoPlugin.checkRcPersonMsgEmail notEmailName : {}", notEmailName);
        return notEmailName;
    }

    private List<String> checkCandidateMsgEmail() {
        ArrayList<String> notEmailName = new ArrayList<String>(8);
        IFormView msgPageView = this.getFormView("cache_msg_tpl_page_id");
        DynamicObject msgDy = msgPageView.getModel().getDataEntity(true);
        String messageSuffix = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u90ae\u7bb1\u4fe1\u606f\u3002", (String)"OfferAdviceInfoPlugin_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection mkUserCollection = msgDy.getDynamicObjectCollection("mkuser");
        List nameCrList = mkUserCollection.stream().filter(dynamicObject -> StringUtils.isEmpty((String)dynamicObject.getDynamicObject("fbasedataid").getString("email"))).map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("name") + "\uff1a" + messageSuffix).collect(Collectors.toList());
        Optional.ofNullable(nameCrList).ifPresent(notEmailName::addAll);
        DynamicObjectCollection bccUserCollection = msgDy.getDynamicObjectCollection("bccuser");
        List emailSrList = bccUserCollection.stream().filter(dynamicObject -> StringUtils.isEmpty((String)dynamicObject.getDynamicObject("fbasedataid").getString("email"))).map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("name") + "\uff1a" + messageSuffix).collect(Collectors.toList());
        Optional.ofNullable(emailSrList).ifPresent(notEmailName::addAll);
        log.info("OfferAdviceInfoPlugin.checkCandidateMsgEmail notEmailName : {}", notEmailName);
        return notEmailName;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String headPageId = this.getPageCache().get("cache_offer_head_page");
        IFormView headPageView = OfferAdviceBizHelper.getFormViewByCacheKey((String)headPageId);
        headPageView.invokeOperation("updateview");
        this.getView().sendFormAction(headPageView);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        this.getPageCache().put("CLOSE_OFFER_NOTICE_VIEW_FLAG", "1");
        this.getView().updateView();
        this.getView().showSuccessNotification(OfferSendMultiLangConstants.sendOfferSuccess());
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setCheckDataChange(false);
        String flag = this.getPageCache().get("CLOSE_OFFER_NOTICE_VIEW_FLAG");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long offerId = (Long)showParameter.getCustomParam("offerid");
        if ("1".equals(flag)) {
            OfferEditMutexHelper.releaseMutex((Long)offerId);
            return;
        }
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        IFormView msgPageView = this.getFormView("cache_msg_tpl_page_id");
        boolean dataChange = this.hasDataChange(noticePageView, msgPageView);
        if (dataChange) {
            OfferEditMutexHelper.releaseMutex((Long)offerId);
            return;
        }
        event.setCancel(true);
        String message = ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u76f4\u63a5\u9000\u51fa\u5c06\u4e22\u5931\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"OfferAdviceInfoPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_OFFER_NOTICE_VIEW_FLAG", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"CLOSE_OFFER_NOTICE_VIEW_FLAG") && (result = event.getResult()) == MessageBoxResult.Yes) {
            this.getPageCache().put("CLOSE_OFFER_NOTICE_VIEW_FLAG", "1");
            this.getView().close();
        }
        if ("OFFER_CONFIRM_FLAG".equals(event.getCallBackId())) {
            result = event.getResult();
            OperateOption operateOption = OperateOption.create();
            if (result == MessageBoxResult.Yes) {
                operateOption.setVariableValue("agreeTab", "1");
                this.getView().invokeOperation("send", operateOption);
            } else {
                this.getPageCache().remove("confirmSkip");
                operateOption.removeVariable("agreeTab");
            }
        }
        if (HRStringUtils.equals((String)callBackId, (String)"verifyOfferLetter")) {
            result = event.getResult();
            if (result == MessageBoxResult.Yes) {
                this.getPageCache().put("confirmSkip", "1");
                this.getView().invokeOperation("send");
            } else {
                this.getPageCache().remove("confirmSkip");
            }
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (!status.equals((Object)OperationStatus.VIEW)) {
            Long offerId = (Long)showParameter.getCustomParam("offerid");
            OfferEditMutexHelper.releaseMutex((Long)offerId);
        }
    }

    private Boolean judgePageFieldTip() {
        ArrayList<IFormView> msgViews = new ArrayList<IFormView>();
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        DynamicObject noticeDy = noticePageView.getModel().getDataEntity(true);
        IFormView msgPageView = null;
        if (noticePageView.getModel().getDataEntity().getBoolean("candidatenoticeopen") && null != (msgPageView = this.getFormView("cache_msg_tpl_page_id"))) {
            msgViews.add(msgPageView);
        }
        IFormView contactPersonView = null;
        if (noticePageView.getModel().getDataEntity().getBoolean("rcpersonopen") && null != (contactPersonView = this.getFormView("CACHE_REPORT_CONTACT_PERSON_MSG_PAGE_ID"))) {
            msgViews.add(contactPersonView);
        }
        DefaultOfferSendServiceImpl offerSendService = new DefaultOfferSendServiceImpl();
        List msgList = offerSendService.validateShowFormMessage(noticeDy);
        msgList = offerSendService.validateShowFormMessage(msgList, msgViews);
        String showFormMessage = Joiner.on((String)"\u3002").skipNulls().join((Iterable)msgList);
        if (HRStringUtils.isNotEmpty((String)showFormMessage)) {
            if (showFormMessage.contains("\u3002\u3002")) {
                showFormMessage = showFormMessage.replace("\u3002\u3002", "\u3002");
            }
            this.getView().showTipNotification(showFormMessage);
        }
        return msgList.isEmpty();
    }

    private boolean verifyMessageTemplateContent() {
        Map msgFieldMap;
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        DynamicObject noticeDy = noticePageView.getModel().getDataEntity(true);
        if (!noticePageView.getModel().getDataEntity().getBoolean("candidatenoticeopen")) {
            return true;
        }
        IFormView msgPageView = this.getFormView("cache_msg_tpl_page_id");
        return this.verifyMessage(true, msgPageView, noticeDy, msgFieldMap = OfferAdviceBizHelper.getMsgFieldByScene());
    }

    private boolean verifyMessage(boolean isCheckSms, IFormView msgPageView, DynamicObject noticeDy, Map<String, String> msgFieldMap) {
        if (null == msgPageView) {
            return false;
        }
        String msgChannelList = msgPageView.getModel().getDataEntity().getString("msgchannellist");
        DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgChannels((List)CfgMsgFormService.getChannelListId((String)msgChannelList));
        JSONObject pageJson = JSONObject.parseObject((String)msgPageView.getPageCache().get("CHANNEL_PAGE_JSON"));
        DynamicObjectCollection entryEntity = msgPageView.getModel().getDataEntity().getDynamicObjectCollection("msgtemplate.entryentity");
        String content = this.getView().getPageCache().get("content");
        for (DynamicObject channel : dynamicObjects) {
            IFormView tabView = msgPageView.getView(pageJson.getString(channel.getString("id")));
            tabView.getModel().updateCache();
            String richText = "";
            String smsContent = "";
            if (null == tabView.getPageCache().get("category")) {
                for (DynamicObject entry : entryEntity) {
                    if (channel.getLong("id") != entry.getLong("channelid")) continue;
                    richText = entry.getString("emailtempcontext");
                    smsContent = entry.getString("smstempcontext");
                    break;
                }
                if (HRStringUtils.isEmpty((String)richText) && "email".equals(channel.getString("category"))) {
                    DynamicObject msgTemplate = msgPageView.getModel().getDataEntity().getDynamicObject("msgtemplate");
                    richText = CfgMsgTemplateHelper.queryMsgTemplateEmail((Long)msgTemplate.getLong("id"));
                }
                if (HRStringUtils.isEmpty((String)smsContent) && "shortMsg".equals(channel.getString("category"))) {
                    smsContent = msgPageView.getModel().getDataEntity().getString("msgtemplate.smstemplate");
                }
            } else if ("email".equals(channel.getString("category"))) {
                richText = String.valueOf(tabView.getModel().getValue("richcontent_tag"));
            } else {
                smsContent = null == tabView.getModel().getValue("smstemplate") ? null : tabView.getModel().getValue("smstemplate").toString();
            }
            content = content + richText + smsContent;
            if (this.emailContentVerify(noticeDy, richText, msgFieldMap)) {
                return false;
            }
            if (!isCheckSms || !this.smsContentVerify(noticeDy, smsContent, msgFieldMap)) continue;
            return false;
        }
        this.getView().getPageCache().put("content", content);
        return true;
    }

    private boolean verifyRcPersonOpenMessageTemplateContent() {
        Map msgFieldMap;
        IFormView noticePageView = this.getFormView("cache_offer_notice_pageId");
        DynamicObject noticeDy = noticePageView.getModel().getDataEntity(true);
        if (!noticePageView.getModel().getDataEntity().getBoolean("rcpersonopen")) {
            return true;
        }
        IFormView rcPersonMsgPageView = this.getFormView("CACHE_REPORT_CONTACT_PERSON_MSG_PAGE_ID");
        return this.verifyMessage(false, rcPersonMsgPageView, noticeDy, msgFieldMap = OfferAdviceBizHelper.getReportPersonMsgFieldByScene());
    }

    private boolean emailContentVerify(DynamicObject noticeDy, String richText, Map<String, String> msgFieldMap) {
        log.info("OfferAdviceInfoPlugin.emailContentVerify.msgFieldMap -> {}", (Object)JSONObject.toJSONString(msgFieldMap));
        if (HRStringUtils.isNotEmpty((String)richText)) {
            StringBuilder msg = new StringBuilder();
            List<String> validatorFiled = this.getValidatorFiled(richText, msgFieldMap);
            log.info("OfferAdviceInfoPlugin.emailContentVerify.validatorFiled -> {}", (Object)JSONObject.toJSONString(validatorFiled));
            DynamicObject contact = noticeDy.getDynamicObject("contact");
            if (validatorFiled.contains("contact") && Objects.isNull(contact)) {
                msg.append(msgFieldMap.get("contact"));
                msg.append('\u3001');
            }
            String contactPhone = noticeDy.getString("contactphone");
            if (validatorFiled.contains("contactphone") && HRStringUtils.isEmpty((String)contactPhone)) {
                msg.append(msgFieldMap.get("contactphone"));
                msg.append('\u3001');
            }
            String reportAddress = noticeDy.getString("reportaddress");
            if (validatorFiled.contains("reportaddress") && HRStringUtils.isEmpty((String)reportAddress)) {
                msg.append(msgFieldMap.get("reportaddress"));
                msg.append('\u3001');
            }
            String contactemail = noticeDy.getString("contactemail");
            if (validatorFiled.contains("contactemail") && HRStringUtils.isEmpty((String)contactemail)) {
                msg.append(msgFieldMap.get("contactemail"));
                msg.append('\u3001');
            }
            if (HRStringUtils.isNotEmpty((String)msg.toString())) {
                msg = msg.deleteCharAt(msg.length() - 1);
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u901a\u77e5\u5185\u5bb9\u4e2d\u5f15\u7528\u7684{0}\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u901a\u77e5\u4fe1\u606f\u4e2d\u5f55\u5165\u6216\u53bb\u6389\u53d8\u91cf\u3002", (String)"OfferAdviceInfoPlugin_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]), msg.toString()));
                return true;
            }
        }
        return false;
    }

    private boolean smsContentVerify(DynamicObject noticeDy, String smsContent, Map<String, String> msgFieldMap) {
        StringBuilder msg = new StringBuilder();
        if (HRStringUtils.isEmpty((String)smsContent)) {
            return false;
        }
        int loginType = noticeDy.getInt("logintype");
        boolean isepannex = noticeDy.getBoolean("isepannex");
        List<String> verifyCode = this.getValidatorFiled(smsContent, msgFieldMap);
        boolean candidateNoticeOpen = noticeDy.getBoolean("candidatenoticeopen");
        if (loginType == 2 && candidateNoticeOpen && !isepannex && verifyCode.contains("verifycode")) {
            msg.append(this.getWarningTips("1"));
        }
        if (HRStringUtils.isNotEmpty((String)msg.toString())) {
            this.getView().showTipNotification(msg.toString());
            return true;
        }
        DynamicObject contact = noticeDy.getDynamicObject("contact");
        if (verifyCode.contains("contact") && Objects.isNull(contact)) {
            msg.append(msgFieldMap.get("contact"));
            msg.append('\u3001');
        }
        String reportAddress = noticeDy.getString("reportaddress");
        if (verifyCode.contains("reportaddress") && HRStringUtils.isEmpty((String)reportAddress)) {
            msg.append(msgFieldMap.get("reportaddress"));
            msg.append('\u3001');
        }
        if (HRStringUtils.isNotEmpty((String)msg.toString())) {
            msg = msg.deleteCharAt(msg.length() - 1);
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u901a\u77e5\u5185\u5bb9\u4e2d\u5f15\u7528\u7684{0}\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u901a\u77e5\u4fe1\u606f\u4e2d\u5f55\u5165\u6216\u53bb\u6389\u53d8\u91cf\u3002", (String)"OfferAdviceInfoPlugin_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]), msg.toString()));
            return true;
        }
        return false;
    }

    private String getWarningTips(String type) {
        if (HRStringUtils.equals((String)type, (String)"1")) {
            return ResManager.loadKDString((String)"\u8bf7\u5220\u9664\u53d8\u91cf\u201c\u56fa\u5b9a\u5bc6\u7801\u201d\u3002\u539f\u56e0\uff1a\u767b\u5f55\u65b9\u5f0f\u4e3a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e14Offer Letter\u9644\u4ef6\u672a\u52a0\u5bc6\u3002", (String)"OfferAdviceInfoPlugin_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private List<String> getValidatorFiled(String content, Map<String, String> msgFieldMap) {
        List templateFields = OfferFieldsHelper.getTemplateFields((String)content);
        ArrayList<String> validatorFiled = new ArrayList<String>(templateFields.size());
        block0: for (String text : templateFields) {
            for (Map.Entry<String, String> msgField : msgFieldMap.entrySet()) {
                if (!HRStringUtils.equals((String)msgField.getValue(), (String)text) || !set.contains(msgField.getKey())) continue;
                validatorFiled.add(msgField.getKey());
                continue block0;
            }
        }
        return validatorFiled;
    }

    private IFormView getFormView(String pageKey) {
        String msgPageId = this.getView().getPageCache().get(pageKey);
        return OfferAdviceBizHelper.getFormViewByCacheKey((String)msgPageId);
    }

    private OperateOption getOperateOption() {
        OperateOption operateOption = OperateOption.create();
        String template = this.getView().getPageCache().get("cache_template_content");
        operateOption.setVariableValue("templatecontent_tag", template);
        Long offerId = (Long)this.getView().getFormShowParameter().getCustomParam("offerid");
        operateOption.setVariableValue("offerid", String.valueOf(offerId));
        return operateOption;
    }

    private boolean hasDataChange(IFormView ... formView) {
        try {
            Set views = Arrays.stream(formView).filter(ifv -> ifv.getModel().getDataChanged()).collect(Collectors.toSet());
            return views.isEmpty();
        }
        catch (Exception e) {
            log.error("view had closed", (Throwable)e);
            return true;
        }
    }

    static {
        set.add("contact");
        set.add("contactphone");
        set.add("placework");
        set.add("verifycode");
        set.add("reportaddress");
        set.add("contactemail");
    }
}

