/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.advice;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tso.business.domain.offer.helper.OfferAdviceBizHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.advice.OfferTemplate;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.formplugin.web.offer.moka.advice.OfferAdvicePlugin;
import kd.tsc.tspr.business.domain.rpc.impl.HsbsRpcServiceImpl;
import kd.tsc.tspr.common.dto.request.hsbs.QuerySalaryAmountReqDTO;
import kd.tsc.tspr.common.dto.response.CommonRespDTO;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.fieldscm.CfgMsgFieldSchemeService;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.utils.TerracePhoneFormChangeUtil;

public class OfferAdviceLoadMsgPlugin
extends HRDynamicFormBasePlugin {
    private static final Log log = LogFactory.getLog(OfferAdvicePlugin.class);
    private static final String PUSH_OFFER_NOTICE_SCENE_ID = "1080";
    private static final String MSG_CONTACT_PERSON_RECEIVER_TYPE = "1011";

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long offerId = (Long)parameter.getCustomParam("offerid");
        DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(offerId);
        DynamicObject letter = OfferLetterServiceHelper.getInstance().queryOne((Object)offer.getDynamicObject("offerletter").getLong("id"));
        this.loadMsgPage(offer, letter);
        this.loadContactPersonMsgPage(offer, letter);
    }

    private void loadContactPersonMsgPage(DynamicObject offer, DynamicObject letter) {
        Map customParam = OfferTemplate.assembleSendMessageTemplate((DynamicObject)offer);
        customParam.put("offerid", offer.getLong("id"));
        customParam.put("msgReceiverType", MSG_CONTACT_PERSON_RECEIVER_TYPE);
        this.addOfferLetterInfo(customParam, letter, letter.getDynamicObjectCollection("rcpersonopencr").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList()), letter.getDynamicObjectCollection("rcpersonopensr").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList()));
        this.addOfferInfo(customParam, offer);
        this.handleCustomParam(customParam);
        customParam.put("msgSceneType", PUSH_OFFER_NOTICE_SCENE_ID);
        FormShowParameter parameterForm = OfferAdviceBizHelper.getInContainerForm((String)"tsrsc_cfgmsgintegrate", (String)"rcpersonopenflex", (Map)customParam);
        parameterForm.setStatus(this.getView().getFormShowParameter().getStatus());
        parameterForm.setSendToClient(true);
        this.getView().showForm(parameterForm);
        IPageCache cache = this.getView().getParentView().getPageCache();
        OfferAdviceBizHelper.putParentCache((IPageCache)cache, (String)"CACHE_REPORT_CONTACT_PERSON_MSG_PAGE_ID", (String)parameterForm.getPageId());
    }

    private void loadMsgPage(DynamicObject offer, DynamicObject letter) {
        Map customParam = OfferTemplate.assembleSendMessageTemplate((DynamicObject)offer);
        customParam.put("offerid", offer.getLong("id"));
        customParam.put("msgReceiverType", CfgMsgRecvType.CANDIDATE.getBaseDataId());
        String sendType = OfferParamConfigService.getInstance().getOfferLetterSendType();
        customParam.put("sendtype", sendType);
        if (HRStringUtils.equals((String)"2", (String)sendType)) {
            customParam.put("offerattachobjid", letter.getString("id"));
        }
        customParam.put("msgSceneType", PUSH_OFFER_NOTICE_SCENE_ID);
        this.addOfferLetterInfo(customParam, letter, letter.getDynamicObjectCollection("candidatenoticecr").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList()), letter.getDynamicObjectCollection("candidatenoticesr").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList()));
        this.addOfferInfo(customParam, offer);
        this.handleCustomParam(customParam);
        this.offerLetterHandle(offer);
        FormShowParameter parameter = OfferAdviceBizHelper.getInContainerForm((String)"tsrsc_cfgmsgintegrate", (String)"candidatenoticeflex", (Map)customParam);
        parameter.setStatus(this.getView().getFormShowParameter().getStatus());
        parameter.setSendToClient(true);
        this.getView().showForm(parameter);
        IPageCache cache = this.getView().getParentView().getPageCache();
        OfferAdviceBizHelper.putParentCache((IPageCache)cache, (String)"cache_msg_tpl_page_id", (String)parameter.getPageId());
    }

    private void handleCustomParam(Map<String, Object> customParam) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date lastReplyTime = dataEntity.getDate("lastreplytime");
        String formatDate = "";
        if (Objects.nonNull(lastReplyTime)) {
            formatDate = HRInteDateTimeUtil.formatDate((String)"tso_offerletter", (String)"lastreplytime", (Date)lastReplyTime);
        }
        customParam.put("lastreplytime", formatDate);
        customParam.put("contactphone", dataEntity.get("contactphone"));
        DynamicObject contact = dataEntity.getDynamicObject("contact");
        String contactName = Optional.ofNullable(contact).map(dy -> dy.getString("name")).orElse("");
        customParam.put("contact", contactName);
        customParam.put("verifycode", dataEntity.getString("verifycode"));
        DynamicObject address = dataEntity.getDynamicObject("reportaddress");
        String addressName = Optional.ofNullable(address).map(dy -> dy.getString("name")).orElse("");
        customParam.put("reportaddress", addressName);
        customParam.put("contactemail", dataEntity.getString("contactemail"));
    }

    private void addOfferInfo(Map<String, Object> customParam, DynamicObject offer) {
        DynamicObject applicant = offer.getDynamicObject("applicant");
        if (HRObjectUtils.isEmpty((Object)applicant)) {
            customParam.put("offercontact", "");
            customParam.put("offercontactphone", "");
        } else {
            customParam.put("offercontact", applicant.getString("name"));
            customParam.put("offercontactphone", TerracePhoneFormChangeUtil.getFormChangePhone((String)applicant.getString("phone")));
        }
        customParam.put("sendofferdate", HRInteDateTimeUtil.formatDate((String)"tso_offerletter", (String)"sendtime", (Date)new Date()));
        Date pemploymenttime = offer.getDate("pemploymenttime");
        if (pemploymenttime != null) {
            customParam.put("pemploymenttime", HRInteDateTimeUtil.formatDate((String)offer.getDataEntityType().getName(), (String)"pemploymenttime", (Date)pemploymenttime));
        }
    }

    private void addOfferLetterInfo(Map<String, Object> customParam, DynamicObject letter, List<Long> crCollection, List<Long> srCollection) {
        Date date = letter.getDate("lastreplytime");
        customParam.put("lastreplytime", date == null ? "" : HRInteDateTimeUtil.formatDate((String)"tso_offerletter", (String)"lastreplytime", (Date)date));
        DynamicObject reportAddress = letter.getDynamicObject("reportaddress");
        customParam.put("reportaddress", reportAddress == null ? "" : reportAddress.getString("name"));
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject contact = dataEntity.getDynamicObject("contact");
        customParam.put("contact", contact == null ? "" : contact.getString("name"));
        String contactPhone = dataEntity.getString("contactphone");
        customParam.put("contactphone", contactPhone == null ? "" : contactPhone);
        customParam.put("verifycode", dataEntity.getString("verifycode"));
        customParam.put("contactemail", dataEntity.getString("contactemail"));
        customParam.put("mkuser", crCollection);
        customParam.put("bccuser", srCollection);
        customParam.put("letterstatus", OfferLetterStatus.PRE_SEND.getCode().longValue() == letter.getDynamicObject("letterstatus").getLong("id"));
    }

    private void offerLetterHandle(DynamicObject offer) {
        String salaryType = offer.getString("salarytype");
        if ("1".equals(salaryType)) {
            return;
        }
        IAppCache iAppCache = AppCache.get((String)"tsrbd_offertempreview");
        HsbsRpcServiceImpl service = new HsbsRpcServiceImpl();
        QuerySalaryAmountReqDTO dto = new QuerySalaryAmountReqDTO();
        dto.setOfferCode(offer.getString("number"));
        dto.setOfferId(Long.valueOf(offer.getLong("id")));
        dto.setFormId("tso_somk_offerbaseinfo");
        dto.setSalaryIdList(CfgMsgFieldSchemeService.getInstance().getMsgTempFields("salary"));
        CommonRespDTO respDTO = service.querySalaryAmount(dto);
        log.info("OfferAdvicePlugin.offerLetterHandle.result");
        List resultValList = (List)respDTO.getResult();
        resultValList.forEach(val -> iAppCache.put(String.valueOf(val.getSalaryStdItemId()), (Object)val.getCurrency()));
    }
}

