/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tso.business.domain.offer.helper.OfferAdviceBizHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferAttachmentHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferContHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSendMultiLangConstants;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbd.common.utils.TerracePhoneFormChangeUtil;
import kd.tsc.tsrbs.business.domain.common.service.ControlledDataCommonHelper;

public class OfferAdvicePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(OfferAdvicePlugin.class);
    private IAppCache iAppCache;
    private static final String PAGE_CACHE_CUSTOMPARAM = "customParam";
    private static final String OFFERLETTER_ATTACHMENTKEY = "attachmentpanel_offerletter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label preview = (Label)this.getControl("previewtemplate");
        preview.addClickListener((ClickListener)this);
        BasedataEdit template = (BasedataEdit)this.getView().getControl("template");
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"showverifycode", "hideverifycode"});
        this.addClickListeners(new String[]{"candidatenoticeon", "candidatenoticeup", "rcpersonon", "rcpersonup"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String sendType;
        String propertyName = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("contact".equals(propertyName)) {
            DynamicObject contact = dataEntity.getDynamicObject("contact");
            if (Objects.nonNull(contact)) {
                String phone = TerracePhoneFormChangeUtil.getFormChangePhone((String)contact.getString("phone"));
                this.getModel().setValue("contactphone", (Object)phone);
                this.getModel().setValue("contactemail", (Object)contact.getString("email"));
            } else {
                this.getModel().setValue("contactphone", null);
                this.getModel().setValue("contactemail", null);
            }
        }
        if ("isgtannex".equalsIgnoreCase(propertyName)) {
            if (!dataEntity.getBoolean("isgtannex")) {
                this.getModel().setValue("isepannex", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"isepannex"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"isepannex"});
            }
        }
        if ("isepannex".equalsIgnoreCase(propertyName)) {
            if (dataEntity.getBoolean("isepannex")) {
                dataEntity.set("verifycode", (Object)this.getDesensitizeVerifyCode());
                this.getView().setVisible(Boolean.TRUE, new String[]{"verifycode"});
            } else {
                String loginType = dataEntity.getString("logintype");
                if ("2".equals(loginType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"verifycode"});
                    dataEntity.set("verifycode", (Object)"");
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"verifycode"});
                    dataEntity.set("verifycode", (Object)this.getDesensitizeVerifyCode());
                }
            }
        }
        if ("2".equals(sendType = OfferParamConfigService.getInstance().getOfferLetterSendType()) && "template".equals(propertyName)) {
            DynamicObject template = this.getModel().getDataEntity(true).getDynamicObject("template");
            IAppCache appCache = AppCache.get((String)"offerattach");
            if (HRObjectUtils.isEmpty((Object)template)) {
                appCache.put(dataEntity.getString("letterid"), null);
                OfferAttachmentHelper.getInstance().deleteOldDataIfExist((Long)this.getModel().getValue("letterid"));
            } else {
                log.info("OfferAdvicePlugin.propertyChanged.sendOfferAdvice begin");
                OfferAdviceBizHelper.mokaSendOfferAdvice((DynamicObject)dataEntity, (String)this.getVerifyCode());
                List attachments = AttachmentServiceHelper.getAttachments((String)"tso_offerletter", (Object)dataEntity.getLong("letterid"), (String)OFFERLETTER_ATTACHMENTKEY);
                appCache.put(dataEntity.getString("letterid"), (Object)attachments);
                log.info("OfferAdvicePlugin attachments info: {}", (Object)attachments);
            }
        }
        this.showOrHidenMsg(this.getModel().getDataEntity());
        IFormView msgFormView = this.getCandidateMsgFormView();
        OfferAdviceBizHelper.cacheMsgFormShowParameter((IFormView)msgFormView, (DynamicObject)dataEntity);
        IFormView reportContactPersonMsgFormView = this.getReportContactPersonMsgFormView();
        OfferAdviceBizHelper.cacheMsgFormShowParameter((IFormView)reportContactPersonMsgFormView, (DynamicObject)dataEntity);
        log.info("OfferAdvicePlugin.propertyChanged iAppCache {}", (Object)this.iAppCache);
        if ("lastreplytime".equals(propertyName) || "reportaddress".equals(propertyName)) {
            OfferAdviceBizHelper.mokaSendOfferAdvice((DynamicObject)dataEntity, (String)this.getVerifyCode());
        }
    }

    private void showOrHidenMsg(DynamicObject dynamicObject) {
        boolean candidatenoticeopen = dynamicObject.getBoolean("candidatenoticeopen");
        if (candidatenoticeopen) {
            this.getModel().setValue("candidatenoticeopen", (Object)"1");
            this.getView().setVisible(Boolean.TRUE, new String[]{"candidatenoticeflex", "candidatenoticeupflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"candidatenoticeonflex"});
        } else {
            this.getModel().setValue("candidatenoticeopen", (Object)"0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"candidatenoticeflex", "candidatenoticeupflex", "candidatenoticeonflex"});
        }
        boolean rcpersonopen = dynamicObject.getBoolean("rcpersonopen");
        if (rcpersonopen) {
            this.getModel().setValue("rcpersonopen", (Object)"1");
            this.getView().setVisible(Boolean.TRUE, new String[]{"rcpersonopenflex", "rcpersonupflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"rcpersononflex"});
        } else {
            this.getModel().setValue("rcpersonopen", (Object)"0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"rcpersonopenflex", "rcpersonupflex", "rcpersononflex"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("previewtemplate".equals(key)) {
            DynamicObject offer = this.getModel().getDataEntity(true);
            DynamicObject template = offer.getDynamicObject("template");
            if (null != template) {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Long offerId = (Long)parameter.getCustomParam("offerid");
                this.previewOfferTemplate(offerId, template);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9Offer Letter\u6a21\u677f\u3002", (String)"OfferBasicInfoEdit_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            }
        } else if ("showverifycode".equals(key)) {
            this.getModel().getDataEntity().set("verifycode", (Object)this.getDesensitizeVerifyCode());
            this.getView().setVisible(Boolean.FALSE, new String[]{"showverifycode"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"hideverifycode"});
            this.getView().updateView("verifycode");
        } else if ("hideverifycode".equals(key)) {
            this.getModel().getDataEntity().set("verifycode", (Object)this.getVerifyCode());
            this.getView().setVisible(Boolean.FALSE, new String[]{"hideverifycode"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showverifycode"});
            this.getView().updateView("verifycode");
        }
        this.clickMsgExpandOrRetract(key);
    }

    private void clickMsgExpandOrRetract(String key) {
        List<String> keyList = Arrays.asList("candidatenoticeon", "candidatenoticeup", "rcpersonon", "rcpersonup");
        if (!keyList.contains(key)) {
            return;
        }
        switch (key) {
            case "candidatenoticeon": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"candidatenoticeonflex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"candidatenoticeupflex", "candidatenoticeflex"});
                break;
            }
            case "candidatenoticeup": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"candidatenoticeonflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"candidatenoticeupflex", "candidatenoticeflex"});
                break;
            }
            case "rcpersonon": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rcpersononflex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"rcpersonupflex", "rcpersonopenflex"});
                break;
            }
            case "rcpersonup": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"rcpersononflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"rcpersonupflex", "rcpersonopenflex"});
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sendType = this.getView().getParentView() == null ? OfferParamConfigService.getInstance().getOfferLetterSendType() : this.getView().getParentView().getPageCache().get("sendtype");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (HRStringUtils.equals((String)"2", (String)sendType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"logintype"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"isgtannex", "isepannex"});
            if (Objects.nonNull(this.getModel().getValue("template"))) {
                Long offerId = (Long)parameter.getCustomParam("offerid");
                DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(offerId);
                DynamicObject letter = OfferLetterServiceHelper.getInstance().queryOne((Object)offer.getDynamicObject("offerletter").getLong("id"));
                OfferAdviceBizHelper.mokaSendOfferAdvice((DynamicObject)dataEntity, (String)this.getVerifyCode());
                List attachments = AttachmentServiceHelper.getAttachments((String)"tso_offerletter", (Object)letter.getLong("id"), (String)OFFERLETTER_ATTACHMENTKEY);
                log.info("OfferAdvicePlugin.afterBindData.letter.letterId:{}, attachments\uff1a{}", (Object)letter.getString("id"), (Object)attachments);
                IAppCache appCache = AppCache.get((String)"offerattach");
                appCache.put(letter.getString("id"), (Object)attachments);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long offerId = (Long)parameter.getCustomParam("offerid");
        DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(offerId);
        DynamicObject letter = OfferLetterServiceHelper.getInstance().queryOne((Object)offer.getDynamicObject("offerletter").getLong("id"));
        IPageCache cache = this.getView().getParentView().getPageCache();
        this.getModel().setValue("isepannex", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"showverifycode"});
        String verifyCode = OfferAdviceBizHelper.addVerifyCode((DynamicObject)letter);
        OfferAdviceBizHelper.putParentCache((IPageCache)cache, (String)"verifycode", (String)verifyCode);
        letter.set("verifycode", (Object)this.getDesensitizeVerifyCode());
        this.setLastReplyTimeRange(offer);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        HRDynamicObjectUtils.copy((DynamicObject)offer, (DynamicObject)dataEntity);
        HRDynamicObjectUtils.copy((DynamicObject)letter, (DynamicObject)dataEntity);
        DynamicObject connect = OfferContHelper.getConnect((Long)letter.getLong("id"));
        Optional.ofNullable(connect).ifPresent(conn -> HRDynamicObjectUtils.copy((DynamicObject)connect, (DynamicObject)dataEntity));
        if (this.getView().getParentView() != null && HRStringUtils.isEmpty((String)this.getView().getParentView().getPageCache().get("loginType"))) {
            this.getView().getParentView().getPageCache().put("loginType", OfferParamConfigService.getInstance().getLoginType());
        }
        String loginType = this.getView().getParentView() == null ? OfferParamConfigService.getInstance().getLoginType() : this.getView().getParentView().getPageCache().get("loginType");
        dataEntity.set("logintype", (Object)loginType);
        if (HRStringUtils.equals((String)loginType, (String)"2") && !dataEntity.getBoolean("isepannex")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"verifycode"});
            dataEntity.set("verifycode", (Object)"");
        }
        if (dataEntity.get("lastreplytime") == null) {
            int lastReplyTimeConfig = OfferParamConfigService.getInstance().getLastReplyTimeConfig();
            dataEntity.set("lastreplytime", (Object)DateUtils.afterNowDateTime((int)lastReplyTimeConfig));
        }
        dataEntity.set("offerid", (Object)offer.getLong("id"));
        dataEntity.set("letterid", (Object)letter.getLong("id"));
        this.showOrHidenMsg(letter);
        this.getModel().setDataChanged(false);
    }

    private void setLastReplyTimeRange(DynamicObject offer) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)this.getControl("lastreplytime");
        DynamicObject letter = offer.getDynamicObject("offerletter");
        Date lastTime = letter.getDate("lastreplytime");
        if (lastTime == null || HRDateTimeUtils.getNowDateTime().getTime() > lastTime.getTime()) {
            int lastReplyTimeConfig = OfferParamConfigService.getInstance().getLastReplyTimeConfig();
            dateTimeEdit.setMaxDate(DateUtils.editDate((Date)HRDateTimeUtils.addDays((int)lastReplyTimeConfig, (Date)HRDateTimeUtils.curUserDateBos((Long)TSCRequestContext.getUserId())), (int)23, (int)59, (int)59));
            this.getPageCache().put("checkLastReplyTime", "1");
            dateTimeEdit.setMinDate(DateUtils.editDate((Date)HRDateTimeUtils.getNextDay((Date)HRDateTimeUtils.curUserDateBos((Long)TSCRequestContext.getUserId())), (int)0, (int)0, (int)0));
            return;
        }
        if (HRDateTimeUtils.getNowDateTime().getTime() <= lastTime.getTime()) {
            this.getModel().setValue("lastreplytime", (Object)lastTime);
            this.getView().setEnable(Boolean.FALSE, new String[]{"lastreplytime"});
            this.getPageCache().put("checkLastReplyTime", "0");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean candidateNoticeOpen = this.getModel().getDataEntity().getBoolean("candidatenoticeopen");
        boolean rcPersonOpen = this.getModel().getDataEntity().getBoolean("rcpersonopen");
        try {
            boolean reportContactPersonMsgOperationResultError;
            if (this.verifyLastReplyTime(args)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            IPageCache cache = this.getView().getParentView().getPageCache();
            if (dataEntity.getBoolean("isgtannex")) {
                log.info("OfferAdvicePlugin.beforeDoOperation.sendOfferAdvice begin");
                OfferAdviceBizHelper.mokaSendOfferAdvice((DynamicObject)dataEntity, (String)this.getVerifyCode());
                List attachments = AttachmentServiceHelper.getAttachments((String)"tso_offerletter", (Object)dataEntity.getLong("letterid"), (String)OFFERLETTER_ATTACHMENTKEY);
                log.info("OfferAdvicePlugin.beforeDoOperation.attachments\uff1a{}", (Object)attachments);
                IAppCache appCache = AppCache.get((String)"offerattach");
                appCache.put(dataEntity.getString("letterid"), (Object)attachments);
                log.info("OfferAdvicePlugin.beforeDoOperation.letterid\uff1a{}", (Object)dataEntity.getString("letterid"));
            }
            OperationResult operationResult = null;
            if (candidateNoticeOpen) {
                String msgPageId = OfferAdviceBizHelper.getParentCache((IPageCache)cache, (String)"cache_msg_tpl_page_id");
                IFormView formView = OfferAdviceBizHelper.getFormViewByCacheKey((String)msgPageId);
                Map customParams = formView.getFormShowParameter().getCustomParams();
                customParams.put("verifycode", this.getVerifyCode());
                customParams.put("sendofferdate", HRInteDateTimeUtil.formatDate((String)"tso_offerletter", (String)"sendtime", (Date)new Date()));
                operationResult = formView.invokeOperation("sendmessage");
                log.info("OfferAdvicePlugin.beforeDoOperation operationResult : {}", (Object)operationResult);
            }
            OperationResult reportContactPersonMsgOperationResult = null;
            if (rcPersonOpen) {
                String reportContactPersonMsgPageId = OfferAdviceBizHelper.getParentCache((IPageCache)cache, (String)"CACHE_REPORT_CONTACT_PERSON_MSG_PAGE_ID");
                IFormView reportContactPersonMsgFormView = OfferAdviceBizHelper.getFormViewByCacheKey((String)reportContactPersonMsgPageId);
                Map reportContactPersonMsgCustomParams = reportContactPersonMsgFormView.getFormShowParameter().getCustomParams();
                reportContactPersonMsgCustomParams.put("verifycode", this.getVerifyCode());
                reportContactPersonMsgCustomParams.put("sendofferdate", HRInteDateTimeUtil.formatDate((String)"tso_offerletter", (String)"sendtime", (Date)new Date()));
                reportContactPersonMsgCustomParams.put("email", this.getModel().getValue("contactemail"));
                reportContactPersonMsgCustomParams.put("phone", this.getModel().getValue("contactphone"));
                reportContactPersonMsgOperationResult = reportContactPersonMsgFormView.invokeOperation("sendmessage");
                log.info("OfferAdvicePlugin.beforeDoOperation reportContactPersonMsgOperationResult : {}", (Object)reportContactPersonMsgOperationResult);
            }
            boolean checkInvokeResult = operationResult != null && !operationResult.isSuccess() && reportContactPersonMsgOperationResult != null && !reportContactPersonMsgOperationResult.isSuccess();
            boolean operationResultError = operationResult != null && !operationResult.isSuccess() && reportContactPersonMsgOperationResult == null;
            boolean bl = reportContactPersonMsgOperationResultError = reportContactPersonMsgOperationResult != null && !reportContactPersonMsgOperationResult.isSuccess() && operationResult == null;
            if (checkInvokeResult || operationResultError || reportContactPersonMsgOperationResultError) {
                log.warn("OfferAdvicePlugin.beforeDoOperation.sendMessage.fail");
                args.setCancelMessage(OfferSendMultiLangConstants.sendOfferFail());
                args.setCancel(true);
            }
        }
        catch (Exception e) {
            args.setCancel(true);
            ErrorCode errorCode = new ErrorCode("OfferAdvicePlugin", OfferSendMultiLangConstants.sendOfferFail());
            log.error("OfferAdvicePlugin.beforeDoOperation:", (Throwable)e);
            throw new KDBizException(errorCode, new Object[]{e});
        }
    }

    private boolean verifyLastReplyTime(BeforeDoOperationEventArgs args) {
        int lastReplyTimeConfig;
        Date maxLastReplyTime;
        if (!this.needCheckLastReplyTime()) {
            return false;
        }
        Date lastReplyTime = this.getModel().getDataEntity(true).getDate("lastreplytime");
        if (lastReplyTime.after(maxLastReplyTime = DateUtils.afterNowDateTime((int)(lastReplyTimeConfig = OfferParamConfigService.getInstance().getLastReplyTimeConfig())))) {
            this.getView().updateView("lastreplytime");
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u6700\u665a\u56de\u590dOffer Letter\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e{\u53c2\u6570\u914d\u7f6e\u7684\u6700\u665a\u56de\u590d\u671f\u9650}\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OfferAdvicePlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        Date date = new Date();
        if (date.after(lastReplyTime)) {
            this.getView().updateView("lastreplytime");
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u6700\u665a\u56de\u590dOffer Letter\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OfferAdvicePlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void previewOfferTemplate(Long offerId, DynamicObject template) {
        DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(offerId);
        DynamicObject offerTemplate = new OfferTemplateHelper().getOfferTemplate((Object)template.getLong("id"));
        String templateContent = offerTemplate.getString("content_tag");
        log.info("previewOfferTemplate templateContent: {}", (Object)templateContent);
        offer.set("templatecontent_tag", (Object)templateContent);
        DynamicObject entity = this.getModel().getDataEntity(true);
        HRDynamicObjectUtils.copy((DynamicObject)entity, (DynamicObject)offer);
        this.showLetter(entity, offer);
    }

    private void showLetter(DynamicObject entity, DynamicObject offer) {
        String content;
        String salaryType = offer.getString("salarytype");
        if ("2".equals(salaryType)) {
            Map salaryMap = OfferAttachmentService.getInstance().getSalaryMap(offer);
            content = OfferAttachmentService.getInstance().generateLetterContent(salaryMap, new DynamicObject[]{offer, entity});
        } else {
            content = OfferAttachmentService.getInstance().generateLetterContent(Boolean.FALSE, new DynamicObject[]{offer, entity});
        }
        IAppCache iAppCache = AppCache.get((String)"tso_offerletterinfo");
        iAppCache.put("richtexteditorap", (Object)content);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("formId", "tso_offerletterinfo");
        proxy.addAction("setSlideBillFormId", map);
        proxy.addAction("showSlideBill", map);
    }

    private IFormView getCandidateMsgFormView() {
        IPageCache cache = this.getView().getParentView().getPageCache();
        String pageId = OfferAdviceBizHelper.getParentCache((IPageCache)cache, (String)"cache_msg_tpl_page_id");
        return OfferAdviceBizHelper.getFormViewByCacheKey((String)pageId);
    }

    private IFormView getReportContactPersonMsgFormView() {
        IPageCache cache = this.getView().getParentView().getPageCache();
        String pageId = OfferAdviceBizHelper.getParentCache((IPageCache)cache, (String)"CACHE_REPORT_CONTACT_PERSON_MSG_PAGE_ID");
        return OfferAdviceBizHelper.getFormViewByCacheKey((String)pageId);
    }

    private String getDesensitizeVerifyCode() {
        IPageCache cache = this.getView().getParentView().getPageCache();
        String verifyCode = OfferAdviceBizHelper.getParentCache((IPageCache)cache, (String)"verifycode");
        String desensitizeContent = verifyCode.substring(1, verifyCode.length() - 1).replaceAll("\\S", "*");
        return verifyCode.charAt(0) + desensitizeContent + verifyCode.charAt(verifyCode.length() - 1);
    }

    private String getVerifyCode() {
        IPageCache cache = this.getView().getParentView().getPageCache();
        return OfferAdviceBizHelper.getParentCache((IPageCache)cache, (String)"verifycode");
    }

    private boolean needCheckLastReplyTime() {
        String checkLastReplyTime = this.getPageCache().get("checkLastReplyTime");
        return HRStringUtils.isNotEmpty((String)checkLastReplyTime) && HRStringUtils.equals((String)checkLastReplyTime, (String)"1");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"template", (String)fieldKey)) {
            long offerId = this.getModel().getDataEntity(true).getLong("offerid");
            DynamicObject offerDy = OfferServiceHelper.getInstance().getOfferById(Long.valueOf(offerId));
            if (!HRObjectUtils.isEmpty((Object)offerDy)) {
                DynamicObject recruScene;
                ArrayList<QFilter> customFilters = new ArrayList<QFilter>();
                QFilter filter = new QFilter("salarydettype", "=", (Object)offerDy.getString("salarytype"));
                customFilters.add(filter);
                DynamicObject recruitType = offerDy.getDynamicObject("recrutyp");
                if (!HRObjectUtils.isEmpty((Object)recruitType)) {
                    customFilters.add(new QFilter("recrutyp", "=", (Object)recruitType.getLong("id")));
                }
                if (Objects.nonNull(recruScene = offerDy.getDynamicObject("recruscene"))) {
                    QFilter recruSceneFilter = new QFilter("mulrecruscene.fbasedataid", "=", (Object)recruScene.getLong("id"));
                    recruSceneFilter.or(new QFilter("mulrecruscene.fbasedataid", "is null", null));
                    customFilters.add(recruSceneFilter);
                }
                long orgId = offerDy.getDynamicObject("busunit").getLong("id");
                List useOrgFilters = ControlledDataCommonHelper.getEnableAndPassStatusQFilter((String)"tsrbd", (String)"tsrbd_offertemplate", (Long)orgId);
                customFilters.addAll(useOrgFilters);
                ListFilterParameter lfp = new ListFilterParameter();
                lfp.setQFilters(customFilters);
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                parameter.setListFilterParameter(lfp);
            }
        }
    }
}

