/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.approve;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferOnlyViewHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferBtnShowService;
import kd.tsc.tso.business.domain.offer.service.OfferPermService;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.approve.OfferApproveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delete.OfferBillDeleteService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.util.OfferShowParamUtils;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.CheckPermFactory;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.OfferApproveCheckPerm;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.ControlledDataCommonHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MokaOfferApprovePlugin
extends HRCoreBaseBillEdit
implements TabSelectListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(MokaOfferApprovePlugin.class);
    private Map<String, Boolean> tabBtnMap;
    private static final String CLOSE_OFFER_CONFIRM_FLAG = "closeOfferConfirm";
    private static final String DELETE_BILL_CONFIRM_FLAG = "deleteBillConfirm";
    private final OfferApproveService approveService = OfferApproveService.Singleton.INSTANCE.getInstance();
    private static final OfferBillDeleteService offerBillDeleteService = OfferBillDeleteService.getInstance();
    private OfferSalaryService offerSalary = new OfferSalaryService();
    private final OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit template = (BasedataEdit)this.getControl("template");
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit depcyType = (BasedataEdit)this.getControl("depcytype");
        depcyType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recruRsn = (BasedataEdit)this.getControl("recrursn");
        recruRsn.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recruScene = (BasedataEdit)this.getControl("recruscene");
        recruScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"preview"});
    }

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        BillShowParameter showParameter = (BillShowParameter)preOpenFormEventArgs.getFormShowParameter();
        if ("tso_somk_waitofferbase".equals(showParameter.getParentFormId()) || "wftask".equals(showParameter.getAppId())) {
            if ("wftask".equals(showParameter.getAppId())) {
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setBillStatus(BillOperationStatus.VIEW);
            }
            LOGGER.info(" approve open fail 1");
            return;
        }
        DynamicObject offerApprove = OfferBillServiceHelper.getInstance().queryOne(showParameter.getPkId());
        DynamicObject busUnit = offerApprove.getDynamicObject("busunit");
        if (busUnit == null || !OfferOnlyViewHelper.checkIsOnlyView((FormShowParameter)showParameter) && !OfferPermService.getInstance().verifyHasPerm("btn_view", "tso_somk_offerbill", Long.valueOf(busUnit.getLong("id")))) {
            preOpenFormEventArgs.setCancel(true);
            preOpenFormEventArgs.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709Offer\u7533\u8bf7\u5355\u7684\u201c\u67e5\u8be2\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OfferBillInfoEdit_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            LOGGER.info(" approve open fail 2");
            return;
        }
        DynamicObjectCollection offerEntity = offerApprove.getDynamicObjectCollection("entryentity");
        DynamicObject offerDy = ((DynamicObject)offerEntity.get(0)).getDynamicObject("offer");
        if (HRObjectUtils.isEmpty((Object)offerDy)) {
            LOGGER.info(" approve open fail 3");
            return;
        }
        if (offerApprove.getBoolean("deletestatus")) {
            preOpenFormEventArgs.setCancel(true);
            preOpenFormEventArgs.setCancelMessage(OfferDeleteMultiLangConstants.dataHasDelete());
            LOGGER.info(" approve open fail 4");
            return;
        }
        String name = "";
        name = null != showParameter.getCustomParam("candidatename") ? showParameter.getCustomParam("candidatename").toString() : offerDy.getString("candidatename");
        LOGGER.info(" approve open fail 5,{}", (Object)name);
        showParameter.setCaption(ResManager.loadKDString((String)"Offer\u7533\u8bf7\u5355-", (String)"OfferBillInfoEdit_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]) + name);
    }

    public void afterBindData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object offerId = customParams.get("offerid");
        LOGGER.info(" approve open fail offerId,{}", offerId);
        long approveId = Long.parseLong(((Object)Optional.ofNullable(customParams.get("approveid")).orElse(0L)).toString());
        LOGGER.info(" approve open fail approveId,{}", (Object)approveId);
        if (approveId == 0L) {
            approveId = this.getApproveId();
        }
        LOGGER.info(" approve open fail approveId2,{}", (Object)approveId);
        DynamicObject approveObj = OfferBillServiceHelper.getInstance().loadSingle((Object)approveId);
        if (offerId == null) {
            DynamicObject entityObj = (DynamicObject)approveObj.getDynamicObjectCollection("entryentity").get(0);
            offerId = entityObj.getLong("offer.id");
        }
        LOGGER.info(" approve open fail offerId2,{}", offerId);
        if (Long.parseLong(offerId.toString()) == 0L) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT), new String[]{"preview"});
        int workAge = this.getModel().getDataEntity(true).getInt("candidateworkage");
        if (!HRObjectUtils.isEmpty((Object)workAge)) {
            String workYear = ResumeAnalysisHelper.getWorkYearShow((int)workAge);
            this.getModel().setValue("workage", (Object)workYear);
        }
        DateTimeEdit dateEdit = (DateTimeEdit)this.getControl("pemploymenttime");
        dateEdit.setMinDate(DateUtils.afterNowDate((int)1));
        DynamicObject offerDynamic = this.offerServiceHelper.loadSingle(offerId);
        this.showOfferHeadPage(approveId);
        this.initTab(approveObj, offerDynamic);
        this.permPageCache();
        this.approveService.showTabContant(offerDynamic, this.tabBtnMap, (AbstractFormPlugin)this, "tsrsc");
        this.initButtonVisible();
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tab_offer");
        this.getModel().setDataChanged(false);
    }

    private void offerSalaryHandle(DynamicObject approveInfo) {
        if (StringUtils.isEmpty((CharSequence)approveInfo.getString("salarytype"))) {
            String salaryType = OfferParamConfigService.getInstance().getSalaryDetType();
            approveInfo.set("salarytype", (Object)salaryType);
        }
        String isHavePeriodTerm = approveInfo.getString("ishaveperiodterm");
        if ("1".equals(approveInfo.getString("salarytype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"salaryinfo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"welfareinfo", "etinfo"});
            if ("1".equals(isHavePeriodTerm)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"prpesalaryinfo", "regsalaryinfo", "pperiodtermunit", "pperiodterm"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"regsalaryinfo"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"prpesalaryinfo", "pperiodtermunit", "pperiodterm"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"salaryinfo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"regsalaryinfo", "prpesalaryinfo", "welfareinfo", "etinfo"});
            if ("0".equals(isHavePeriodTerm)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pperiodtermunit", "pperiodterm"});
            }
            DynamicObjectCollection offerEntity = approveInfo.getDynamicObjectCollection("entryentity");
            long offerId = ((DynamicObject)offerEntity.get(0)).getLong("offer.id");
            String message = this.offerSalary.verifyHasPerm(Long.valueOf(offerId), "tso_somk_offerapproveinfo");
            if ("wftask".equals(this.getView().getFormShowParameter().getAppId())) {
                if (OfferAuditStatus.WAIT_RESUBMIT.getCode().equals(approveInfo.get("billstatus")) && !HRStringUtils.isEmpty((String)message)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"salaryinfo"});
                    this.getView().showErrorNotification(message);
                } else {
                    this.showOfferSalary(approveInfo);
                }
            } else if (HRStringUtils.isEmpty((String)message)) {
                this.showOfferSalary(approveInfo);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"salaryinfo"});
                this.getView().showErrorNotification(message);
            }
        }
    }

    private void showOfferSalary(DynamicObject offerInfo) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"salaryoperate_flex"});
        DynamicObjectCollection offerEntity = offerInfo.getDynamicObjectCollection("entryentity");
        this.offerSalary.showSalaryForm(((DynamicObject)offerEntity.get(0)).getDynamicObject("offer"), this.getView());
    }

    private OperationStatus getPageStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus pageStatus = formShowParameter.getStatus();
        if (pageStatus == OperationStatus.EDIT) {
            return pageStatus;
        }
        return OperationStatus.VIEW;
    }

    private void initButtonVisible() {
        if (OfferOnlyViewHelper.checkIsOnlyView((FormShowParameter)this.getView().getFormShowParameter())) {
            OfferOnlyViewHelper.initButtonVisible((IFormView)this.getView());
            return;
        }
        Pair pair = OfferBtnShowService.getBillShowButtons((IFormView)this.getView());
        this.getView().setVisible(Boolean.TRUE, ((List)pair.getLeft()).toArray(new String[0]));
        this.getView().setVisible(Boolean.FALSE, ((List)pair.getRight()).toArray(new String[0]));
    }

    private long getPkId() {
        long pkId = 0L;
        BillShowParameter offerParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object id = offerParameter.getPkId();
        if (Objects.nonNull(id)) {
            pkId = Long.parseLong(id.toString());
        }
        return pkId;
    }

    private void permPageCache() {
        OfferApproveCheckPerm checkPerm = (OfferApproveCheckPerm)CheckPermFactory.getInstance().getCheckPerm("offerapprove");
        checkPerm.setPermCache(this.getView());
    }

    private IFormView getOfferView() {
        String offerPageId = this.getPageCache().get("offerInfoPageId");
        if (HRStringUtils.isEmpty((String)offerPageId)) {
            LOGGER.error("offerPageId cannot be null");
            return null;
        }
        return this.getView().getView(offerPageId);
    }

    private void initTab(DynamicObject offerBillDy, DynamicObject offerDynamic) {
        this.tabBtnMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRObjectUtils.isEmpty((Object)offerBillDy)) {
            LOGGER.info("MokaOfferApprovePlugin-initTabBtn-offerBillDy is null");
            return;
        }
        String applyContent = offerBillDy.getString("applycontent");
        Map applyContentMap = (Map)JSON.parseObject((String)applyContent, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]);
        LOGGER.info("MokaOfferApprovePlugin-initTabBtn-applyContent:{}", (Object)applyContent);
        Integer originalResume = (Integer)applyContentMap.get("original_resume");
        this.tabBtnMap.put("taboriginrsmtab", originalResume != null && originalResume == 1);
        Integer resume = (Integer)applyContentMap.get("resume");
        this.tabBtnMap.put("tabapprsmtab", resume != null && resume == 1);
        Integer arf = (Integer)applyContentMap.get("arf");
        this.tabBtnMap.put("tabsrscarfmrsm", arf != null && arf == 1);
        Integer appraise = (Integer)applyContentMap.get("appraise");
        this.tabBtnMap.put("tabevaltab", appraise != null && appraise == 1);
        Integer offerLetter = (Integer)applyContentMap.get("offer_letter");
        this.tabBtnMap.put("tabofferletter", offerLetter != null && offerLetter == 1);
        if (this.getControl("embedofferflex").isInvisible()) {
            this.getPageCache().put("offerInfoPageId", this.getView().getPageId());
            this.getPageCache().put("offerid", offerDynamic.getString("id"));
            if ("2".equals(offerDynamic.getString("salarytype"))) {
                this.notMustInput();
            }
            this.isEnable();
            this.offerSalaryHandle(this.getModel().getDataEntity(true));
        } else {
            this.initOffer(offerDynamic.getPkValue());
            this.notMustInput();
        }
    }

    private void isEnable() {
        String isHavePeriodterm = this.getView().getModel().getDataEntity(true).getString("ishaveperiodterm");
        long id = this.getView().getModel().getDataEntity(true).getDynamicObject("laborreltypecls").getLong("id");
        if ("1".equals(isHavePeriodterm)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flex_haveperiodterm"});
        } else if (id == TSOPreDataEnum.LABORRELRELTYPECLS_LABOR.getId() || id == TSOPreDataEnum.LABORRELRELTYPECLS_EMPLOY.getId() || id == TSOPreDataEnum.LABORRELRELTYPECLS_OUT.getId()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flex_haveperiodterm"});
        } else if (id == TSOPreDataEnum.LABORRELRELTYPECLS_REHIRE.getId() || id == TSOPreDataEnum.LABORRELRELTYPECLS_PROBATION.getId()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flex_haveperiodterm"});
        }
        DynamicObject[] mappingEmpRelationType = this.offerServiceHelper.getMappingEmpRelationType(Long.valueOf(id));
        if (mappingEmpRelationType.length == 1) {
            this.getModel().setValue("emprelationtype", (Object)mappingEmpRelationType[0]);
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"emprelationtype"});
    }

    private void notMustInput() {
        DecimalEdit pPeriodTermEdit = (DecimalEdit)this.getView().getControl("pperiodterm");
        pPeriodTermEdit.setMustInput(false);
        DecimalEdit regBwagesEdit = (DecimalEdit)this.getView().getControl("regbwages");
        regBwagesEdit.setMustInput(false);
        DecimalEdit prpeBwagesEdit = (DecimalEdit)this.getView().getControl("prpebwages");
        prpeBwagesEdit.setMustInput(false);
        DecimalEdit prpeSaratioEdit = (DecimalEdit)this.getView().getControl("prpesaratio");
        prpeSaratioEdit.setMustInput(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (operate.getOperateKey().equals("cancel")) {
            this.handleCancelOperate();
        } else if (operate.getOperateKey().equals("bar_delete")) {
            DynamicObject offerApprove = this.getModel().getDataEntity(true);
            String checkResult = offerBillDeleteService.checkCondition(offerApprove);
            if (HRStringUtils.isNotEmpty((String)checkResult)) {
                this.getView().showErrorNotification(checkResult);
                args.setCancel(true);
            } else {
                this.getView().showConfirm(OfferDeleteMultiLangConstants.deleteConfirmBox(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_BILL_CONFIRM_FLAG, (IFormPlugin)this));
            }
        }
    }

    private void handleCancelOperate() {
        OfferEditMutexHelper.releaseMutexIfIsCurrentUser((IFormView)this.getView(), (Long)this.getPkId());
        this.getView().getPageCache().remove("changePeadminOrg");
        IFormView offerView = this.getOfferView();
        if (offerView != null) {
            IPageCache pageCache = offerView.getPageCache();
            pageCache.put("fieldSwitchCacheKey", null);
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)CLOSE_OFFER_CONFIRM_FLAG)) {
            MessageBoxResult result2 = messageBoxClosedEvent.getResult();
            if (result2 == MessageBoxResult.Yes) {
                this.handleCancelOperate();
            }
        } else if (DELETE_BILL_CONFIRM_FLAG.equals(callBackId) && (result = messageBoxClosedEvent.getResult()) == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject offer = OfferBillServiceHelper.getInstance().getOfferByBillDt(dataEntity);
            if (offer.getBoolean("isdelete")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"Offer\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBillBtnSavePlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityId = "";
            entityId = this.getView().getFormShowParameter() instanceof ListShowParameter ? ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId() : this.getView().getFormShowParameter().getFormId();
            if (!PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)"tsrsc", (String)entityId, (String)"4715e1f1000000ac")) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_formmeta");
                DynamicObject dynamicObject = helper.queryOne(new QFilter("number", "=", (Object)entityId).toArray());
                String format = MessageFormat.format(OfferDeleteMultiLangConstants.noPermError(), dynamicObject.getString("name"));
                this.getView().showErrorNotification(format);
                return;
            }
            offerBillDeleteService.deleteBill(this.getModel().getDataEntity(true));
            this.getView().returnDataToParent((Object)OfferDeleteMultiLangConstants.deleteSuccessMokaOfferBill());
            this.getView().close();
        }
    }

    private void initOffer(Object pkId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tso_somk_offerbase");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("embedofferflex");
        showParameter.setPkId(pkId);
        if (null != this.getView().getParentView() && "wftask".equals(this.getView().getParentView().getFormShowParameter().getAppId())) {
            showParameter.setHasRight(true);
        }
        showParameter.setStatus(this.getPageStatus());
        this.getPageCache().put("offerInfoPageId", showParameter.getPageId());
        this.getPageCache().put("offerid", pkId.toString());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Long getApproveId() {
        String approveId = (String)this.getView().getFormShowParameter().getCustomParam("businessKey");
        if (approveId == null) {
            approveId = this.getView().getModel().getDataEntity(true).getString("id");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"approve_panel"});
        }
        return approveId != null ? Long.parseLong(approveId) : 0L;
    }

    private void showOfferHeadPage(Long approveId) {
        FormShowParameter offerHeadInfoParam = OfferShowParamUtils.getOfferHeadInfoParam((Long)approveId, (OperationStatus)OperationStatus.VIEW, (String)"tso_offerhead_bill");
        this.getView().showForm(offerHeadInfoParam);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        if (null == this.getView() || null == this.getView().getParentView()) {
            event.setCheckDataChange(false);
            return;
        }
        FormShowParameter showParameter = this.getView().getParentView().getFormShowParameter();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("invokeSubmit") || "tso_somk_waitofferbase".equals(showParameter.getFormId()) || this.getPageStatus() == OperationStatus.VIEW) {
            event.setCheckDataChange(false);
        } else if (this.getModel().getDataChanged() && this.getPageStatus() != OperationStatus.VIEW) {
            event.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u53d8\u66f4\uff0c\u76f4\u63a5\u53d6\u6d88\u5c06\u4e22\u5931\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u786e\u8ba4\u53d6\u6d88\u5417\uff1f", (String)"OfferInfoAbstractPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CLOSE_OFFER_CONFIRM_FLAG, (IFormPlugin)this));
        } else {
            OfferEditMutexHelper.releaseMutexIfIsCurrentUser((Long)this.getOfferId());
        }
    }

    private long getOfferId() {
        long offerId = 0L;
        DynamicObject offerByBillDt = OfferBillServiceHelper.getInstance().getOfferByBillDt(this.getModel().getDataEntity(true));
        if (!HRObjectUtils.isEmpty((Object)offerByBillDt)) {
            offerId = offerByBillDt.getLong("id");
        }
        LOGGER.info("MokaOfferApprovePlugin.getOfferId\uff1a{}", (Object)offerId);
        return offerId;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter filter;
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"depcytype")) {
            QFilter filter2 = new QFilter("enable", "=", (Object)"1");
            filter2.and(new QFilter("status", "=", (Object)"C"));
            beforeF7SelectEvent.addCustomQFilter(filter2);
        }
        DynamicObject recruTyp = this.getModel().getDataEntity(true).getDynamicObject("recrutyp");
        if (HRStringUtils.equals((String)name, (String)"recrursn")) {
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("group.number", "=", (Object)"1070_S"));
            QFilter recruTypeFilter = new QFilter("recrutyp.fbasedataid", "=", (Object)recruTyp.getLong("id"));
            recruTypeFilter.or(new QFilter("recrutyp.fbasedataid", "=", null));
            filter.and(recruTypeFilter);
            beforeF7SelectEvent.addCustomQFilter(filter);
        }
        if (HRStringUtils.equals((String)name, (String)"recruscene")) {
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("recruitmentcategory.fbasedataid", "=", (Object)recruTyp.getLong("id")));
            beforeF7SelectEvent.addCustomQFilter(filter);
        }
        if (HRStringUtils.equals((String)name, (String)"template")) {
            String salaryType;
            ArrayList<QFilter> customFilters = new ArrayList<QFilter>();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject recruitType = dataEntity.getDynamicObject("recrutyp");
            if (!HRObjectUtils.isEmpty((Object)recruitType)) {
                QFilter recrutypFilter = new QFilter("recrutyp", "=", (Object)recruitType.getLong("id"));
                customFilters.add(recrutypFilter);
            }
            if (HRStringUtils.isNotEmpty((String)(salaryType = this.getModel().getDataEntity(true).getString("salarytype")))) {
                QFilter filter3 = new QFilter("salarydettype", "=", (Object)salaryType);
                beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(filter3));
            }
            long orgId = dataEntity.getDynamicObject("busunit").getLong("id");
            List useOrgFilters = ControlledDataCommonHelper.getEnableAndPassStatusQFilter((String)"tsrbd", (String)"tsrbd_offertemplate", (Long)orgId);
            customFilters.addAll(useOrgFilters);
            DynamicObject recruScene = dataEntity.getDynamicObject("recruscene");
            if (Objects.nonNull(recruScene)) {
                QFilter recruSceneFilter = new QFilter("mulrecruscene.fbasedataid", "=", (Object)recruScene.getLong("id"));
                recruSceneFilter.or(new QFilter("mulrecruscene.fbasedataid", "is null", null));
                customFilters.add(recruSceneFilter);
            }
            ListFilterParameter lfp = new ListFilterParameter();
            lfp.setQFilters(customFilters);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setListFilterParameter(lfp);
        }
    }
}

