/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.btnplugin;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.btnservice.copy.OfferCopyService;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.OfferBaseSaveService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSaveMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;
import kd.tsc.tspr.business.domain.mq.producer.ProducerExecution;
import org.apache.commons.lang3.tuple.Pair;

public class OfferBaseBtnSavePlugin
extends AbstractOfferButtonPlugin {
    private final OfferBaseSaveService saveService = OfferBaseSaveService.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!this.checkIsSaveButton(args)) {
            return;
        }
        boolean isCopyFlag = this.isViewFromCopy();
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW && this.getModel().getDataEntity().getLong("id") != 0L && !isCopyFlag) {
            String message;
            DynamicObject offerDy = OfferServiceHelper.getInstance().queryOne((Object)this.getModel().getDataEntity().getLong("id"));
            if (offerDy.getBoolean("isdelete")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"Offer\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBaseBtnSavePlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("2".equals(offerDy.getString("salarytype")) && !HRStringUtils.isEmpty((String)(message = new OfferSalaryService().verifyHasPerm(Long.valueOf(offerDy.getLong("id")), "tso_somk_waitofferbase")))) {
                this.getView().showErrorNotification(message);
                args.setCancel(true);
            }
        } else if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
            if (appfileId == null) {
                args.setCancel(true);
                return;
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
            DynamicObject appfileDy = serviceHelper.queryOne((Object)Long.parseLong(String.valueOf(appfileId)));
            if (HRObjectUtils.isEmpty((Object)appfileDy)) {
                args.setCancel(true);
                return;
            }
            if (appfileDy.getBoolean("isdelete")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBaseBtnSavePlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.validateApplyEmp(appfileDy)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u7684Offer\u6216\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"OfferBaseBtnSavePlugin_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean validateApplyEmp(DynamicObject appfileDy) {
        long offerStatusId = appfileDy.getLong("offer.status.id");
        if (offerStatusId != 0L && offerStatusId != 1010040L && offerStatusId != 1010050L) {
            return true;
        }
        String inductionStatus = appfileDy.getString("inductioninfo.inductionstatus");
        return !HRStringUtils.isEmpty((String)inductionStatus);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"save") && args.getOperationResult().isSuccess()) {
            boolean executeFlag;
            Pair pair = this.saveService.canSaveOffer(this.getModel().getDataEntity(true), this.getView());
            if (!((Boolean)pair.getLeft()).booleanValue()) {
                this.getView().showTipNotification((String)pair.getRight());
                return;
            }
            Map resultMap = new OfferSalaryService().saveSalary(this.getView(), "save");
            if (!((Boolean)resultMap.get("success")).booleanValue()) {
                if (null == resultMap.get("message")) {
                    OperationResult opResult = (OperationResult)resultMap.get("operation_result");
                    this.getView().showOperationResult(opResult, ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OfferBaseBtnSavePlugin_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)String.valueOf(resultMap.get("message")), (String)"OfferBaseBtnSavePlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            boolean isCopyFlag = this.isViewFromCopy();
            boolean isAddNewFlag = this.isViewFromAdd();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (isCopyFlag) {
                DynamicObject clone = null;
                clone = 0L != dataEntity.getLong("id") ? dataEntity : (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)dataEntity);
                try {
                    clone.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"tso_somk_offerbase", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"tso_somk_offerbase"), null));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                    return;
                }
                Pair saveForCopyPair = this.saveService.saveOfferForCopy(clone);
                executeFlag = (Boolean)saveForCopyPair.getLeft();
                OfferAttachmentService offerAttachmentService = OfferAttachmentService.getInstance();
                offerAttachmentService.saveAttachment(this.getView(), this.getModel(), (Long)saveForCopyPair.getRight());
                this.handleCopy((Pair<Boolean, Long>)saveForCopyPair);
                this.updateAppfileInfo(clone);
            } else {
                if (isAddNewFlag) {
                    try {
                        this.getModel().setValue("number", (Object)CodeRuleServiceHelper.getNumber((String)"tso_somk_offerbase", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"tso_somk_offerbase"), null));
                    }
                    catch (Exception e) {
                        this.getView().showErrorNotification(e.getMessage());
                        return;
                    }
                }
                executeFlag = this.saveService.saveOffer(dataEntity);
                this.saveAttachment();
                this.updateAppfileInfo(this.getModel().getDataEntity());
            }
            if (executeFlag) {
                OfferFieldEditSwitchHelper.getInstance().updateFieldSwitch(this.getView(), Long.valueOf(Long.parseLong(this.getModel().getValue("id").toString())));
                this.getView().getPageCache().remove("changePeadminOrg");
                if (isCopyFlag || isAddNewFlag) {
                    this.getView().showSuccessNotification(OfferSaveMultiLangConstants.saveOfferSuccessFromCopy());
                } else {
                    this.getView().showSuccessNotification(OfferSaveMultiLangConstants.saveOfferSuccess());
                }
                this.changeOperateStatus();
            } else {
                String salaryType = dataEntity.getString("salarytype");
                if ("2".equals(salaryType)) {
                    HashMap contentMap = Maps.newHashMapWithExpectedSize((int)4);
                    contentMap.put("offerCode", dataEntity.getString("number"));
                    contentMap.put("offerId", dataEntity.getLong("id"));
                    contentMap.put("offerStatus", "delete");
                    ProducerExecution.handleExecution((String)"hcdm", (Object)contentMap);
                }
                this.getView().showErrorNotification(OfferSaveMultiLangConstants.saveOfferFail());
            }
        }
    }

    private boolean isViewFromAdd() {
        return this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
    }

    private void updateAppfileInfo(DynamicObject offerDy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        QFilter qFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("appfile.id"));
        DynamicObject appfileDy = serviceHelper.queryOne("id,offer,offerletter", new QFilter[]{qFilter});
        if (!HRObjectUtils.isEmpty((Object)appfileDy)) {
            appfileDy.set("offer_id", (Object)offerDy.getLong("id"));
            appfileDy.set("offerletter_id", (Object)offerDy.getLong("offerletter.id"));
            serviceHelper.update(new DynamicObject[]{appfileDy});
        }
    }

    private void saveAttachment() {
        String attachmentPageId = this.getPageCache().get("offerAttachPageId");
        if (HRStringUtils.isEmpty((String)attachmentPageId)) {
            return;
        }
        IFormView attachmentView = this.getView().getView(attachmentPageId);
        AttachmentPanel panel = (AttachmentPanel)attachmentView.getControl("attachmentpanelap");
        List attachmentData = panel.getAttachmentData();
        HashMap<String, List> attachmentDataMap = new HashMap<String, List>(16);
        attachmentDataMap.put("attachmentpanelap", attachmentData);
        AttachmentServiceHelper.saveTempAttachments((String)"tso_social_offerbase", (Object)this.getModel().getDataEntity(true).getLong("id"), (String)this.getView().getFormShowParameter().getAppId(), attachmentDataMap);
    }

    private boolean isViewFromCopy() {
        return OfferCopyService.getInstance().isViewFromCopy(this.getView());
    }

    private void handleCopy(Pair<Boolean, Long> pair) {
        if (!((Boolean)pair.getLeft()).booleanValue()) {
            return;
        }
        this.saveService.afterSaveSuccessForCopy(this.getView(), ((Long)pair.getRight()).longValue());
    }

    private boolean checkIsSaveButton(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"save");
    }

    private void changeOperateStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (status == OperationStatus.EDIT || status == OperationStatus.ADDNEW) {
            Long offerId = Long.parseLong(this.getModel().getValue("id").toString());
            OfferEditMutexHelper.releaseMutex((Long)offerId);
            formShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }
}

