/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.btnplugin;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferEditMutexHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferFieldEditSwitchHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.OfferIntegrateService;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.approve.OfferApproveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.copy.OfferCopyService;
import kd.tsc.tso.business.domain.offer.service.btnservice.save.OfferBaseSaveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBaseSubmitService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.helper.OfferBaseSubmitHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;
import kd.tsc.tspr.business.domain.mq.producer.ProducerExecution;
import org.apache.commons.lang3.tuple.Pair;

public class OfferBaseBtnSubmitPlugin
extends AbstractOfferButtonPlugin {
    private static final String CLOSE_CALL_BACK_SUBMIT = "closeCallBackBaseSubmit";
    private static final Log LOG = LogFactory.getLog(OfferBaseBtnSubmitPlugin.class);
    private final OfferBaseSubmitService service = OfferBaseSubmitService.getInstance();
    private OfferBaseSubmitHelper submitHelper = OfferBaseSubmitHelper.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!(source instanceof Donothing)) {
            return;
        }
        Donothing donothing = (Donothing)source;
        if (!HRStringUtils.equals((String)donothing.getOperateKey(), (String)"submit")) {
            return;
        }
        boolean isCopyFlag = this.isViewFromCopy();
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW && this.getModel().getDataEntity().getLong("id") != 0L && !isCopyFlag) {
            DynamicObject offerDy = OfferServiceHelper.getInstance().queryOne((Object)this.getModel().getDataEntity().getLong("id"));
            if (offerDy.getBoolean("isdelete")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"Offer\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBaseBtnSubmitPlugin_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            Object appfileId = this.getView().getFormShowParameter().getCustomParam("appfile");
            if (appfileId == null) {
                args.setCancel(true);
                return;
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
            DynamicObject appfileDy = serviceHelper.queryOne((Object)Long.parseLong(String.valueOf(appfileId)));
            if (HRObjectUtils.isEmpty((Object)appfileDy)) {
                args.setCancel(true);
                return;
            }
            if (appfileDy.getBoolean("isdelete")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"OfferBaseBtnSubmitPlugin_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.validateApplyEmp(appfileDy)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u7684Offer\u6216\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"OfferBaseBtnSubmitPlugin_5", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean validateApplyEmp(DynamicObject appfileDy) {
        long offerStatusId = appfileDy.getLong("offer.status.id");
        if (offerStatusId != 0L && offerStatusId != 1010040L && offerStatusId != 1010050L) {
            return true;
        }
        String inductionStatus = appfileDy.getString("inductioninfo.inductionstatus");
        return !HRStringUtils.isEmpty((String)inductionStatus);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"submit") && args.getOperationResult().isSuccess()) {
            DynamicObject offerInfo = this.getModel().getDataEntity(true);
            if (!OfferIntegrateService.verifyIntegrate((DynamicObject)offerInfo, (IFormView)this.getView())) {
                return;
            }
            if (!OfferIntegrateService.verifyPhoneAndEmail((DynamicObject)offerInfo, (IFormView)this.getView()).booleanValue()) {
                return;
            }
            if ((Long)this.getModel().getValue("id") == 0L) {
                DynamicObject appFile = offerInfo.getDynamicObject("appfile");
                DynamicObject[] validOffers = OfferServiceHelper.getInstance().getValidDynamicObjectByAppIdList(Collections.singletonList(appFile.getLong("id")));
                if (validOffers.length > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u7684Offer\u6216\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"OfferBaseBtnSubmitPlugin_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!OfferIntegrateService.verifyDate((DynamicObject)offerInfo, (IFormView)this.getView()).booleanValue()) {
                return;
            }
            if (!OfferIntegrateService.verifyHasSalaryPerm((DynamicObject)offerInfo, (IFormView)this.getView(), (String)"tso_somk_waitofferbase").booleanValue()) {
                return;
            }
            OfferVerifyResult result = this.service.canExecute(offerInfo, this.needSave());
            Map resultMap = new OfferSalaryService().saveSalary(this.getView(), "submit");
            if (!((Boolean)resultMap.get("success")).booleanValue()) {
                if (null == resultMap.get("message")) {
                    OperationResult opResult = (OperationResult)resultMap.get("operation_result");
                    this.getView().showOperationResult(opResult, ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"OfferBaseBtnSubmitPlugin_6", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(String.valueOf(resultMap.get("message")));
                }
                return;
            }
            if (!OfferIntegrateService.verifySalaryStatus((DynamicObject)offerInfo, (IFormView)this.getView()).booleanValue()) {
                return;
            }
            super.handleVerifyResult(result);
        }
    }

    private boolean isViewFromCopy() {
        return OfferCopyService.getInstance().isViewFromCopy(this.getView());
    }

    private boolean needSave() {
        return this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT || this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        boolean needApprove = OfferApproveService.Singleton.INSTANCE.getInstance().isNeedApprove();
        if (needApprove) {
            this.showChooseSubmitInfoForm();
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Pair pair = this.service.mokaSubmitOfferWithoutApprove(dataEntity, this.needSave(), this.isViewFromCopy(), super.getOperateName(), this.getView());
            this.handleCopy((Pair<Boolean, Long>)pair);
            this.handleExecuteResult((Pair<Boolean, Long>)pair);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.isNull(closedCallBackEvent.getReturnData())) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (HRStringUtils.equals((String)actionId, (String)CLOSE_CALL_BACK_SUBMIT)) {
            boolean needApprove = OfferApproveService.Singleton.INSTANCE.getInstance().isNeedApprove();
            if (!needApprove) {
                this.handleSubmit(closedCallBackEvent, dataEntity);
                return;
            }
            Boolean isExistWorkflow = WorkflowServiceHelper.existProcDefByEntityNumber((String)"tso_somk_offerapproveinfo");
            if (!isExistWorkflow.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5de5\u4f5c\u6d41\uff0c\u8bf7\u5148\u5b8c\u6210\u76f8\u5173\u6d41\u7a0b\u914d\u7f6e\u3002", (String)"OfferBaseBtnSubmitPlugin_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
                return;
            }
            this.handleSubmit(closedCallBackEvent, dataEntity);
        } else if (HRStringUtils.equals((String)actionId, (String)"closeOfferBill")) {
            this.closeOfferBill(closedCallBackEvent, dataEntity);
        }
    }

    private IFormView showOfferBill(DynamicObject offerApprove, String applyContent, DynamicObject dataEntity) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.setFormId("tso_somk_offerapproveinfo");
        billShowParameter.getOpenStyle().setTargetKey("offerbillflex");
        billShowParameter.setPkId(offerApprove.getPkValue());
        billShowParameter.setCustomParam("offerid", (Object)dataEntity.getString("id"));
        billShowParameter.setCustomParam("candidatename", (Object)dataEntity.getString("candidatename"));
        billShowParameter.setCustomParam("approveid", offerApprove.getPkValue());
        billShowParameter.setCustomParam("applycontent", (Object)applyContent);
        billShowParameter.setCustomParam("hideOfferLetter", (Object)Boolean.TRUE);
        billShowParameter.setCustomParam("invokeSubmit", (Object)Boolean.TRUE);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeOfferBill"));
        billShowParameter.setSendToClient(false);
        this.getView().showForm((FormShowParameter)billShowParameter);
        IFormView view = this.getView().getView(billShowParameter.getPageId());
        if (view == null || view.getModel() == null) {
            throw new KDBizException("page load fail, plea replaces operator");
        }
        view.getModel().createNewData();
        view.getModel().beginInit();
        for (IDataEntityProperty property : offerApprove.getDataEntityType().getProperties()) {
            try {
                view.getModel().setValue(property.getName(), offerApprove.get(property.getName()));
            }
            catch (Exception e) {}
        }
        view.getModel().endInit();
        return view;
    }

    private void closeOfferBill(ClosedCallBackEvent closedCallBackEvent, DynamicObject dataEntity) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        LOG.info("OfferBaseBtnSubmitPlugin.closedCallBack returnData {} ", (Object)returnData);
        boolean needWfAssignPersons = (Boolean)returnData.get("needWfAssignPersons");
        if (!needWfAssignPersons) {
            return;
        }
        LOG.info("OfferBaseBtnSubmitPlugin.closedCallBack need config wf person \uff1a {}", (Object)returnData);
        DynamicObject offerApprove = OfferBillServiceHelper.getInstance().queryOne(returnData.get("approveId"));
        Pair pair = this.service.mokaSubmitOfferWithApprove(dataEntity, offerApprove, this.needSave(), this.isViewFromCopy(), super.getOperateName(), true, this.getView());
        this.handleCopy((Pair<Boolean, Long>)pair);
        this.handleExecuteResult((Pair<Boolean, Long>)pair);
    }

    private void handleSubmit(ClosedCallBackEvent closedCallBackEvent, DynamicObject dataEntity) {
        String applyContent = (String)closedCallBackEvent.getReturnData();
        OperationResult operationResult = null;
        DynamicObject offerApproveDy = null;
        offerApproveDy = this.submitHelper.updateOfferApprove(dataEntity, applyContent);
        offerApproveDy.set("enable", (Object)"0");
        offerApproveDy.set("id", (Object)ORM.create().genLongId(offerApproveDy.getDynamicObjectType().getName()));
        OfferBillServiceHelper.getInstance().saveOfferBill(offerApproveDy);
        IFormView view = this.showOfferBill(offerApproveDy, applyContent, dataEntity);
        operationResult = view.invokeOperation("approve_submit");
        this.getView().sendFormAction(view);
        LOG.info("OfferBaseBtnSubmitPlugin.closedCallBack {}", (Object)operationResult);
        if (null != operationResult && operationResult.isSuccess() && !operationResult.isNeedWfAssignPersons()) {
            Pair pair = this.service.mokaSubmitOfferWithApprove(dataEntity, offerApproveDy, this.needSave(), this.isViewFromCopy(), super.getOperateName(), false, this.getView());
            this.handleCopy((Pair<Boolean, Long>)pair);
            this.handleExecuteResult((Pair<Boolean, Long>)pair);
        }
    }

    public void handleExecuteResult(Pair<Boolean, Long> pair) {
        Boolean executeFlag = (Boolean)pair.getLeft();
        Long offerId = (Long)pair.getRight();
        if (executeFlag.booleanValue()) {
            this.getView().showSuccessNotification(OfferSubmitMultiLangConstants.submitSuccess());
            BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
            if (!this.isViewFromCopy()) {
                OfferFieldEditSwitchHelper.getInstance().updateFieldSwitch(this.getView(), offerId);
            }
            if (this.needSave()) {
                OfferEditMutexHelper.releaseMutex((Long)offerId);
                showParameter.setStatus(OperationStatus.VIEW);
            }
            OfferAttachmentService offerAttachmentService = OfferAttachmentService.getInstance();
            offerAttachmentService.saveAttachment(this.getView(), this.getModel(), Long.valueOf(0L));
            this.getView().getPageCache().remove("changePeadminOrg");
            this.getView().invokeOperation("refresh");
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String salaryType = dataEntity.getString("salarytype");
            if ("2".equals(salaryType)) {
                HashMap contentMap = Maps.newHashMapWithExpectedSize((int)4);
                contentMap.put("offerCode", dataEntity.getString("number"));
                contentMap.put("offerId", dataEntity.getLong("id"));
                contentMap.put("offerStatus", "delete");
                ProducerExecution.handleExecution((String)"hcdm", (Object)contentMap);
            }
            OfferBaseSubmitHelper.getInstance().rollbackWhenFail(dataEntity);
            this.getView().showErrorNotification(OfferSubmitMultiLangConstants.submitFail());
        }
    }

    private void handleCopy(Pair<Boolean, Long> pair) {
        if (!((Boolean)pair.getLeft()).booleanValue()) {
            return;
        }
        OfferBaseSaveService.getInstance().afterSaveSuccessForCopy(this.getView(), ((Long)pair.getRight()).longValue());
    }

    private void showChooseSubmitInfoForm() {
        FormShowParameter chooseSubmitInfoParam = new FormShowParameter();
        chooseSubmitInfoParam.setFormId("tso_somk_offersubmitpage");
        chooseSubmitInfoParam.getOpenStyle().setShowType(ShowType.Modal);
        chooseSubmitInfoParam.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferBaseSubmitSecondValidator");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_SUBMIT);
        chooseSubmitInfoParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(chooseSubmitInfoParam);
    }
}

