/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.btnplugin;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferAbandonBO;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.btnservice.abandon.OfferBaseAbandonService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferAbandonMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class OfferBtnAbandonPlugin
extends AbstractOfferButtonPlugin {
    private static final String CLOSE_CALLBACK_ABANDON = "close_callback_abandon";
    private OfferBaseAbandonService abandonService = OfferBaseAbandonService.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        DynamicObject[] offerInfos;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (!this.checkAndInitBtn(beforeDoOperationEventArgs)) {
            return;
        }
        if (this.checkExceedBatchMax(beforeDoOperationEventArgs)) {
            return;
        }
        List<Long> ids = this.getSelectedOfferIdList();
        for (DynamicObject offerInfo : offerInfos = OfferServiceHelper.getInstance().query("salarytype", new QFilter[]{new QFilter("id", "in", ids)})) {
            String message;
            if (!"2".equals(offerInfo.getString("salarytype")) || HRStringUtils.isEmpty((String)(message = new OfferSalaryService().verifyHasPerm(Long.valueOf(offerInfo.getLong("id")), "tso_somk_offerbaseinfo")))) continue;
            this.getView().showErrorNotification(message);
            beforeDoOperationEventArgs.setCancel(true);
            break;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("abandon".equals(operateKey) && args.getOperationResult().isSuccess()) {
            super.handleVerifyResult(this.abandonService.canExecute(this.getSelectedOfferIdList()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (!HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)CLOSE_CALLBACK_ABANDON)) {
            return;
        }
        OfferAbandonBO returnData = (OfferAbandonBO)closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        OfferVerifyResult offerVerifyResult = this.getVerifyResultFromCache();
        boolean isSuccess = this.abandonService.abandonOfferAndSendMq(offerVerifyResult.getPassIds(), returnData, super.getOperateName());
        if (!isSuccess) {
            this.getView().showErrorNotification(OfferAbandonMultiLangConstants.abandonFail());
            return;
        }
        if (super.checkIsPartSuccess(offerVerifyResult)) {
            super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
        } else {
            this.getView().showSuccessNotification(OfferAbandonMultiLangConstants.abandonSuccess());
        }
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            listView.refresh();
        } else {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        super.handleverifyresultAllfail(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.showAbandonOfferForm(offerVerifyResult.getPassIds());
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.showAbandonOfferForm(offerVerifyResult.getPassIds());
    }

    private void showAbandonOfferForm(List<Long> passeOfferIds) {
        FormShowParameter abandonOfferShowParam = new FormShowParameter();
        abandonOfferShowParam.setFormId("tso_offerabandon");
        abandonOfferShowParam.getOpenStyle().setShowType(ShowType.Modal);
        abandonOfferShowParam.setCustomParam("pass_offers", (Object)SerializationUtils.toJsonString(passeOfferIds));
        abandonOfferShowParam.setCustomParam("all_offers", (Object)SerializationUtils.toJsonString(this.getSelectedOfferIdList()));
        abandonOfferShowParam.setCustomParam("secondValidatorClass", (Object)"kd.tsc.tso.business.domain.moka.offer.validator.OfferBaseAbandonSecondValidator");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_ABANDON);
        abandonOfferShowParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(abandonOfferShowParam);
    }

    private boolean checkAndInitBtn(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        Object source = beforeDoOperationEventArgs.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"abandon");
    }

    static {
        OPERATE_KEY.add("abandon");
    }
}

