/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.btnplugin;

import java.text.MessageFormat;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.btnservice.delete.OfferBaseDeleteService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferDeleteMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferBtnDeletePlugin
extends AbstractOfferButtonPlugin {
    private static final String KEY_CONFIRM_CALLBACK_DELETE = "deleteOfferConfirm";
    private OfferBaseDeleteService deleteService = OfferBaseDeleteService.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        DynamicObject[] offerInfos;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (!this.checkIsBtnDelete(beforeDoOperationEventArgs)) {
            return;
        }
        if (this.checkExceedBatchMax(beforeDoOperationEventArgs)) {
            return;
        }
        List<Long> ids = this.getSelectedOfferIdList();
        for (DynamicObject offerInfo : offerInfos = OfferServiceHelper.getInstance().query("salarytype", new QFilter[]{new QFilter("id", "in", ids)})) {
            String message;
            if (!"2".equals(offerInfo.getString("salarytype")) || HRStringUtils.isEmpty((String)(message = new OfferSalaryService().verifyHasPerm(Long.valueOf(offerInfo.getLong("id")), "tso_somk_waitofferbase")))) continue;
            this.getView().showErrorNotification(message);
            beforeDoOperationEventArgs.setCancel(true);
            break;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("delete".equals(operateKey) && args.getOperationResult().isSuccess()) {
            if (this.getView() instanceof IListView) {
                OfferVerifyResult offerVerifyResult = this.deleteService.canExecute(this.getSelectedOfferIdList());
                super.handleVerifyResult(offerVerifyResult);
            } else {
                this.getView().showConfirm(String.format(OfferDeleteMultiLangConstants.confirmDeleteOffer(), this.getSelectedOfferIdList().size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_CONFIRM_CALLBACK_DELETE, (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (!HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)KEY_CONFIRM_CALLBACK_DELETE)) {
            return;
        }
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String entityId = "";
        entityId = this.getView().getFormShowParameter() instanceof ListShowParameter ? ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId() : this.getView().getFormShowParameter().getFormId();
        if (!PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (String)"tsrsc", (String)entityId, (String)"4715e1f1000000ac")) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_formmeta");
            DynamicObject dynamicObject = helper.queryOne(new QFilter("number", "=", (Object)entityId).toArray());
            String format = MessageFormat.format(OfferDeleteMultiLangConstants.noPermError(), dynamicObject.getString("name"));
            this.getView().showErrorNotification(format);
            return;
        }
        OfferVerifyResult offerVerifyResult = this.getVerifyResultFromCache();
        boolean deleteFlag = this.deleteService.deleteOfferAndSendMq(offerVerifyResult.getPassIds(), super.getOperateName());
        if (!deleteFlag) {
            this.getView().showErrorNotification(OfferDeleteMultiLangConstants.deleteFail());
            return;
        }
        if (this.checkIsPartSuccess(offerVerifyResult)) {
            super.showBosOperateResultForm(offerVerifyResult.getFailInfos());
        } else {
            this.getView().showSuccessNotification(OfferDeleteMultiLangConstants.deleteSuccess());
        }
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            listView.refresh();
            listView.clearSelection();
        } else {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        super.handleverifyresultAllfail(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.getView().showConfirm(String.format(OfferDeleteMultiLangConstants.confirmDeleteOffer(), this.getSelectedOfferIdList().size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_CONFIRM_CALLBACK_DELETE, (IFormPlugin)this));
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.getView().showConfirm(String.format(OfferDeleteMultiLangConstants.confirmDeleteOffer(), this.getSelectedOfferIdList().size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_CONFIRM_CALLBACK_DELETE, (IFormPlugin)this));
    }

    private boolean checkIsBtnDelete(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        Object source = beforeDoOperationEventArgs.getSource();
        if (!(source instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)source;
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"delete");
    }

    static {
        OPERATE_KEY.add("delete");
    }
}

