/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.btnplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.send.OfferBaseSendService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSendMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;

public class OfferBtnSendPlugin
extends AbstractOfferButtonPlugin {
    private static final Log logger = LogFactory.getLog(OfferBtnSendPlugin.class);
    private static final String SEND_CLOSE_CALL_BACK = "sendOfferClose";
    private OfferBaseSendService service = OfferBaseSendService.getInstance();

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)SEND_CLOSE_CALL_BACK)) {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (!this.checkIsSendButton(beforeDoOperationEventArgs)) {
            return;
        }
        List<Long> offerIdList = this.getSelectedOfferIdList();
        if (offerIdList.size() > 1) {
            this.getView().showTipNotification(OfferSendMultiLangConstants.onlyCanSendOneOfferError());
            beforeDoOperationEventArgs.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("send".equals(afterDoOperationEventArgs.getOperateKey()) && operationResult.isSuccess()) {
            OfferVerifyResult offerVerifyResult = this.service.canExecute(this.getSelectedOfferIdList());
            super.handleVerifyResult(offerVerifyResult);
        }
    }

    @Override
    protected void handleverifyresultAllfail(OfferVerifyResult offerVerifyResult) {
        super.handleverifyresultAllfail(offerVerifyResult);
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        this.showOfferNoticeForm(offerVerifyResult.getPassIds());
    }

    @Override
    protected void handleVerifyResultPartSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultPartSuccess(offerVerifyResult);
        this.showOfferNoticeForm(offerVerifyResult.getPassIds());
    }

    private void showOfferNoticeForm(List<Long> passOfferIds) {
        FormShowParameter sendOfferNoticeParam = new FormShowParameter();
        sendOfferNoticeParam.setFormId("tso_somk_offernoticeinfo");
        sendOfferNoticeParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        sendOfferNoticeParam.setCustomParam("offerid", (Object)passOfferIds.get(0));
        DynamicObject appFile = OfferServiceHelper.getInstance().queryAppFileByOfferId(passOfferIds.get(0));
        if (!HRObjectUtils.isEmpty((Object)appFile)) {
            sendOfferNoticeParam.setCaption(OfferSendMultiLangConstants.adviceCapture() + appFile.getString("name"));
        }
        sendOfferNoticeParam.setPageId(this.getView().getPageId() + "tso_somk_offernoticeinfo" + passOfferIds.get(0));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SEND_CLOSE_CALL_BACK);
        sendOfferNoticeParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(sendOfferNoticeParam);
    }

    private boolean checkIsSendButton(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        if (!(beforeDoOperationEventArgs.getSource() instanceof Donothing)) {
            return false;
        }
        Donothing donothing = (Donothing)beforeDoOperationEventArgs.getSource();
        return HRStringUtils.equals((String)donothing.getOperateKey(), (String)"send");
    }
}

