/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.btnplugin;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.bo.OfferVerifyResult;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferIntegrateService;
import kd.tsc.tso.business.domain.offer.service.approve.OfferApproveService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.OfferBaseSubmitService;
import kd.tsc.tso.business.domain.offer.service.btnservice.submit.helper.OfferBaseSubmitHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSubmitMultiLangConstants;
import kd.tsc.tso.formplugin.web.offer.btnplugin.AbstractOfferButtonPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class OfferCardBtnSubmitPlugin
extends AbstractOfferButtonPlugin {
    private static final String CLOSE_CALL_BACK_SUBMIT = "closeCallBackCardSubmit";
    private static final Log LOG = LogFactory.getLog(OfferCardBtnSubmitPlugin.class);
    private final OfferBaseSubmitService service = OfferBaseSubmitService.getInstance();
    private OfferBaseSubmitHelper submitHelper = OfferBaseSubmitHelper.getInstance();

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs clickEvent) {
        super.beforeDoOperation(clickEvent);
        Object source = clickEvent.getSource();
        if (!(source instanceof Donothing)) {
            return;
        }
        Donothing donothing = (Donothing)source;
        if (!HRStringUtils.equals((String)donothing.getOperateKey(), (String)"submit")) {
            return;
        }
        super.cacheOperateName(donothing.getOperateName().getLocaleValue());
        DynamicObject offerInfo = this.getOfferInfo();
        if (!OfferIntegrateService.verifyIntegrate((DynamicObject)offerInfo, (IFormView)this.getView())) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifyPhoneAndEmail((DynamicObject)offerInfo, (IFormView)this.getView()).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifySalaryStatus((DynamicObject)offerInfo, (IFormView)this.getView()).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        if (!OfferIntegrateService.verifyDate((DynamicObject)offerInfo, (IFormView)this.getView()).booleanValue()) {
            clickEvent.setCancel(true);
            return;
        }
        OfferVerifyResult result = this.service.canExecute(offerInfo, false);
        super.handleVerifyResult(result, clickEvent);
    }

    @Override
    protected void handleVerifyResultAllSuccess(OfferVerifyResult offerVerifyResult) {
        super.handleVerifyResultAllSuccess(offerVerifyResult);
        boolean needApprove = OfferApproveService.Singleton.INSTANCE.getInstance().isNeedApprove();
        if (needApprove) {
            this.showChooseSubmitInfoForm();
        } else {
            Pair pair = this.service.submitOfferWithoutApprove(this.getOfferInfo(), false, false, super.getOperateName());
            this.handleExecuteResult((Boolean)pair.getLeft());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.isNull(closedCallBackEvent.getReturnData())) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
    }

    private void handleExecuteResult(boolean executeFlag) {
        if (executeFlag) {
            this.getView().showSuccessNotification(OfferSubmitMultiLangConstants.submitSuccess());
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showErrorNotification(OfferSubmitMultiLangConstants.submitFail());
        }
    }

    private DynamicObject getOfferInfo() {
        Long offerId = Long.parseLong(this.getModel().getValue("offerid").toString());
        return OfferServiceHelper.getInstance().queryOne((Object)offerId);
    }

    private void showChooseSubmitInfoForm() {
        FormShowParameter chooseSubmitInfoParam = new FormShowParameter();
        chooseSubmitInfoParam.setFormId("tso_sost_offersubmitpage");
        chooseSubmitInfoParam.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_SUBMIT);
        chooseSubmitInfoParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(chooseSubmitInfoParam);
    }
}

