/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.infopage;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferAttachmentService;
import kd.tsc.tso.business.domain.offer.service.approve.OfferApproveService;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.form.AppFileTabHelper;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.CheckPermFactory;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.OfferInfoCheckPerm;

public class OfferBillInfoEdit
extends HRCoreBaseBillEdit
implements TabSelectListener {
    private static final Log log = LogFactory.getLog(OfferBillInfoEdit.class);
    private static final String TAB_ORIGINAL_RESUME = "tab_original_resume";
    private static final String TAB_RESUME = "tab_resume";
    protected static final String TAB_OFFER_LETTER = "tab_letter";
    private static final String TAB_EVALUATE = "tab_evaluate";
    private static final String CLOSE_OFFER_CONFIRM_FLAG = "closeOfferConfirm";
    private static final String TAB_SRSCARFMRSM = "tab_srscarfmrsm";

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        this.permPageCache();
        this.initOtherTabInfo();
    }

    private void permPageCache() {
        OfferInfoCheckPerm checkPerm = (OfferInfoCheckPerm)CheckPermFactory.getInstance().getCheckPerm("offerinfo");
        checkPerm.setPermCache(this.getView());
    }

    private void initOtherTabInfo() {
        boolean isEdit = this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT;
        this.getView().setVisible(Boolean.valueOf(!isEdit), new String[]{TAB_ORIGINAL_RESUME, TAB_RESUME, TAB_OFFER_LETTER, TAB_EVALUATE, TAB_SRSCARFMRSM});
        if (isEdit) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject offer = OfferBillServiceHelper.getInstance().getOfferByBillDt(dataEntity);
        DynamicObject appFile = offer.getDynamicObject("appfile");
        String applyContent = dataEntity.getString("applycontent");
        JSONObject applyContentJson = JSONObject.parseObject((String)applyContent);
        if (Objects.isNull(applyContentJson)) {
            return;
        }
        this.initOfferLetterTabForBill(applyContentJson);
        this.initOriginalResumeTab(appFile, applyContentJson);
        this.initResumeTab(appFile, applyContentJson);
        this.initEvalTab(appFile, applyContentJson);
        this.initSrscarfmrsmTab(appFile, applyContentJson);
    }

    private void initSrscarfmrsmTab(DynamicObject appFile, JSONObject applyContentJson) {
        DynamicObject arfrsmDy;
        if (!Boolean.parseBoolean(this.getView().getPageCache().get("hasAllCandPerm"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_SRSCARFMRSM});
            return;
        }
        if (!applyContentJson.get((Object)"arf").equals(1)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_SRSCARFMRSM});
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)appFile) && !HRObjectUtils.isEmpty((Object)(arfrsmDy = AppFileHelper.queryOne((long)appFile.getLong("id"), (String)"arfrsm")))) {
            long arfrsmId = arfrsmDy.getLong("arfrsm.id");
            this.showArfrsmPage(arfrsmId, TAB_SRSCARFMRSM);
        }
    }

    private void initOfferLetterTabForBill(JSONObject applyContentJson) {
        Object letterFlag = applyContentJson.get((Object)"offer_letter");
        if (Objects.isNull(letterFlag)) {
            return;
        }
        if (!letterFlag.equals(1)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_OFFER_LETTER});
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject offerByBillDt = OfferBillServiceHelper.getInstance().getOfferByBillDt(dataEntity);
        DynamicObject letter = offerByBillDt.getDynamicObject("offerletter");
        if (Objects.nonNull(letter)) {
            this.showLetterForm(letter.getLong("id"));
            return;
        }
        if (Objects.nonNull(offerByBillDt.get("template"))) {
            DynamicObject offer = OfferServiceHelper.getInstance().queryOne((Object)offerByBillDt.getLong("id"));
            String letterContent = OfferAttachmentService.getInstance().getOfferLetterContentByOffer(offer);
            this.showLetterForm(letterContent);
        }
    }

    private void showLetterForm(long letterId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"noletter"});
        FormShowParameter letterParameter = new FormShowParameter();
        letterParameter.setFormId("tso_offerletter_preview");
        letterParameter.getOpenStyle().setTargetKey(TAB_OFFER_LETTER);
        letterParameter.getOpenStyle().setShowType(ShowType.InContainer);
        letterParameter.setCustomParam("letterid", (Object)letterId);
        this.getView().showForm(letterParameter);
    }

    private void showLetterForm(String letterContent) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"noletter"});
        FormShowParameter letterParameter = new FormShowParameter();
        letterParameter.setFormId("tso_offerletter_preview");
        letterParameter.getOpenStyle().setTargetKey(TAB_OFFER_LETTER);
        letterParameter.getOpenStyle().setShowType(ShowType.InContainer);
        letterParameter.setCustomParam("offerid", (Object)this.getOfferId());
        letterParameter.setCustomParam("content", (Object)letterContent);
        this.getView().showForm(letterParameter);
    }

    private void initOriginalResumeTab(DynamicObject appFileDt, JSONObject applyContentJson) {
        if (!Boolean.parseBoolean(this.getView().getPageCache().get("hasAllCandPerm"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_ORIGINAL_RESUME});
            return;
        }
        if (!applyContentJson.get((Object)"original_resume").equals(1)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_ORIGINAL_RESUME});
            return;
        }
        DynamicObject appFile = AppFileDataHelper.queryAppFileById((Object)appFileDt.getLong("id"));
        DynamicObject appress = appFile.getDynamicObject("appres");
        AppFileTabHelper.previewOriginalResume((Object)appFileDt.getLong("id"), (String)TAB_ORIGINAL_RESUME, (DynamicObject)appress, (String)"originresflex", (IFormView)this.getView(), (boolean)false);
    }

    private void initResumeTab(DynamicObject appFileDt, JSONObject applyContentJson) {
        if (!Boolean.parseBoolean(this.getView().getPageCache().get("hasAllCandPerm"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_RESUME});
            return;
        }
        if (!applyContentJson.get((Object)"resume").equals(1)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_RESUME});
            return;
        }
        DynamicObject appFile = AppFileDataHelper.queryAppFileById((Object)appFileDt.getLong("id"));
        DynamicObject appress = appFile.getDynamicObject("appres");
        String appId = this.getView().getFormShowParameter().getAppId();
        if (HRStringUtils.equals((String)"tsrsc", (String)appId)) {
            OfferApproveService.Singleton.INSTANCE.getInstance().ShowResumePage(TAB_RESUME, (AbstractFormPlugin)this, appress);
        } else {
            AppFileTabHelper.showAppResPage((String)TAB_RESUME, (String)"", (AbstractFormPlugin)this, (DynamicObject)appress, (OperationStatus)OperationStatus.VIEW);
        }
    }

    private void initEvalTab(DynamicObject appFile, JSONObject applyContentJson) {
        if (!Boolean.parseBoolean(this.getView().getPageCache().get("hasAllCandPerm"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_EVALUATE});
            return;
        }
        if (!applyContentJson.get((Object)"appraise").equals(1)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_EVALUATE});
            return;
        }
        long appFileId = appFile.getLong("id");
        AppFileTabHelper.initInterviewAssessTab((String)"evalflex", (long)appFileId, (IFormView)this.getView(), (boolean)false);
    }

    private long getOfferId() {
        DynamicObject offerByBillDt = OfferBillServiceHelper.getInstance().getOfferByBillDt(this.getModel().getDataEntity(true));
        if (HRObjectUtils.isEmpty((Object)offerByBillDt)) {
            return 0L;
        }
        return offerByBillDt.getLong("id");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    private void showArfrsmPage(long arfrsmId, String targetKey) {
        BaseShowParameter appResShowParameter = new BaseShowParameter();
        appResShowParameter.setPkId((Object)arfrsmId);
        appResShowParameter.setFormId("tstpm_srscarfmrsm");
        appResShowParameter.setStatus(OperationStatus.VIEW);
        appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        appResShowParameter.setSendToClient(true);
        appResShowParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm((FormShowParameter)appResShowParameter);
    }
}

