/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.moka.infopage;

import java.util.HashMap;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.formplugin.web.offer.AbstractOfferDynamicFramePlugin;

public class OfferInfoHsbsSalaryPlugin
extends AbstractOfferDynamicFramePlugin {
    private final OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long offerId;
        String message;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("salaryitems".equals(operate.getOperateKey()) && !HRStringUtils.isEmpty((String)(message = new OfferSalaryService().verifyHasPerm(offerId = (Long)this.getModel().getValue("offerid"), "tso_offerbase_info")))) {
            this.getView().showErrorNotification(message);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("salaryitems".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.showSalaryFormHandle();
        }
    }

    private void showSalaryFormHandle() {
        Long offerId = (Long)this.getModel().getValue("offerid");
        DynamicObject offerInfo = this.offerServiceHelper.loadSingle((Object)offerId);
        FormShowParameter salaryForm = new FormShowParameter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", offerInfo.getLong("appfile.id"));
        paramMap.put("offerCode", offerInfo.getString("number"));
        if (0L == offerInfo.getLong("id")) {
            offerInfo.set("id", (Object)ORM.create().genLongId(offerInfo.getDynamicObjectType().getName()));
        }
        paramMap.put("offerId", offerInfo.getString("id"));
        salaryForm.setFormId("tso_salarypage");
        salaryForm.setStatus(OperationStatus.VIEW);
        salaryForm.setCustomParams(paramMap);
        salaryForm.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "showSalary"));
        Optional.ofNullable(salaryForm.getOpenStyle()).ifPresent(style -> style.setShowType(ShowType.Modal));
        this.getView().showForm(salaryForm);
    }
}

