/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.subpage;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.offer.service.OfferJobInfoService;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.TSOPreDataEnum;

public class OfferJobInfoEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private final OfferJobInfoService jobInfoService = OfferJobInfoService.getInstance();
    private static final Log LOG = LogFactory.getLog(OfferJobInfoEdit.class);
    private static final String CHANGE_PEADMINORG = "change_peadminorg";

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        DynamicObject peAdminOrgDy = (DynamicObject)this.getModel().getValue("peadminorg");
        if (!HRObjectUtils.isEmpty((Object)peAdminOrgDy)) {
            DynamicObject peCompany = peAdminOrgDy.getDynamicObject("company");
            this.getModel().setValue("pecompany", (Object)peCompany);
        }
    }

    public void afterBindData(EventObject event) {
        Boolean isCopy;
        BasedataEdit pejob;
        super.afterBindData(event);
        String postMode = this.getModel().getValue("postassignmode").toString();
        if ("2".equals(postMode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"peposition"});
            BasedataEdit pePosition = (BasedataEdit)this.getControl("peposition");
            pePosition.setMustInput(true);
            pejob = (BasedataEdit)this.getView().getControl("pejob");
            pejob.setMustInput(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"peposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"pestdposition"});
        }
        if ("3".equals(postMode)) {
            BasedataEdit peStdPosition = (BasedataEdit)this.getControl("pestdposition");
            peStdPosition.setMustInput(true);
            pejob = (BasedataEdit)this.getView().getControl("pejob");
            pejob.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"peposition"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"pestdposition"});
        }
        if ("1".equals(postMode)) {
            BasedataEdit pejob2 = (BasedataEdit)this.getView().getControl("pejob");
            pejob2.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"peposition", "pestdposition", "jobscm"});
        }
        if (!Objects.nonNull(isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")) || !isCopy.booleanValue()) {
            return;
        }
        DynamicObject laborRelTypeClsDy = (DynamicObject)this.getModel().getValue("laborreltypecls");
        if (HRObjectUtils.isEmpty((Object)laborRelTypeClsDy)) {
            return;
        }
        long laborRelTypeClsDyId = laborRelTypeClsDy.getLong("id");
        if (laborRelTypeClsDyId == TSOPreDataEnum.LABORRELRELTYPECLS_PROBATION.getId() || laborRelTypeClsDyId == TSOPreDataEnum.LABORRELRELTYPECLS_REHIRE.getId()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flex_haveperiodterm"});
            this.getModel().setValue("ishaveperiodterm", (Object)"0");
        }
        this.getView().getPageCache().remove("changePeadminOrg");
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit pePosition = (BasedataEdit)this.getControl("peposition");
        pePosition.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit peAdminOrg = (BasedataEdit)this.getControl("peadminorg");
        peAdminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit peCompany = (BasedataEdit)this.getControl("pecompany");
        peCompany.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobScm = (BasedataEdit)this.getControl("jobscm");
        jobScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit peJob = (BasedataEdit)this.getControl("pejob");
        peJob.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supervisor = (BasedataEdit)this.getControl("supervisor");
        supervisor.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit placeWork = (BasedataEdit)this.getControl("placework");
        placeWork.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobLevel = (BasedataEdit)this.getControl("joblevel");
        jobLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobGrade = (BasedataEdit)this.getControl("jobgrade");
        jobGrade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit laborRelTypeCls = (BasedataEdit)this.getControl("laborreltypecls");
        laborRelTypeCls.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empRelationType = (BasedataEdit)this.getControl("emprelationtype");
        empRelationType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit positionType = (BasedataEdit)this.getControl("positiontype");
        positionType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName;
        switch (propertyName = beforeF7SelectEvent.getProperty().getName()) {
            case "peposition": {
                this.jobInfoService.handlePePositionBeforeF7SelectEvt(this.getView(), beforeF7SelectEvent);
                break;
            }
            case "peadminorg": {
                this.jobInfoService.handlePeAdminOrgBeforeF7SelectEvt(beforeF7SelectEvent);
                break;
            }
            case "joblevel": {
                this.jobInfoService.handleJobLevelF7SelectEvt(this.getView(), beforeF7SelectEvent, false);
                break;
            }
            case "jobgrade": {
                this.jobInfoService.handleJobGradeF7SelectEvt(this.getView(), beforeF7SelectEvent, false);
                break;
            }
            case "positiontype": {
                this.jobInfoService.handlePositionTypeF7SelectEvt(this.getView(), beforeF7SelectEvent);
                break;
            }
            case "jobscm": {
                this.jobInfoService.handleJobScmBeforeF7SelectEvt(beforeF7SelectEvent, this.getView());
                break;
            }
            case "pejob": {
                this.jobInfoService.handlePeJobBeforeF7SelectEvt(beforeF7SelectEvent, this.getView());
                break;
            }
            case "emprelationtype": {
                this.jobInfoService.handleEmpRelationTypeBeforeF7SelectEvt(beforeF7SelectEvent, this.getView());
                break;
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.beforePropertyChanged(propertyChangedArgs);
        String name = propertyChangedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"postassignmode")) {
            Object postAssignMode = this.getModel().getValue("postassignmode");
            String postAssignModeCache = SerializationUtils.serializeToBase64((Object)this.getModel().getDataEntity());
            this.getView().getPageCache().put("postassignmode_" + postAssignMode, postAssignModeCache);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        switch (propertyChangedArgs.getProperty().getName()) {
            case "peposition": {
                this.jobInfoService.handlePepositionPropertyChangedEvt(propertyChangedArgs, this.getView());
                break;
            }
            case "peadminorg": {
                this.jobInfoService.handlePeAdminOrgPropertyChangedEvt(this.getView());
                this.handleSalary(propertyChangedArgs);
                break;
            }
            case "jobscm": {
                this.jobInfoService.handleJobScmPropertyChangedEvt(this.getView());
                break;
            }
            case "pejob": {
                this.jobInfoService.handlePeJobPropertyChangedEvt(this.getView());
                break;
            }
            case "laborreltypecls": {
                this.jobInfoService.handleLaborrelTypeClsPropertyChangeEvt(propertyChangedArgs, this.getView());
                break;
            }
            case "ishaveperiodterm": {
                this.jobInfoService.handleHavePeriodTermPropertyChangeEvt(propertyChangedArgs, this.getView());
                break;
            }
            case "pperiodtermunit": {
                this.jobInfoService.handlePeriodTermUnitPropertyChangeEvt(propertyChangedArgs, this.getView());
                break;
            }
            case "pperiodterm": {
                this.jobInfoService.handlePeriodTermPropertyChangeEvt(propertyChangedArgs, this.getView());
                break;
            }
            case "postassignmode": {
                this.jobInfoService.handlePostAssignModePropertyChangeEvt(propertyChangedArgs, this.getView());
                break;
            }
            case "pestdposition": {
                this.jobInfoService.handlePeStdPositionPropertyChangedEvt(this.getView());
                break;
            }
        }
    }

    private void handleSalary(PropertyChangedArgs propertyChangedArgs) {
        if ("2".equals(this.getModel().getDataEntity().get("salarytype"))) {
            String offerId = "";
            if ("tso_somk_offerapproveinfo".equals(this.getView().getFormShowParameter().getFormId())) {
                DynamicObjectCollection offerEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                offerId = ((DynamicObject)offerEntity.get(0)).getDynamicObject("offer").getString("id");
            } else {
                offerId = this.getView().getModel().getDataEntity(true).getString("id");
            }
            String salaryPageId = this.getView().getPageCache().get("salary" + offerId);
            DynamicObject salaryDataEntity = null;
            OperationStatus status = null;
            try {
                IFormView viewNoPlugin = this.getView().getViewNoPlugin(salaryPageId);
                salaryDataEntity = viewNoPlugin.getModel().getDataEntity(true);
                status = viewNoPlugin.getFormShowParameter().getStatus();
            }
            catch (Exception e) {
                LOG.info("saveSalary.getDataEntity.error", (Object)e);
            }
            boolean flag = this.compareSalaryOrg(propertyChangedArgs, salaryDataEntity, status);
            if (flag) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u62df\u5165\u804c\u90e8\u95e8\u5bf9\u5e94\u7684\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u5df2\u53d8\u5316\uff0c\u662f\u5426\u6e05\u7a7a\u5b9a\u85aa\u4fe1\u606f\uff1f", (String)"OfferJobInfoEdit_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_PEADMINORG, (IFormPlugin)this));
            }
        }
    }

    private boolean compareSalaryOrg(PropertyChangedArgs propertyChangedArgs, DynamicObject salaryDataEntity, OperationStatus status) {
        Long businesstypeId = 1050L;
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        DynamicObject newOrg = (DynamicObject)changeData.getNewValue();
        DynamicObject oldOrg = (DynamicObject)changeData.getOldValue();
        if (null == oldOrg && (null == salaryDataEntity || HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("salaryadjorg")))) {
            if (OperationStatus.VIEW == status) {
                this.showSalaryForm();
            }
            return false;
        }
        if (HRObjectUtils.isEmpty((Object)newOrg)) {
            return !HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("salaryadjorg"));
        }
        long peadminorgId = newOrg.getLong("id");
        DynamicObject salaryOrg = new OfferSalaryService().getSalaryOrg(Long.valueOf(peadminorgId), businesstypeId);
        return HRObjectUtils.isEmpty((Object)salaryDataEntity.getDynamicObject("salaryadjorg")) || null == salaryOrg || HRObjectUtils.isEmpty((Object)salaryOrg) || salaryDataEntity.getDynamicObject("salaryadjorg").getLong("id") != salaryOrg.getLong("id");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)CHANGE_PEADMINORG, (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.showSalaryForm();
        }
    }

    private void showSalaryForm() {
        this.getView().getPageCache().put("changePeadminOrg", "1");
        if ("tso_somk_offerapproveinfo".equals(this.getView().getFormShowParameter().getFormId())) {
            DynamicObjectCollection offerEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            new OfferSalaryService().showSalaryForm(((DynamicObject)offerEntity.get(0)).getDynamicObject("offer"), this.getView());
        } else {
            new OfferSalaryService().showSalaryForm(this.getView().getModel().getDataEntity(true), this.getView());
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
            Object peAdminOrgValue = this.getModel().getValue("peadminorg");
            if (peAdminOrgValue == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"peposition"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"joblevel", "jobgrade"});
        }
    }

    private void simpleForm(boolean isSimpleForm) {
        String postassignmode;
        String ishaveperiodterm;
        this.getView().setVisible(Boolean.valueOf(!isSimpleForm), new String[]{"pecompany", "joblevel", "jobgrade", "jobscm", "regprp", "regyearbonus", "regremark", "regpossub", "welfareinfo", "etinfo", "flexpanelap6", "basicinfo", "busunit", "recruposi", "jobduties", "expectedinfo", "recruitinfo", "adminorg", "recruscene", "recrursn", "attachmentinfo"});
        Object salaryType = this.getModel().getValue("salarytype");
        if (null == salaryType) {
            salaryType = OfferParamConfigService.getInstance().getSalaryDetType();
        }
        if ("2".equals(salaryType.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"welfareinfo", "etinfo"});
        }
        if (!"1".equals(ishaveperiodterm = this.getModel().getValue("ishaveperiodterm").toString())) {
            this.getView().setVisible(Boolean.valueOf(!isSimpleForm), new String[]{"flexpanelap2"});
        }
        if ("1".equals(postassignmode = this.getModel().getValue("postassignmode").toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"peposition", "pestdposition", "jobscm"});
        }
        if ("2".equals(postassignmode)) {
            this.getView().setVisible(Boolean.valueOf(!isSimpleForm), new String[]{"pejob", "peadminorg", "jobscm"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"peposition", "jobscm"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"peadminorg"});
        }
        if ("3".equals(postassignmode)) {
            this.getView().setVisible(Boolean.valueOf(!isSimpleForm), new String[]{"pejob", "jobscm"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"peposition"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"pestdposition", "jobscm"});
        }
    }
}

