/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.formplugin.web.offer.subpage;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.AmountEdit;
import kd.bos.mvc.SessionManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.service.btnservice.copy.OfferCopyService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferMultilingualConstants;
import org.apache.commons.lang3.StringUtils;

public class OfferSalaryInfoEdit
extends HRCoreBaseBillEdit {
    private static Set<String> formalSalarySet = new HashSet<String>(3);
    private static Set<String> probationSalarySet = new HashSet<String>(3);
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999.9999");
    private static final String KEY_PRECISION = "amtprecision";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.calculateFormalSalary(null);
        this.calculateProbationSalary(null);
        this.updatePrpeSalaryFieldBySaCalType();
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        this.showAttachmentPage();
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("fromPage")), (String)"appFilePage")) {
            this.showAttachmentPage();
        }
    }

    private void showAttachmentPage() {
        String cacheJsonString;
        IFormView attachmentView;
        FormShowParameter attachmentParameter = new FormShowParameter();
        String pageId = this.getPageCache().get("offerAttachPageId");
        if (StringUtils.isNotEmpty((CharSequence)pageId) && null != (attachmentView = SessionManager.getCurrent().getView(pageId)) && StringUtils.isNotEmpty((CharSequence)(cacheJsonString = attachmentView.getPageCache().get("TampAttCache" + pageId)))) {
            this.getPageCache().put("CACHE_ATTACHMENT_PANEL", cacheJsonString);
        }
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW) && this.getPageCache().get("CACHE_ATTACHMENT_PANEL") != null) {
            this.getPageCache().remove("CACHE_ATTACHMENT_PANEL");
        }
        attachmentParameter.setFormId("tso_social_offerattach");
        attachmentParameter.getOpenStyle().setTargetKey("attachmentinfo");
        attachmentParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        attachmentParameter.getOpenStyle().setShowType(ShowType.InContainer);
        OfferCopyService copyService = OfferCopyService.getInstance();
        if (copyService.isViewFromCopy(this.getView())) {
            BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
            attachmentParameter.setCustomParam("id", showParameter.getPkId());
            attachmentParameter.setCustomParam("iscopy", (Object)true);
        } else if ("tso_somk_offerapproveinfo".equals(this.getView().getFormShowParameter().getFormId())) {
            DynamicObject approveObj = OfferBillServiceHelper.getInstance().loadSingle(this.getModel().getDataEntity(true).get("id"));
            DynamicObject entityObj = (DynamicObject)approveObj.getDynamicObjectCollection("entryentity").get(0);
            Long offerId = entityObj.getLong("offer.id");
            attachmentParameter.setCustomParam("id", (Object)offerId);
        } else {
            attachmentParameter.setCustomParam("id", this.getModel().getDataEntity(true).get("id"));
        }
        this.getView().showForm(attachmentParameter);
        this.getPageCache().put("offerAttachPageId", attachmentParameter.getPageId());
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String name = propertyChangedArgs.getProperty().getName();
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        if ("welpaycu".equals(name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u85aa\u5e01\u522b\u5df2\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5\u798f\u5229\u4fe1\u606f\u662f\u5426\u9700\u8981\u4fee\u6539\u3002", (String)"OfferSalaryInfoEdit_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        }
        if ("regpaycu".equals(name)) {
            this.getModel().setValue("prpepaycu", changeData.getNewValue());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u85aa\u5e01\u522b\u5df2\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5\u85aa\u8d44\u4fe1\u606f\u662f\u5426\u9700\u8981\u4fee\u6539\u3002", (String)"OfferSalaryInfoEdit_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]));
        }
        if (formalSalarySet.contains(name)) {
            this.calculateFormalSalary(name);
        }
        if (probationSalarySet.contains(name)) {
            this.calculateProbationSalary(name);
        }
        if (HRStringUtils.equals((String)name, (String)"prpesacaltype")) {
            this.getModel().setValue("prpemonthly", (Object)BigDecimal.ZERO);
            this.updatePrpeSalaryFieldBySaCalType();
            this.setPrpeMonthyEditTip();
            this.getModel().beginInit();
            this.getModel().setValue("prpebwages", (Object)BigDecimal.ZERO);
            this.getModel().setValue("prpepossub", (Object)BigDecimal.ZERO);
            this.getModel().setValue("prpeprp", (Object)BigDecimal.ZERO);
            this.getModel().setValue("prpesaratio", (Object)BigDecimal.ZERO);
            this.getModel().endInit();
        }
        if (HRStringUtils.equals((String)name, (String)"regmonthly")) {
            Object newValue = changeData.getNewValue();
            if (Objects.isNull(newValue)) {
                this.getModel().setValue("regmonthlyforprpe", (Object)BigDecimal.ZERO);
                return;
            }
            BigDecimal monthSalary = new BigDecimal(newValue.toString());
            if (monthSalary.compareTo(MAX_VALUE) > 0) {
                this.getView().showTipNotification(this.getMonthlyTipInfo());
                this.getModel().beginInit();
                this.getModel().setValue("regbwages", (Object)BigDecimal.ZERO);
                this.getModel().setValue("regpossub", (Object)BigDecimal.ZERO);
                this.getModel().setValue("regprp", (Object)BigDecimal.ZERO);
                this.getModel().setValue("regmonthly", (Object)BigDecimal.ZERO);
                this.getModel().setValue("regmonthlyforprpe", (Object)BigDecimal.ZERO);
                this.getModel().endInit();
            }
        }
    }

    private void setPrpeMonthyEditTip() {
        AmountEdit amountEdit = (AmountEdit)this.getControl("prpemonthly");
        String sacaltype = this.getModel().getDataEntity(true).getString("prpesacaltype");
        Tips tips = null;
        if ("P".equals(sacaltype)) {
            tips = new Tips("text", null, new LocaleString(OfferMultilingualConstants.getRadiofieldTip()), false, null);
        } else if ("F".equals(sacaltype)) {
            tips = new Tips("text", null, new LocaleString(OfferMultilingualConstants.getFixedPayTip()), false, null);
        }
        if (tips != null) {
            amountEdit.addTips(tips);
        }
    }

    private String getPrpeMonthlyTipInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject prpeMonthly = dataEntity.getDynamicObject("prpepaycu");
        int precision = prpeMonthly.getInt(KEY_PRECISION);
        StringBuilder maxBuilder = new StringBuilder("9999999999");
        if (precision > 0) {
            maxBuilder.append('.');
        }
        for (int i = 1; i <= precision; ++i) {
            maxBuilder.append('9');
        }
        return String.format(ResManager.loadKDString((String)"\u8bd5\u7528\u671f\u6708\u85aa\u4e0d\u80fd\u5927\u4e8e%s\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"OfferSalaryInfoEdit_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]), maxBuilder.toString());
    }

    private String getMonthlyTipInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject regPayCu = dataEntity.getDynamicObject("regpaycu");
        int precision = regPayCu.getInt(KEY_PRECISION);
        StringBuilder maxBuilder = new StringBuilder("9999999999");
        if (precision > 0) {
            maxBuilder.append('.');
        }
        for (int i = 1; i <= precision; ++i) {
            maxBuilder.append('9');
        }
        return String.format(ResManager.loadKDString((String)"\u6708\u5ea6\u85aa\u916c\u4e0d\u80fd\u5927\u4e8e%s\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"OfferSalaryInfoEdit_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]), maxBuilder.toString());
    }

    private void calculateFormalSalary(String name) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal monthSalary = BigDecimal.ZERO;
        for (String key : formalSalarySet) {
            monthSalary = monthSalary.add(dataEntity.getBigDecimal(key));
        }
        if (monthSalary.compareTo(MAX_VALUE) > 0 && !HRStringUtils.isEmpty((String)name)) {
            this.getView().showTipNotification(this.getMonthlyTipInfo());
            this.getModel().setValue(name, (Object)BigDecimal.ZERO);
            return;
        }
        this.getModel().setValue("regmonthly", (Object)monthSalary);
        this.getModel().setValue("regmonthlyforprpe", (Object)monthSalary);
        this.calculateProbationSalary(name);
    }

    private void calculateProbationSalary(String name) {
        boolean isFixSalary = !"P".equals(this.getModel().getValue("prpesacaltype"));
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (isFixSalary) {
            BigDecimal monthSalary = BigDecimal.ZERO;
            for (String key : probationSalarySet) {
                monthSalary = monthSalary.add(dataEntity.getBigDecimal(key));
            }
            if (monthSalary.compareTo(MAX_VALUE) > 0 && !HRStringUtils.isEmpty((String)name)) {
                this.getView().showTipNotification(this.getPrpeMonthlyTipInfo());
                this.getModel().setValue(name, (Object)BigDecimal.ZERO);
                return;
            }
            this.getModel().setValue("prpemonthly", (Object)monthSalary);
        } else {
            BigDecimal regMonthSalary = dataEntity.getBigDecimal("regmonthly");
            BigDecimal saratio = dataEntity.getBigDecimal("prpesaratio");
            if (Objects.nonNull(regMonthSalary)) {
                BigDecimal probationSalary = regMonthSalary.multiply(saratio).divide(new BigDecimal(100));
                this.getModel().setValue("prpemonthly", (Object)probationSalary);
            }
        }
    }

    private void updatePrpeSalaryFieldBySaCalType() {
        String sacalType = (String)this.getModel().getValue("prpesacaltype");
        if (StringUtils.isEmpty((CharSequence)sacalType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"prpebwages", "prpepossub", "prpeprp", "prpesaratio", "prpemonthly", "regmonthlyforprpe"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"prpemonthly"});
        this.getView().setVisible(Boolean.valueOf(!"P".equals(sacalType)), new String[]{"prpebwages", "prpepossub", "prpeprp"});
        this.getView().setVisible(Boolean.valueOf("P".equals(sacalType)), new String[]{"prpesaratio", "regmonthlyforprpe", "percent_sign"});
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().setValue("regmonthlyforprpe", this.getModel().getValue("regmonthly"));
        if (!dataChanged) {
            this.getModel().setDataChanged(false);
        }
    }

    static {
        formalSalarySet.add("regbwages");
        formalSalarySet.add("regpossub");
        formalSalarySet.add("regprp");
        probationSalarySet.add("prpebwages");
        probationSalarySet.add("prpepossub");
        probationSalarySet.add("prpeprp");
        probationSalarySet.add("prpesaratio");
    }
}

