/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.mservice.service.offer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tso.business.domain.attachment.AttachmentService;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.mservice.api.offer.AttachmentServiceApi;

public class AttachmentServiceImpl
implements AttachmentServiceApi {
    private static final Log LOG = LogFactory.getLog(AttachmentServiceImpl.class);
    private final OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();
    private static final String PANEL_ATTACHMENTPANELAP = "attachmentpanelap";
    private final AttachmentService attachmentService = AttachmentService.Singleton.INSTANCE.getInstance();

    public List<Map<String, Object>> getOfferAttachmentList(Long appid, Integer attachmentSource) {
        if (appid == null) {
            return new ArrayList<Map<String, Object>>();
        }
        if (attachmentSource == null) {
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject offerObj = this.offerServiceHelper.queryOne(new QFilter("appfile", "=", (Object)appid).toArray());
        if (offerObj == null) {
            return new ArrayList<Map<String, Object>>();
        }
        LOG.info("AttachmentServiceImpl.getOfferAttachmentList offer : {} appid : {}", (Object)offerObj, (Object)appid);
        AttachmentService.AttachmentSource attachmentCode = AttachmentService.AttachmentSource.getCode((Integer)attachmentSource);
        LOG.info("AttachmentServiceImpl.getOfferAttachmentList attachmentCode : {}", (Object)attachmentCode);
        if (attachmentCode == null) {
            return Collections.emptyList();
        }
        return this.attachmentService.getAttachmentList("tso_social_offerbase", offerObj.getPkValue(), PANEL_ATTACHMENTPANELAP, attachmentCode);
    }
}

