/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.mservice.service.offer;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.createoffer.OfferCreateService;
import kd.tsc.tso.business.domain.offer.service.createoffer.SocialRecruitService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferCreateMutiLangConstants;
import kd.tsc.tso.common.dto.createoffer.req.OfferCreateReqDto;
import kd.tsc.tso.common.dto.createoffer.resp.OfferCreateRespDto;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.mservice.service.offer.AbstractCreateOfferService;
import org.apache.commons.lang3.time.StopWatch;

public class CreateSocialOfferServiceImpl
extends AbstractCreateOfferService {
    private static final Log logger = LogFactory.getLog(CreateSocialOfferServiceImpl.class);
    private OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();
    private SocialRecruitService socialService = SocialRecruitService.Singleton.INSTANCE.getInstance();
    private OfferCreateService createService = OfferCreateService.Singleton.INSTANCE.getInstance();

    public String createOfferBatch(String requestParam) {
        super.createOfferBatch(requestParam);
        StopWatch stopWatch = this.startWatchTime();
        List reqVos = JSON.parseArray((String)requestParam, OfferCreateReqDto.class);
        if (reqVos == null || reqVos.isEmpty()) {
            return null;
        }
        this.checkLegality(reqVos);
        LinkedList offerDynamicObList = Lists.newLinkedList();
        reqVos.forEach(reqVo -> {
            DynamicObject offerDynamicOb = this.socialService.initOfferDynamicOb(reqVo);
            this.socialService.initCandidateDyOb(reqVo, offerDynamicOb);
            offerDynamicObList.add(offerDynamicOb);
        });
        Map otherDynamicMap = this.socialService.getOfferBaseInfo((List)offerDynamicObList, reqVos);
        this.createService.initOfferBatch((List)offerDynamicObList, otherDynamicMap);
        LinkedList respList = Lists.newLinkedList();
        offerDynamicObList.forEach(offerDynamicOb -> respList.add(this.getOfferCreateRespVo((DynamicObject)offerDynamicOb)));
        this.stopWatchTime(stopWatch);
        return JSON.toJSONString((Object)respList);
    }

    private void checkValid(OfferCreateReqDto reqVo) {
        if (reqVo.getAppFileId() == null) {
            logger.error("appFileId is null");
        }
        if (reqVo.getBusunitId() == null) {
            logger.error("busunitId is null");
        }
        if (HRStringUtils.isEmpty((String)reqVo.getBusunitName())) {
            logger.error("busunitName is empty");
        }
        if (HRStringUtils.isEmpty((String)reqVo.getUserName())) {
            logger.error("userName is empty");
        }
        if (HRStringUtils.isEmpty((String)reqVo.getEmail())) {
            logger.error("email is empty");
        }
        if (HRStringUtils.isEmpty((String)reqVo.getPhone())) {
            logger.error("phone is empty");
        }
    }

    public void checkLegality(List<OfferCreateReqDto> reqVos) {
        logger.info("print batch create offer request param :{}", (Object)JSON.toJSONString(reqVos));
        this.checkPermit();
        reqVos.forEach(this::checkValid);
        this.checkBatchCreateCondition(reqVos.stream().map(OfferCreateReqDto::getAppFileId).collect(Collectors.toList()));
    }

    private void checkBatchCreateCondition(List<Long> appFileList) {
        DynamicObject[] dynamicObjects = this.offerServiceHelper.getValidDynamicObjectByAppIdList(appFileList);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            throw new KDBizException(OfferCreateMutiLangConstants.offerExist());
        }
    }

    private OfferCreateRespDto getOfferCreateRespVo(DynamicObject offerDynamic) {
        OfferCreateRespDto respDto = OfferCreateRespDto.build().setAppFileId(Long.valueOf(offerDynamic.getLong("appfile"))).setOfferStatus(OfferStatus.PRE_APPLY.getCode()).setOfferId(Long.valueOf(offerDynamic.getLong("id")));
        return respDto;
    }
}

